package com.elitesland.yst.production.sale.service;

import com.elitesland.yst.production.sale.api.service.StatisticsDealerService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.dataturbo.annotation.DataTurboTransfer;
import com.elitesland.yst.dataturbo.service.DataTurboTransferService;
import com.elitesland.yst.dataturbo.service.param.DataTurboProcessParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/06/14
 * @Version 1.0
 * @Content:
 */
@Service
@Slf4j
@DataTurboTransfer("statistics_dealer_pull_order")
public class StatisticsDealerTransferServiceImpl implements DataTurboTransferService {

    @Autowired
    private StatisticsDealerService statisticsDealerService;

    @Override
    public Object transfer(DataTurboProcessParam param) {
        log.info("经销商销售业绩拉取订单DataTurbo参数,时间：{},信息：{}", param);
        /*String docTime = null;
        if(param.getStartParams().get("docTime") != null){
            docTime = String.valueOf(param.getStartParams().get("docTime"));
        }*/

        SaleStatisticsDealerQueryVO queryVO = new SaleStatisticsDealerQueryVO();
        /*if (StringUtils.isNotBlank(docTime)) {
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            LocalDate dateParam = LocalDate.parse(docTime, df);
            queryVO.setDocTime(LocalDateTime.of(dateParam, ConstantsSale.LOCAL_TIME_MAX));
        }*/
        statisticsDealerService.pullOrder(queryVO);
        return new Object();
    }

}
