package com.elitesland.yst.production.sale.service.shop;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitesland.yst.production.sale.api.dto.BipInvItemDTO;
import com.elitesland.yst.production.sale.api.service.shop.*;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateDFindParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderDParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateDVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCartItemRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderDRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktGiftRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderDSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.shop.BipOrderDConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.BipOrderDDO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.entity.MktGiftDO;
import com.elitesland.yst.production.sale.entity.QBipOrderDDO;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.sale.service.LogisticsTemplateDServiceImpl;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/18/9:46
 * @Description:
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class BipOrdeDServiceimpl extends BaseServiceImpl implements BipOrderDService {

    @Autowired
    private BipOrderDRepo bipOrderDRepo;
    @Autowired
    private BipOrderRepo bipOrderRepo;
    @Autowired
    private BipOrderDRepoProc bipOrderDRepoProc;

    @Autowired
    private BipItemService bipItemService;

    @Autowired
    protected JPAQueryFactory jpaQueryFactory;

    private final QBipOrderDDO QbipOrderDDo = QBipOrderDDO.bipOrderDDO;
    @Autowired
    private BipItemSkuRepoProc bipItemSkuRepoProc;

    @Autowired
    private MktGiftRepo mktGiftRepo;

    @Autowired
    private LogisticsTemplateDServiceImpl logisticsTemplateDService;

    @Autowired
    private UdcProvider udcProvider;

    @Autowired
    private MktDiscountGiftRepoProc mktDiscountGiftRepoProc;

    /***
     * @Description: 分页查询
     * @Param: [bipOrderDParmVO]
     * @return: void
     * @Author: wangyinghao
     * @Date: 2021/8/18
     */
    @Override
    public PagingVO<BipOrderDRespVO> findPageOrderD(BipOrderDParmVO bipOrderParmDVO) {
        Page<BipOrderDDO> page = bipOrderDRepo.findAll(where(bipOrderParmDVO), bipOrderParmDVO.getPageRequest());
        List<BipOrderDRespVO> resList = page.getContent().stream().map(BipOrderDConvert.INSTANCE::doToRes).collect(Collectors.toList());
        return PagingVO.<BipOrderDRespVO>builder()
                .total(page.getTotalElements())
                .records(resList)
                .build();
    }

    /***
     * @Description: 查询订单明细
     * @Param: [bipOrderParmDVO]
     * @return: java.util.List<com.elitesland.sale.entity.BipOrderDDo>
     * @Author: wangyinghao
     * @Date: 2021/8/18
     */
    @Override
    public List<BipOrderDRespVO> findOrderD(BipOrderDParmVO bipOrderParmDVO) {
        List<BipOrderDDO> list = jpaQueryFactory.select(QbipOrderDDo)
                .from(QbipOrderDDo)
                .where(where(bipOrderParmDVO))
                .fetch();
        List<BipOrderDRespVO> resList = list.stream().map(BipOrderDConvert.INSTANCE::doToRes).collect(Collectors.toList());

        Map<String, String> uomUdcMap = udcProvider.getValueMapByUdcCode("yst-supp", "UOM");
        for (BipOrderDRespVO vo : resList) {
            vo.setUom(uomUdcMap.get(vo.getUom()));
        }

        return resList;
    }

    /***
     * @Description: 根据订单id 查询订单
     * @Param: [ids]
     * @return: java.util.List<com.elitesland.sale.entity.BipOrderDo>
     * @Author: wangyinghao
     * @Date: 2021/8/18
     */
    @Override
    public List<BipOrderDRespVO> findOrderById(List<Long> ids) {
        List<BipOrderDDO> list = bipOrderDRepo.findAllById(ids);
        List<BipOrderDRespVO> resList = list.stream().map(BipOrderDConvert.INSTANCE::doToRes).collect(Collectors.toList());
        return resList;
    }

    /***
        * @Description:
        * @Param: [orderId]
        * @return: java.util.List<com.elitesland.sale.api.vo.resp.shop.BipOrderDRespVO>
        * @Author: wangyinghao
        * @Date: 2021/9/1
        */
    @Override
    public List<BipOrderDRespVO> fingOrderDByorderId(Long orderId){
        List<BipOrderDDO> list = bipOrderDRepo.findByOrderId(orderId);
        List<BipOrderDRespVO> resList = list.stream().map(BipOrderDConvert.INSTANCE::doToRes).collect(Collectors.toList());
        return resList;
    }


    /***
     * @Description: 更新订单
     * @Param: [bipOrderDos]
     * @return: void
     * @Author: wangyinghao
     * @Date: 2021/8/18
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateOrder(List<BipOrderDSaveVO> bipOrderDSaveVOS) {
        List<BipOrderDDO> list = bipOrderDSaveVOS.stream().map(BipOrderDConvert.INSTANCE::saveToDo).collect(Collectors.toList());
    }


    /**
     * 更新子单状态
     * @param bipOrderDSaveVOS
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateOrderDStatus(List<BipOrderDSaveVO> bipOrderDSaveVOS) {
        List<BipOrderDDO> list = bipOrderDSaveVOS.stream().map(BipOrderDConvert.INSTANCE::saveToDo).collect(Collectors.toList());

        List<BipOrderDDO> bipOrderDDOList = bipOrderDRepo.saveAll(list);
        List<String> distinctStatusList= bipOrderDDOList.stream().map(bipOrderDDo -> {
            return bipOrderDDo.getStatus();
        }).collect(Collectors.toList());

        List<Long> distinctIdList= bipOrderDDOList.stream().map(bipOrderDDo -> {
            return bipOrderDDo.getOrderId();
        }).collect(Collectors.toList());

        if(distinctIdList!=null&&distinctStatusList.size()==1){
            if(distinctIdList!=null&&distinctIdList.size()==1){
                BipOrderDO bipOrderDo=new BipOrderDO();
                bipOrderDo.setId(distinctIdList.get(0));
                bipOrderDo.setStatus(distinctStatusList.get(0));
                bipOrderRepo.save(bipOrderDo);
            }

        }

    }

    /***
     * @Description: 验证明细状态是否一致
     * @Param: [list]
     * @return: java.lang.String
     * @Author: wangyinghao
     * @Date: 2021/8/22
     */
    public String validStatusCompatibility(List<BipOrderDDO> list) {
        String status = "";
        if (list == null || list.isEmpty()) {
            return "no";
        }
        boolean compatibility = true;
        for (int i = 0; i < list.size(); i++) {
            if (StringUtils.isBlank(list.get(i).getStatus())) {
                throw new BusinessException("订单状态不能为空!");
            }
            if (i == 0) {
                status = list.get(i).getStatus();
            } else {
                compatibility = status.equals(list.get(i).getStatus());
                if (!compatibility) {
                    break;
                }
            }
        }
        if (compatibility) {
            return status;
        }
        return "no";
    }

    /***
     * @Description: 逻辑删除---根据id集合删除订单
     * @Param: [ids]
     * @return: void
     * @Author: wangyinghao
     * @Date: 2021/8/18
     */
    @Override
    public void deleteOrderDByIds(List<Long> ids) {
        bipOrderDRepo.deleteOrderDByIds(ids);

    }

    @Override
    public void deleteOrderDById(Long id){
        bipOrderDRepo.deleteOrderDByOrderId(id);
    }

    public void deleteOrderByOrderIds(List<Long> ids) {
        bipOrderDRepo.deleteOrderDByOrderIds(ids);

    }

    /***
     * @Description: 逻辑删除----删除订单
     * @Param: [bipOrderDos]
     * @return: void
     * @Author: wangyinghao
     * @Date: 2021/8/18
     */
    @Override
    public void deleteOrderD(List<BipOrderDSaveVO> bipOrderDSaveVOS) {

        List<BipOrderDDO> list = bipOrderDSaveVOS.stream().map(BipOrderDConvert.INSTANCE::saveToDo).collect(Collectors.toList());
        list.stream().forEach(bipOrderDo -> {
            bipOrderDo.setDeleteFlag(1);
        });
        bipOrderDRepo.deleteInBatch(list);


    }

    @Override
    public ApiResult<Long> countItemSaleNum(Long itemId, LocalDateTime start, LocalDateTime end) {
        if (start == null && end == null) {
            // 所有时间段
            return ApiResult.ok(bipOrderDRepoProc.countItemSaleNum(itemId));
        }

        return ApiResult.ok(bipOrderDRepoProc.countItemSaleNum(itemId, start, end));
    }


    @Override
    public List<BipInvItemDTO> queryItemByOrderId(Long orderId){
        JPAQuery<BipInvItemDTO> where = jpaQueryFactory.select(Projections.bean(BipInvItemDTO.class,
                QbipOrderDDo.itemCode,
                QbipOrderDDo.itemName,
                QbipOrderDDo.buyQty,
                QbipOrderDDo.payAmt,
                QbipOrderDDo.fareAmt,
                QbipOrderDDo.itemSpec,
                QbipOrderDDo.skuId,
                QbipOrderDDo.skuCode,
                QbipOrderDDo.buyAmt,
                QbipOrderDDo.allowBackNum,
                QbipOrderDDo.uom,
                QbipOrderDDo.itemId

        )).from(QbipOrderDDo).where(QbipOrderDDo.orderId.eq(orderId));
        List<BipInvItemDTO> fetch = where.fetch();
        if (fetch == null) {
            fetch = Collections.emptyList();
        }
        return fetch;
    }
    /***
     * @Description: 根据DO  封装查询条件
     * @Param: [bipOrderDParmVO]
     * @return: org.springframework.data.jpa.domain.Specification
     * @Author: wangyinghao
     * @Date: 2021/8/18
     */
    public Predicate where(BipOrderDParmVO bipOrderDParmVO) {
        Predicate predicate = QbipOrderDDo.isNotNull();

        if (Objects.nonNull(bipOrderDParmVO)) {
            if(Objects.nonNull(bipOrderDParmVO.getOrderId())){
                predicate= ExpressionUtils.and(predicate,QbipOrderDDo.orderId.eq(bipOrderDParmVO.getOrderId()));
            }
            if (Objects.nonNull(bipOrderDParmVO.getFreeFare())) {
                predicate = ExpressionUtils.and(predicate, QbipOrderDDo.freeFare.eq( bipOrderDParmVO.getFreeFare() ));

            }

            if (StringUtils.isNotBlank(bipOrderDParmVO.getItemBrand())) {
                predicate = ExpressionUtils.and(predicate, QbipOrderDDo.itemBrand.like("%" + bipOrderDParmVO.getItemBrand() + "%"));

            }

            if (StringUtils.isNotBlank(bipOrderDParmVO.getItemCode())) {
                predicate = ExpressionUtils.and(predicate, QbipOrderDDo.itemCode.like("%" + bipOrderDParmVO.getItemCode() + "%"));

            }

            if (StringUtils.isNotBlank(bipOrderDParmVO.getItemName())) {
                predicate = ExpressionUtils.and(predicate, QbipOrderDDo.itemName.like("%" + bipOrderDParmVO.getItemName() + "%"));

            }

            if (StringUtils.isNotBlank(bipOrderDParmVO.getItemTitle())) {
                predicate = ExpressionUtils.and(predicate, QbipOrderDDo.itemTitle.eq(bipOrderDParmVO.getItemTitle()));

            }

            if (StringUtils.isNotBlank(bipOrderDParmVO.getLogisNo())) {
                predicate = ExpressionUtils.and(predicate, QbipOrderDDo.logisNo.like("%" + bipOrderDParmVO.getLogisNo() + "%"));

            }

//            if(Objects.nonNull(bipOrderDParmVO.getApplyBackAmt())){
//                predicate=ExpressionUtils.and(predicate,QbipOrderDDo.applyBackAmt.eq(bipOrderDParmVO.getApplyBackAmt()));
//
//            }

            if (StringUtils.isNotBlank(bipOrderDParmVO.getOrderDocNo())) {
                predicate = ExpressionUtils.and(predicate, QbipOrderDDo.orderDocNo.eq(bipOrderDParmVO.getOrderDocNo()));

            }
//
//            if(Objects.nonNull(bipOrderDParmVO.getApproveTime())){
//                predicate=ExpressionUtils.and(predicate,QbipOrderDDo.approveTime.eq(bipOrderDParmVO.getApproveTime()));
//
//            }

//            if(Objects.nonNull(bipOrderDParmVO.getApproveBackAmt())){
//                predicate=ExpressionUtils.and(predicate,QbipOrderDDo.applyBackAmt.eq(bipOrderDParmVO.getApproveBackAmt()));
//
//            }
//
//            if(Objects.nonNull(bipOrderDParmVO.getApproveUserId())){
//                predicate=ExpressionUtils.and(predicate,QbipOrderDDo.approveUserId.eq(bipOrderDParmVO.getApproveUserId()));
//
//            }
//
//            if(Objects.nonNull(bipOrderDParmVO.getSignTime())){
//                predicate=ExpressionUtils.and(predicate,QbipOrderDDo.signTime.eq(bipOrderDParmVO.getSignTime()));
//
//            }

            if (StringUtils.isNotBlank(bipOrderDParmVO.getStatus())) {
                predicate = ExpressionUtils.and(predicate, QbipOrderDDo.status.eq(bipOrderDParmVO.getStatus()));

            }

            if (StringUtils.isNotBlank(bipOrderDParmVO.getCouponId())) {
                predicate = ExpressionUtils.and(predicate, QbipOrderDDo.couponId.like("%" + bipOrderDParmVO.getCouponId() + "%"));

            }

//            if(Objects.nonNull(bipOrderDParmVO.getMktDiscountOffsetId())){
//                predicate=ExpressionUtils.and(predicate,QbipOrderDDo.discountOffsetId.eq(bipOrderDParmVO.getMktDiscountOffsetId()));
//
//            }
//
//            if(StringUtils.isNotBlank(bipOrderDParmVO.getCouponCode())){
//                predicate=ExpressionUtils.and(predicate,QbipOrderDDo.couponCode.like("%" + bipOrderDParmVO.getCouponCode() + "%"));
//
//            }
//
//            if(StringUtils.isNotBlank(bipOrderDParmVO.getDiscountOffsetCode())){
//                predicate=ExpressionUtils.and(predicate,QbipOrderDDo.discountOffsetCode.like("%" + bipOrderDParmVO.getDiscountOffsetCode() + "%"));
//
//            }

//            if(StringUtils.isNotBlank(bipOrderDParmVO.getShipperName())){
//                predicate=ExpressionUtils.and(predicate,QbipOrderDDo.shipperName.like("%" + bipOrderDParmVO.getShipperName() + "%"));
//
//            }
//
//            if(StringUtils.isNotBlank(bipOrderDParmVO.getShipperTel())){
//                predicate=ExpressionUtils.and(predicate,QbipOrderDDo.shipperTel.like("%" + bipOrderDParmVO.getShipperTel() + "%"));
//
//            }
//
//
//            if(StringUtils.isNotBlank(bipOrderDParmVO.getReceiverName())){
//                predicate=ExpressionUtils.and(predicate,QbipOrderDDo.receiverName.like("%" + bipOrderDParmVO.getReceiverName() + "%"));
//
//            }
//
//            if(StringUtils.isNotBlank(bipOrderDParmVO.getReceiverTel())){
//                predicate=ExpressionUtils.and(predicate,QbipOrderDDo.receiverTel.like("%" + bipOrderDParmVO.getReceiverTel() + "%"));
//
//            }

        }
        return predicate;
    }

    /***
        * @Description: 生成订单明细
        * @Param: [bipCartItemRespVOS]
        * @return: java.util.List<com.elitesland.sale.entity.BipOrderDDo>
        * @Author: wangyinghao
        * @Date: 2021/9/10
        */
    public List<BipOrderDDO> createOrder(List<BipCartItemRespVO> bipCartItemRespVOS) {

        List<BipOrderDDO> bipOrderDDOList =new ArrayList<>();

        int lineNo=1;
        for (BipCartItemRespVO bipCartItemRespVO : bipCartItemRespVOS) {
            Long itemId = bipCartItemRespVO.getItemId();
            Long skuId=bipCartItemRespVO.getItemSkuRespVO().getId();

            if (bipItemSkuRepoProc.findFreezeStatus(skuId)){
                throw new BusinessException("销售冻结状态的商品不能购买");
            }

            //减库存
            Long qty = bipCartItemRespVO.getItemNum();
            bipItemService.incrementStock(skuId,-qty.intValue());
            //减赠品库存
            if(null != bipCartItemRespVO.getGiftCodes() && !bipCartItemRespVO.getGiftCodes().isEmpty()){
                List<Long> giftCodes = Arrays.asList(bipCartItemRespVO.getGiftCodes().split(","))
                        .stream().map(a->Long.parseLong(a)).collect(Collectors.toList());
                List<MktGiftDO> giftList = mktGiftRepo.findByIdIn(giftCodes);
                List<Long> giftIds = giftList.stream().filter(a->a.getId()!=null).map(MktGiftDO::getId).collect(Collectors.toList());
                mktGiftRepo.updateMktGiftById(giftIds);
            }

            BipOrderDDO bipOrderDDo=new BipOrderDDO();
            bipOrderDDo.setLineNo(lineNo);
            lineNo++;
            bipOrderDDo.setBuyQty(qty);

            //构造订单商品信息
            bulidOrderDitemInfo(bipCartItemRespVO,bipOrderDDo);

            log.info("下单时，订单信息数据源："+ JSON.toJSONString(bipCartItemRespVO));
            log.info("下单时，创建的订单信息："+ JSON.toJSONString(bipOrderDDo));

            //构造商品促销信息

//            buildOrderDFareInfo(bipCartItemRespVO,bipOrderDDo);

            buildOrderDiscountOffsetInfo(bipCartItemRespVO,bipOrderDDo);

            buildOrderDCouponInfo(bipCartItemRespVO,bipOrderDDo);
            if(null != bipOrderDDo.getFareAmt() && bipOrderDDo.getFareAmt().compareTo(BigDecimal.ZERO) < 0){
                bipOrderDDo.setFareAmt(BigDecimal.ZERO);
            }
            if(null != bipOrderDDo.getPayAmt() && bipOrderDDo.getPayAmt().compareTo(BigDecimal.ZERO) < 0){
                bipOrderDDo.setPayAmt(BigDecimal.ZERO);
            }

            bipOrderDDo=bipOrderDRepo.save(bipOrderDDo);

            bipOrderDDOList.add(bipOrderDDo);
            //买赠下单时反查赠品信息方法注释(改为下单前查询展示到前端，下单时前端返回)
            //此时说明有赠品，构建赠品订单，且设置pid
//            if(bipCartItemRespVO.getMktGiftRespVO()!=null){
//                MktGiftRespVO mktGiftRespVO=bipCartItemRespVO.getMktGiftRespVO();
//                BipOrderDDO giftBipOrderDDO =new BipOrderDDO();
//                bulidOrderDGiftInfo( mktGiftRespVO, giftBipOrderDDO);
//                giftBipOrderDDO.setPid(bipOrderDDo.getId());
//                bipOrderDDOList.add(giftBipOrderDDO);
//            }
        }
        return bipOrderDDOList;
    }


    /***
        * @Description: 商品基本信息
        * @Param: [bipItemRespVO, bipOrderDDo]
        * @return: void
        * @Author: wangyinghao
        * @Date: 2021/8/31
        */
    public void bulidOrderDitemInfo(BipCartItemRespVO bipCartItemRespVO , BipOrderDDO bipOrderDDo) {

        //商品基本信息
        bipOrderDDo.setItemId(bipCartItemRespVO.getItemId());
        bipOrderDDo.setItemCode(bipCartItemRespVO.getItemCode());
        bipOrderDDo.setItemName(bipCartItemRespVO.getItemName());
        bipOrderDDo.setItemBrand(bipCartItemRespVO.getItemSkuRespVO().getBrand());
        bipOrderDDo.setItemBrand(bipCartItemRespVO.getItemSkuRespVO().getBarcode());

        bipOrderDDo.setUom(bipCartItemRespVO.getUom());

        bipOrderDDo.setItemSpec(bipCartItemRespVO.getItemSkuRespVO().getSpec());

        bipOrderDDo.setItemTitle(bipCartItemRespVO.getTitle());

        bipOrderDDo.setRelateItemId(bipCartItemRespVO.getRelateItemId());

        bipOrderDDo.setItemPicFileCode(bipCartItemRespVO.getMainPicFileCode());

        bipOrderDDo.setBasePrice(bipCartItemRespVO.getItemSkuRespVO().getPrice());
        bipOrderDDo.setCustPrice(bipCartItemRespVO.getCustPrice());

        bipOrderDDo.setFreeFare(bipCartItemRespVO.getFareFree());
        bipOrderDDo.setFareTmplId(bipCartItemRespVO.getFareTmplId());

        bipOrderDDo.setItemPicFileCode(bipCartItemRespVO.getMainPicFileCode());

        bipOrderDDo.setSkuId(bipCartItemRespVO.getSkuId());
        bipOrderDDo.setSkuCode(bipCartItemRespVO.getSkuCode());
        bipOrderDDo.setItemType(UdcEnum.ITM_ITM_TYPE_10.getValueCode());

        bipOrderDDo.setMateriel(bipCartItemRespVO.getMateriel());
        bipOrderDDo.setType(bipCartItemRespVO.getType());

        bipOrderDDo.setFreeFare(bipCartItemRespVO.getFareFree());
        bipOrderDDo.setFareAmt(bipCartItemRespVO.getFareArm());
        bipOrderDDo.setGiftCodes(bipCartItemRespVO.getGiftCodes());

        BigDecimal price = bipCartItemRespVO.getCustPrice() == null ?  bipCartItemRespVO.getItemSkuRespVO().getPrice() : bipCartItemRespVO.getCustPrice();
        bipOrderDDo.setItemAmt(price.multiply(BigDecimal.valueOf(bipOrderDDo.getBuyQty())));
    }


    /***
     * @Description: 赠品基本信息
     * @Param: [bipItemRespVO, bipOrderDDo]
     * @return: void
     * @Author: wangyinghao
     * @Date: 2021/8/31
     */
    public void bulidOrderDGiftInfo(MktGiftRespVO mktGiftRespVO , BipOrderDDO bipOrderDDo) {

        Long itemId = mktGiftRespVO.getItemId();
        String skuCode = mktGiftRespVO.getSkuCode();
        //查询商品信息判断库存是够可用
        MktGiftDO mktGiftDO = mktGiftRepo.findMktGiftDOByIdAndSkuCode(itemId, skuCode);
        Long qty =1L;
        if (mktGiftDO.getStockNum() > qty) {
            mktGiftRepo.updateMktGiftStoucNum(qty, itemId, skuCode);
        }else{
            throw new BusinessException("赠品库存不足!");
        }

        //商品基本信息
        bipOrderDDo.setItemId(mktGiftRespVO.getDiscountGiftItemId());
        bipOrderDDo.setRelateItemId(mktGiftRespVO.getItemId());
        bipOrderDDo.setItemCode(mktGiftRespVO.getItemCode());
        bipOrderDDo.setSkuCode(mktGiftRespVO.getSkuCode());
        bipOrderDDo.setItemName(mktGiftRespVO.getItemName());
        bipOrderDDo.setItemType(UdcEnum.ITM_ITM_TYPE_30.getValueCode());
        bipOrderDDo.setBuyQty(1L);

    }

    /**
     * 构建订单满减折扣信息
     * @param bipCartItemRespVO
     * @param bipOrderDDo
     */
    public void buildOrderDiscountOffsetInfo(BipCartItemRespVO bipCartItemRespVO, BipOrderDDO bipOrderDDo){
        if(Objects.nonNull(bipCartItemRespVO.getMktDiscountOffsetId())&&
        Objects.nonNull(bipCartItemRespVO.getMktDiscountOffsetDId())){
            bipOrderDDo.setDiscountOffsetCode(bipCartItemRespVO.getMktDiscountOffsetCode());
            bipOrderDDo.setDiscountOffsetDId(bipCartItemRespVO.getMktDiscountOffsetDId());
            bipOrderDDo.setDiscountOffsetId(bipCartItemRespVO.getMktDiscountOffsetId());
            bipOrderDDo.setDiscountAmt(bipCartItemRespVO.getMktDiscountOffsetFreeAmt());
        }
    }


    /**
     *构建订单优惠券信息
     * @param bipCartItemRespVO
     * @param bipOrderDDo
     */
    public void buildOrderDCouponInfo(BipCartItemRespVO bipCartItemRespVO, BipOrderDDO bipOrderDDo){

//        List<Long> ids=bipCartItemRespVO.getCouponIds();
//        if(ids!=null&&!ids.isEmpty()){
//            bipOrderDDo.setCouponAmt(bipCartItemRespVO.getCouponAmt());
//            String couponIds=ids.stream().map(id->{
//                return String.valueOf(id);
//            }).collect(Collectors.joining(","));
//
//            bipOrderDDo.setCouponId(couponIds);
//        }
//        //设置优惠券状态为已经使用
//        ids.stream().forEach(id->{
//            bipCouponCustService.paySuccessUpdateCouponStatus(id);
//        });
    }


    /**
     * 构建订单运费信息
     * @param bipOrderDDo
     */
    public void buildOrderDFareInfo(BipCartItemRespVO bipCartItemRespVO,BipOrderDDO bipOrderDDo){
        //构造运费信息
        LogisticsTemplateDFindParam logisticsTemplateDFindParam=new LogisticsTemplateDFindParam();
        if(bipCartItemRespVO.getFareTmplId()==null){
            throw new BusinessException("收货地址不能为空!");
        }
        logisticsTemplateDFindParam.setArea(bipCartItemRespVO.getBipAddressVO().getArea());
        logisticsTemplateDFindParam.setTemplateId(bipOrderDDo.getFareTmplId());
        List<LogisticsTemplateDFindParam> params=new ArrayList<>();
        params.add(logisticsTemplateDFindParam);

        bipOrderDDo.setFreeFare(true);
        if(bipOrderDDo.getFreeFare()!=null &&bipOrderDDo.getFreeFare()==false){
            List<LogisticsTemplateDVO>  result=logisticsTemplateDService.getByArea(logisticsTemplateDFindParam);
            if(result!=null && !result.isEmpty()){

                LogisticsTemplateDVO logisticsTemplateDVO=result.get(0);
                //增加运费
                BigDecimal incAmt=logisticsTemplateDVO.getAddFreight();
                //默认运费
                BigDecimal baseAmt=logisticsTemplateDVO.getDefFreight();
                //默认件数
                Integer baseNum=logisticsTemplateDVO.getPieceNumber();
                // 续件数
                Integer incNum=logisticsTemplateDVO.getContinuypieceNumber();
                //商品件数
                Long itemNum=bipOrderDDo.getBuyQty();


                Long num=itemNum-baseNum;
                BigDecimal inc=BigDecimal.valueOf(num).divide(BigDecimal.valueOf(incNum),0, RoundingMode.UP);

                BigDecimal fareAmt=baseAmt.add(incAmt.multiply(inc));

                bipOrderDDo.setFareAmt(fareAmt);
            }
        }else{
            bipOrderDDo.setFareAmt(BigDecimal.ZERO);
        }
    }



    }
