package com.elitesland.yst.production.sale.controller.shop;


import com.elitesland.yst.production.sale.api.service.shop.BipCouponService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponIndexImgVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponOrderVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouPonIndexShowVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipCouponSaveVO;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import org.springframework.web.bind.annotation.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.val;

import java.util.List;


/**
 * <p>
 * 优惠卷控制器
 * </p>
 *
 * @author Shadow
 * @since 2021-08-11 09:45:54
 */
@RestController
@RequestMapping("/bip/coupon")
@Api(value = "优惠券", tags = {"优惠券"})
@RequiredArgsConstructor
public class BipCouponController {

    private final BipCouponService bipCouponService;


    /**
     * 查优惠券背景图
     * @return 查修优惠券背景图
     */
    @PostMapping("/searchBackImg")
    @ApiOperation("查修优惠券背景图")
    public ApiResult<BipCouponIndexImgVO> searchBackImg() {
        BipCouponIndexImgVO vo = bipCouponService.searchBackImg();
        return ApiResult.ok(vo);
    }

    /**
     * 背景图地址修改/保存
     * @return 背景图地址修改/保存
     */
    @PostMapping("/saveBackImg")
    @ApiOperation("背景图地址修改/保存")
    public ApiResult<Object> saveBackImg(@RequestBody BipCouponIndexImgVO bipCouponIndexImgVO) {
        return ApiResult.ok(bipCouponService.saveBackImg(bipCouponIndexImgVO));
    }
    /**
     * 背景图地址修改/保存
     * @return 背景图地址修改/保存
     */
    @DeleteMapping("/delBackImg")
    @ApiOperation("背景图地址删除")
    public ApiResult<Object> delBackImg() {
        return ApiResult.ok(bipCouponService.delBackImg());
    }


    /**
     * 移动端查询优惠券
     *
     * @return 移动端查询优惠券
     */
    @GetMapping("/findCouponIndexShow")
    @ApiOperation("移动端查询优惠券")
    ApiResult<BipCouPonIndexShowVO> findCouponIndexShow() {
        BipCouPonIndexShowVO vo = bipCouponService.findCouponIndexShow();
        return ApiResult.ok(vo);
    }


    /**
     * 新增数据
     *
     * @param param 新增数据
     * @return 新增数据情况
     */
    @PostMapping("/createOne")
    @ApiOperation("新增数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "param", value = "新增数据", required = true, dataType = "BipCouponSaveVO")
    })
    public ApiResult<Object> createOne(@RequestBody BipCouponSaveVO param) {
        return ApiResult.ok(bipCouponService.createOne(param));
    }


    /**
     * 查询单条数据
     *
     * @return 查询单条数据
     */
    @GetMapping("/findById/{id}")
    @ApiOperation("查询单条数据")
    public ApiResult<BipCouponSaveVO> findById(@PathVariable Long id) {
        BipCouponSaveVO  bipCouponSaveVO = bipCouponService.findById(id);
        return ApiResult.ok(bipCouponSaveVO);
    }

    /**
     * 优惠券激活
     *
     * @return 优惠券激活
     */
    @PutMapping("/activeCoupon")
    @ApiOperation("优惠券激活")
    public ApiResult<BipCouponSaveVO> activeCoupon(@RequestBody List<Long> id) {
        bipCouponService.activeCoupon(id);
        return ApiResult.ok();
    }


    /**
     * 优惠券激活前面的操作判断激活的优惠券里面的商品是否有已经存在的
     *
     * @return 优惠券激活
     */
    @GetMapping("/checkRepeatCouponItem/{ouId}/{id}")
    @ApiOperation("优惠券激活前面的操作判断激活的优惠券里面的商品是否有已经存在的")
    public ApiResult<Boolean> checkRepeatCouponItem(@PathVariable Long ouId,@PathVariable Long id) {
        boolean flag = bipCouponService.checkRepeatCouponItem(ouId,id);
        return ApiResult.ok(flag);
    }

    /**
     * 优惠券禁用
     *
     * @return 优惠券禁用
     */
    @PutMapping("/disableCoupon")
    @ApiOperation("优惠券禁用")
    public ApiResult<BipCouponSaveVO> disableCoupon(@RequestBody List<Long> id) {
        bipCouponService.disableCoupon(id);
        return ApiResult.ok();
    }


    /**
     * 优惠券删除
     *
     * @return 优惠券删除
     */
    @PutMapping("/delCoupon")
    @ApiOperation("优惠券删除")
    public ApiResult<BipCouponSaveVO> delCoupon(@RequestBody List<Long> id) {
        bipCouponService.delCoupon(id);
        return ApiResult.ok();
    }


    /**
     * 修改数据
     *
     * @param param 修改对象
     * @return 修改数据详情
     */
    @PutMapping("/update")
    @ApiOperation("修改数据")
    public ApiResult<Object> update(@RequestBody BipCouponSaveVO param) {
        bipCouponService.update(param);
        return ApiResult.ok();
    }

    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "param", value = "分页查询参数", required = true, dataType = "BipCouponQueryParamVO")
    })
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<BipCouponVO>> search(@RequestBody BipCouponQueryParamVO param) {
        val ret = bipCouponService.searchAll(param);
        return ApiResult.ok(ret);
    }


}