package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.BusFirstMenuConfService;
import com.elitesland.yst.production.sale.api.service.ZoneSettingService;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipCouponService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemAppService;
import com.elitesland.yst.production.sale.api.service.shop.BipRotationChartService;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCompanyManageParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponOrderVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipHomeMenuPageVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.*;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemListAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneRecParam;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @author Shadow（li qun）
 * @since 2021-09-13 15:00
 */
@Slf4j
@RestController
@RequiredArgsConstructor
@RequestMapping("/bip/home")
@Api(tags = "小程序首页(app)")
public class BipHomePageController {

    private final BipCouponService bipCouponService;
    private final BipItemAppService bipItemAppService;
    private final ZoneSettingService zoneSettingService;
    private final BipRotationChartService bipRotationChartService;
    private final BusFirstMenuConfService busFirstMenuConfService;
    private final BipCompanyManageService bipCompanyManageService;

    /**
     * 轮播图查询
     * @param id 公司ID
     * @return 轮播图信息
     */
    @GetMapping("/homeSlideshow/{id}")
    @ApiOperation("首页轮播图")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "公司ID")
    })
    public ApiResult<List<BipRetationChartVO>> homeRotation(@PathVariable Long id) {
        val ret = bipRotationChartService.homeRotation(id);
        return ApiResult.ok(ret);
    }

    /**
     * 轮播图关联的商品
     * @param offsetCode 满减编码
     * @return 商品
     */
    @GetMapping("/rotationItem/{offsetCode}")
    @ApiOperation("轮播图商品列表")
    @ApiOperationSupport(order = 2)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "offsetCode", value = "满减编码")
    })
    public ApiResult<List<BipItemListAppRespVO>> rotationItem(@PathVariable String offsetCode) {
        return bipItemAppService.rotationItem(offsetCode);
    }

    /**
     * 首页弹出优惠券优惠券
     *
     * @return 首页弹出优惠券优惠券
     */
    @GetMapping("/findHomeCurrentCoupon")
    @ApiOperation("首页查询未领取优惠券")
    @ApiOperationSupport(order = 3)
    ApiResult<BipCouPonIndexShowVO> findHomeCoupon() {
        return ApiResult.ok(bipCouponService.findHomeCoupon());
    }

    /**
     * 菜单列表
     * @param id 公司ID
     * @return 菜单
     */
    @GetMapping("/homeMenus/{id}")
    @ApiOperation("菜单列表")
    @ApiOperationSupport(order = 4)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "公司ID")
    })
    public ApiResult<List<BipHomeMenuVO>> findHomeMenu(@PathVariable Long id) {
        List<BipHomeMenuVO> menu = busFirstMenuConfService.findHomeMenu(id);
        return ApiResult.ok(menu);
    }

    /**
     * 查询菜单详情
     * @param bipHomeMenuPageVO 参数
     * @return 菜单信息
     */
    @PostMapping("/homeMenuDetails")
    @ApiOperation("菜单详情")
    @ApiOperationSupport(order = 5)
    public ApiResult<PagingVO<BipHomeDetailVO>> findHomeMenuDetails(@RequestBody BipHomeMenuPageVO bipHomeMenuPageVO) {
        var menu = busFirstMenuConfService.findHomeMenuDetails(bipHomeMenuPageVO);
        return ApiResult.ok(menu);
    }

    /**
     * 专区列表
     * @param param 公司信息
     * @return 专区
     */
    @ApiOperation("首页专区")
    @ApiOperationSupport(order = 6)
    @PostMapping("/recommend")
    public ApiResult<List<ZoneSettingVO>> queryRecGood(@Valid @RequestBody ZoneRecParam param) {
        return ApiResult.ok(zoneSettingService.homeRecommend(param));
    }

    /**
     * 专区详情
     * @param param 专区ID
     * @return 详情信息
     */
    @ApiOperation("专区详情")
    @ApiOperationSupport(order = 7)
    @PostMapping("/zoneMore")
    public ApiResult<ZoneSettingVO> zoneMore(@Valid @RequestBody ZoneRecParam param) {
        return ApiResult.ok(zoneSettingService.getRecommendForMore(param));
    }

    /**
     * 优惠券中心查询
     *
     * @return 优惠券
     */
    @PostMapping("/sortingSearch")
    @ApiOperation("优惠券中心-排序查询")
    @ApiOperationSupport(order = 8)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "param", required = true, dataType = "BipCouponOrderVO")
    })
    public ApiResult<PagingVO<BipCouponVO>> sortingSearch(@RequestBody BipCouponOrderVO param) {
        val ret = bipCouponService.sortingSearch(param);
        return ApiResult.ok(ret);
    }

    /**
     * 绑定公司时的公司列表
     * @param searchParam 查询参数
     * @return 公司信息
     */
    @PostMapping(value = "/searchCompany")
    @ApiOperation(value = "分页查询商城公司")
    @ApiOperationSupport(order = 9)
    public ApiResult<PagingVO<BipCompanyManageRespVO>> search(@RequestBody BipCompanyManageParamVO searchParam) {
        return ApiResult.ok(bipCompanyManageService.search(searchParam));
    }

}
