package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.service.shop.BipItemAppService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemCategoryService;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipItemAppQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipItemRecommendAppQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.ItemCatTreeRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.*;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 商品（app）
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/24
 */
@Api(tags = {"商品（app）"})
@ApiSupport(author = "Kaiser（wang shao）")
@RestController
@RequestMapping(value = "/bip/app/item", produces = MediaType.APPLICATION_JSON_VALUE)
public class BipItemAppController {

    private final BipItemAppService itemAppService;
    private final BipItemCategoryService categoryService;

    public BipItemAppController(BipItemAppService itemAppService, BipItemCategoryService categoryService) {
        this.itemAppService = itemAppService;
        this.categoryService = categoryService;
    }

    @ApiOperation(value = "商品分类树形数据获取")
    @ApiOperationSupport(order = 1)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ouId", value = "所属公司")
    })
    @GetMapping(value = "/cat/tree")
    public ApiResult<List<ItemCatTreeRespVO>> tree(Long ouId) {
        return categoryService.treeOfOu(ouId);
    }

    @ApiOperation(value = "全部商品列表")
    @ApiOperationSupport(order = 2)
    @PostMapping(value = "/search/all")
    public ApiResult<PagingVO<BipItemListAppRespVO>> queryAll(@RequestBody BipItemAppQueryParamVO queryParamVO) {
        return itemAppService.queryForApp(queryParamVO);
    }

    @ApiOperation(value = "商品详情")
    @ApiOperationSupport(order = 3)
    @GetMapping(value = "/{id}/{ouId}")
    public ApiResult<BipItemDetailAppRespVO> detail(@PathVariable Long id,@PathVariable Long ouId) {
        return itemAppService.getDetail(id,ouId);
    }

    @ApiOperation(value = "商品SKU信息")
    @ApiOperationSupport(order = 4)
    @GetMapping(value = "/{id}/sku")
    public ApiResult<BipItemAttrAppRespVO> getSku(@PathVariable Long id) {
        return itemAppService.getItemSku(id);
    }

    @ApiOperation(value = "收货地址查询")
    @ApiOperationSupport(order = 5)
    @GetMapping(value = "/receipt/address")
    public ApiResult<List<BipReceiptAddrAppRespVO>> queryAddress() {
        return itemAppService.queryReceiptAddr();
    }

    @ApiOperation(value = "商品推荐")
    @ApiOperationSupport(order = 6)
    @PostMapping(value = "/recommend")
    public ApiResult<List<BipItemRecommendAppRespVO>> queryRecommend(@RequestBody BipItemRecommendAppQueryParamVO queryParamVO) {
        return itemAppService.queryForAppRecommend(queryParamVO);
    }

    @ApiOperation("精品推荐")
    @ApiOperationSupport(order = 7)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ouId", value = "所属公司ID"),
            @ApiImplicitParam(name = "size", value = "请求数据数量，默认10")
    })
    @GetMapping("/rec/good")
    public ApiResult<List<BipItemRecGoodAppRespVO>> queryRecGood(Long ouId, Integer size) {
        return itemAppService.queryForRecGood(ouId, size);
    }

    @ApiOperation(value = "热销商品")
    @ApiOperationSupport(order = 8)
    @GetMapping(value = "/search/hot/{id}")
    public ApiResult<PagingVO<BipItemHotAppRespVO>> queryHot(@PathVariable Long id) {
        return itemAppService.queryForAppHot(id);
    }
}
