package com.elitesland.yst.production.sale.controller.shop;

import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderBackParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipOrderBackUserParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipOrderBackRespVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackLogistSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderBackSaveVO;
import com.elitesland.yst.production.sale.service.shop.BipOrderBackServiceImpl;
import com.elitesland.yst.production.sale.service.shop.BipOrderBackToOmsServiceimpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 退货单接口
 *
 * @Author: wang yinghao
 * @Date: 2021/08/22/15:23
 */
@RestController
@RequestMapping("/bip/orderBack")
@Api(value = "退货单", tags = {"退货单"})
@RequiredArgsConstructor
public class BipOrderBackController {

    @Autowired
    private BipOrderBackServiceImpl bipOrderBackService;

    @Autowired
    private BipOrderBackToOmsServiceimpl bipOrderBackToOmsService;

    @PostMapping("/page/search")
    @ApiOperation("分页查询")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<BipOrderBackRespVO>> findBipOrderBackPage(@RequestBody BipOrderBackParmVO bipOrderBackParmVO) {
        return ApiResult.ok(bipOrderBackService.findBipOrderBackPage(bipOrderBackParmVO));
    }

    @PostMapping("/save")
    @ApiOperation("保存")
    @ApiOperationSupport(order = 2)
    public ApiResult<String> saveBipOrderBack(@RequestBody BipOrderBackSaveVO bipOrderBackSaveVO) {
        bipOrderBackService.createOrderBack(bipOrderBackSaveVO);
        return ApiResult.ok();
    }

    @PostMapping("/subBipOrderBack")
    @ApiOperation("截单")
    @ApiOperationSupport(order = 3)
    public ApiResult<String> subBipOrderBack(@RequestBody BipOrderBackSaveVO bipOrderBackSaveVO) {
        bipOrderBackService.subBipOrderBack(bipOrderBackSaveVO);
        return ApiResult.ok();
    }

    @PostMapping("/updateSync")
    @ApiOperation("更新")
    @ApiOperationSupport(order = 4)
    public ApiResult<String> updateSync(@RequestBody BipOrderBackSaveVO bipOrderBackSaveVO) {
        bipOrderBackService.updateSync(bipOrderBackSaveVO);
        return ApiResult.ok();
    }

    @GetMapping("/cancelSync/{id}")
    @ApiOperation("取消")
    @ApiOperationSupport(order = 5)
    public ApiResult<String> cancelSync(@PathVariable Long id) {
        bipOrderBackService.cancelSync(id);
        return ApiResult.ok();
    }

    @PostMapping("/delete")
    @ApiOperation("删除")
    @ApiOperationSupport(order = 6)
    public ApiResult<String> deleteBipOrderBackByIds(@RequestBody List<Long> ids) {
        bipOrderBackService.deleteBipOrderBackByIds(ids);
        return ApiResult.ok();
    }

    @GetMapping("/find/detail/{id}")
    @ApiOperation("退货单详情查询")
    @ApiOperationSupport(order = 7)
    public ApiResult<BipOrderBackRespVO> findOrderDetailById(@PathVariable Long id) {
        BipOrderBackRespVO bipOrderBackRespVO = bipOrderBackService.findPolymerizeOrderBack(id);
        return ApiResult.ok(bipOrderBackRespVO);
    }

    @PostMapping("/app/user/find")
    @ApiOperation("APP用户退货单列表查询")
    @ApiOperationSupport(order = 8)
    public ApiResult<PagingVO<BipOrderBackRespVO>> findUserOrderBack(@RequestBody BipOrderBackUserParmVO bipOrderBackUserParmVO) {
        PagingVO<BipOrderBackRespVO> page = bipOrderBackService.findUserOrderBack(bipOrderBackUserParmVO);
        return ApiResult.ok(page);
    }

    @GetMapping("/app/find/detail/{id}")
    @ApiOperation("APP退货单详情查询")
    @ApiOperationSupport(order = 9)
    public ApiResult<BipOrderBackRespVO> findOrderBackDetailById(@PathVariable Long id) {
        BipOrderBackRespVO bipOrderBackDRespVO = bipOrderBackService.findOrderBackDetailById(id);
        return ApiResult.ok(bipOrderBackDRespVO);
    }

    @PostMapping("/app/update/logist")
    @ApiOperation("更新退货单物流信息")
    @ApiOperationSupport(order = 10)
    public ApiResult<String> updateOrderBackLogistInfo(@RequestBody BipOrderBackLogistSaveVO bipOrderBackLogistSaveVO) {
        bipOrderBackService.updateOrderBackLogistInfo(bipOrderBackLogistSaveVO);
        return ApiResult.ok();
    }

    @PostMapping("/submit")
    @ApiOperation("更新退货单审核状态")
    @ApiOperationSupport(order = 11)
    public ApiResult<String> submit(@RequestBody BipOrderBackSaveVO bipOrderBackSaveVO) {
        bipOrderBackService.submit(bipOrderBackSaveVO);
        return ApiResult.ok();
    }

    @PostMapping("/update/checkStatus")
    @ApiOperation("更新审核中退货单")
    @ApiOperationSupport(order = 12)
    public ApiResult<String> updateCheckStatus(@RequestBody BipOrderBackSaveVO bipOrderBackSaveVO) {
        bipOrderBackService.updateCheckStatus(bipOrderBackSaveVO);
        return ApiResult.ok();
    }

    @GetMapping("/cancle/{id}")
    @ApiOperation("退货单撤销申请")
    @ApiOperationSupport(order = 13)
    public ApiResult<String> cancle(@PathVariable Long id) {
        bipOrderBackService.cancle(id);
        return ApiResult.ok();
    }

    @GetMapping("/reBack/{id}")
    @ApiOperation("再次申请")
    @ApiOperationSupport(order = 14)
    public ApiResult<String> reBack(@PathVariable Long id) {
        bipOrderBackService.reBack(id);
        return ApiResult.ok();
    }

    @GetMapping("/testReturn/{id}")
    @ApiOperation("测试退款")
    @ApiOperationSupport(order = 15)
    public ApiResult<String> testReturn(@PathVariable Long id) {
        bipOrderBackService.cpcn5011Request(id);
        return ApiResult.ok();
    }

//    @GetMapping("/testRepecied/{docNo}")
//    @ApiOperation("测试退款单生成")
//    @ApiOperationSupport(order = 16)
//    public ApiResult<String> testReturn(@PathVariable String docNo) {
//        bipOrderBackToOmsService.createSalReceiptService(docNo);
//        return ApiResult.ok();
//    }

}
