package com.elitesland.yst.production.sale.controller.statistics.app;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.StatisticsDealerService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsDealerQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsDealerRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerAppSumRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsDealerSumRespVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/06/09
 * @Version 1.0
 * @Content:
 */
@RestController
@RequestMapping(value = "/statistics/dealer/app", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(value = "销售业绩统计-经销商-APP端", tags = {"销售业绩统计-经销商-APP端"})
@RequiredArgsConstructor
public class StatisticsDealerAppController {
    private final StatisticsDealerService statisticsDealerService;

    @PostMapping("/page")
    @ApiOperation("经销商销售业绩分页查询")
    public ApiResult<PagingVO<SaleStatisticsDealerRespVO>> appPage(@RequestBody SaleStatisticsDealerQueryVO pageParam) {
        PagingVO<SaleStatisticsDealerRespVO> page = statisticsDealerService.appPage(pageParam);
        return ApiResult.ok(page);
    }

    @PostMapping("/leaderPage")
    @ApiOperation("leaderPage经销商销售业绩分页查询")
    public ApiResult<PagingVO<SaleStatisticsDealerRespVO>> leaderPage(@RequestBody SaleStatisticsDealerQueryVO pageParam) {
        PagingVO<SaleStatisticsDealerRespVO> page = statisticsDealerService.leaderPage(pageParam);
        return ApiResult.ok(page);
    }

    @PostMapping("/pageSum")
    @ApiOperation("经销商销售业绩统计汇总")
    ApiResult<StatisticsDealerSumRespVO> appPageSum(@RequestBody SaleStatisticsDealerQueryVO pageParam) {
        return ApiResult.ok(statisticsDealerService.appPageSum(pageParam));
    }

    @PostMapping("/leaderPageSum")
    @ApiOperation("leaderPageSum经销商销售业绩统计汇总")
    ApiResult<StatisticsDealerSumRespVO> leaderPageSum(@RequestBody SaleStatisticsDealerQueryVO pageParam) {
        return ApiResult.ok(statisticsDealerService.leaderPageSum(pageParam));
    }

    @PostMapping("/details")
    @ApiOperation("经销商销售业绩详情-头部信息和车型分页明细数据")
    public ApiResult<PagingVO<SaleStatisticsDealerRespVO>> appDetails(@RequestBody SaleStatisticsDealerQueryVO pageParam) {
        PagingVO<SaleStatisticsDealerRespVO> pagingVO = statisticsDealerService.appDetails(pageParam);
        return ApiResult.ok(pagingVO);
    }

    @PostMapping("/appSumByEmpCode")
    @ApiOperation("根据业务员编码/年月查询其当月的团队业绩和我的业绩")
    public ApiResult<List<StatisticsDealerAppSumRespVO>> appSumByEmpCode(@RequestBody SaleStatisticsDealerQueryVO pageParam) {
        List<StatisticsDealerAppSumRespVO> appSumRespVOList = statisticsDealerService.appSumByEmpCode(pageParam);
        return ApiResult.ok(appSumRespVOList);
    }

}
