package com.elitesland.yst.production.sale.entity;

import com.elitesland.yst.production.sale.core.convert.BigDecimalConvert;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/19
 */
@Entity
@Table(name = "bip_item_sku", indexes = {
        @Index(name = "idx_bip_item_sku_item_id", columnList = "bip_item_id")
})
@org.hibernate.annotations.Table(appliesTo = "bip_item_sku", comment = "商品SKU信息")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BipItemSkuDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -3409057454283207416L;

    @Column(name = "bip_item_id", columnDefinition = "bigint(20) not null comment '商品Id'")
    private Long bipItemId;

    @Column(name = "item_name", columnDefinition = "varchar(256) not null comment '商品名称'")
    private String itemName;

    @Column(name = "sku_code", columnDefinition = "varchar(64) not null comment 'sku编号'")
    private String skuCode;

    @Column(name = "spec", columnDefinition = "varchar(256) default '' comment '包装规格'")
    private String spec;

    @Column(name = "attr", columnDefinition = "longtext comment '属性'")
    private String attr;

    @Column(name = "barcode", columnDefinition = "varchar(256) default '' comment '商品条码'")
    private String barcode;

    @Column(name = "brand", columnDefinition = "varchar(256) default '' comment '品牌'")
    private String brand;

    @Column(name = "batch", columnDefinition = "varchar(256) default '' comment '批次'")
    private String batch;

    @Column(name = "materiel", columnDefinition = "varchar(512) default '' comment '物料类型'")
    private String materiel;

    @Column(name = "type", columnDefinition = "varchar(512) default '' comment '商品类型'")
    private String type;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "price_guide", columnDefinition = "decimal(20, 2) default null comment '指导价'")
    private BigDecimal priceGuide;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "price_old", columnDefinition = "decimal(20, 2) default 0  comment '原来的基础价'")
    private BigDecimal priceOld;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "price", columnDefinition = "decimal(20, 2) default null  comment '基础价'")
    private BigDecimal price;

    @Column(name = "ship_one", columnDefinition = "tinyint(1) default 0 comment '是否一件代发'")
    private Boolean shipOne;

    @Column(name = "supplier", columnDefinition = "varchar(256) default '' comment '供应商'")
    private String supplier;

    @Column(name = "stock", columnDefinition = "int(10) default 0 comment '库存'")
    private Integer stock;

    @Column(name = "limit_buy", columnDefinition = "int(10) default 0 comment '最小起订量'")
    private Integer limitBuy;

    @Column(name = "sort_no", columnDefinition = "int(10) default 0 comment '顺序'")
    private Integer sortNo;

    @Column(name = "freeze",columnDefinition = "tinyint(1) default 0  comment '是否冻结'")
    private Boolean freeze;

}
