package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * b2b销售附件信息
 * @author zhao.zhi.hao
 * @since 2021/5/27 11:24
 */
@Entity
@Table(name = "com_sale_file_info")
@org.hibernate.annotations.Table(appliesTo = "com_sale_file_info", comment = "b2b销售附件信息")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class ComSaleFileInfoDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -5616252301583654103L;

    @ApiModelProperty("证件编号")
    @Column(name = "qualify_no", columnDefinition = "varchar(40)  comment '证件编号'")
    private String qualifyNo;

    @ApiModelProperty("业务关联ID")
    @Column(name = "business_id", columnDefinition = "bigint(20)  comment '业务关联ID'")
    private Long businessId;

    @ApiModelProperty("业务类型")
    @Column(name = "business_type", columnDefinition = "varchar(20)  comment '业务类型'")
    private String businessType;

    @ApiModelProperty("文件ID")
    @Column(name = "file_id", columnDefinition = "bigint(20)  comment '文件ID'")
    private Long fileId;

    @ApiModelProperty("文件名称")
    @Column(name = "file_name", columnDefinition = "varchar(256)  comment '文件名称'")
    private String fileName;

    @ApiModelProperty("文件编号")
    @Column(name = "file_code", columnDefinition = "varchar(256)  comment '文件编号'")
    private String fileCode;

    @ApiModelProperty("文件类型(图片，附件等)")
    @Column(name = "file_type", columnDefinition = "varchar(40)  comment '文件类型(图片，附件等)'")
    private String fileType;

    @ApiModelProperty("文件大小")
    @Column(name = "file_size", columnDefinition = "varchar(40)  comment '文件大小'")
    private String fileSize;

    @ApiModelProperty("是否主图")
    @Column(name = "major", columnDefinition = "tinyint(1) comment '是否主图'")
    private Boolean major;
}