package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.CrmScustDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/6/4
 */
public interface CrmScustRepo extends JpaRepository<CrmScustDO, Long>, QuerydslPredicateExecutor<CrmScustDO> {

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update crm_scust set agent_emp_id = ?1 where id in ?2", nativeQuery = true)
    void updateScustAgentEmp(Long id, List<Long> custIds);

    @Transactional//事务的注解
    @Modifying//增删改必须有这个注解
    @Query(value = "update crm_scust set cust_status = ?1 where id in ?2", nativeQuery = true)
    void updateScustStatus(String scustStatus,List<Long> scustIds);
}
