package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.PriSalePriceAlterDDO;
import com.elitesland.yst.production.sale.entity.QPriSalePriceAlterDDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 11:26
 */
@Repository
public class PriSalePriceAlterDRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    private final QPriSalePriceAlterDDO qPriSalePriceAlterDDO = QPriSalePriceAlterDDO.priSalePriceAlterDDO;

    /**
     * 根据申请单ID获取申请单明细
     * @param masId 申请单ID
     * @return
     */
    public List<PriSalePriceAlterDDO> getDetailsByMasId(Long masId) {
        return jpaQueryFactory.selectFrom(qPriSalePriceAlterDDO)
                .where(qPriSalePriceAlterDDO.masId.eq(masId)).fetch();
    }

    public List<Long> findPriceAlterIDByIC(String itemCode){

        if (itemCode==null){
            return new ArrayList<>();
        }

        return jpaQueryFactory.select(qPriSalePriceAlterDDO.masId)
                .from(qPriSalePriceAlterDDO)
                .where(qPriSalePriceAlterDDO.itemCode.like("%"+itemCode+"%"))
                .fetch();
    }

    public List<Long> findPriceAlterIDByIN(String itemName){

        if (itemName==null){
            return new ArrayList<>();
        }

        return jpaQueryFactory.select(qPriSalePriceAlterDDO.masId)
                .from(qPriSalePriceAlterDDO)
                .where(qPriSalePriceAlterDDO.itemName.like("%"+itemName+"%"))
                .fetch();
    }

}
