package com.elitesland.yst.production.sale.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.TaskInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoExportRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.TaskInfoRespVO;
import com.elitesland.yst.production.sale.api.vo.save.TaskInfoSaveVO;
import com.elitesland.yst.production.sale.entity.QTaskInfoDO;
import com.elitesland.yst.production.sale.entity.QTaskInfoDtlDO;
import com.elitesland.yst.production.sale.entity.TaskInfoDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * <p>
 * 功能说明:业务员任务管理
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/10
 * @Version 1.0
 * @Content:
 */
@Component
public class TaskInfoRepoProc extends BaseRepoProc<TaskInfoDO> {
    private static final QTaskInfoDO qTaskInfoDO = QTaskInfoDO.taskInfoDO;
    private static final QTaskInfoDtlDO qTaskInfoDtlDO = QTaskInfoDtlDO.taskInfoDtlDO;

    protected TaskInfoRepoProc() {
        super(qTaskInfoDO);
    }

    public List<TaskInfoRespVO> selectByQueryVO(TaskInfoQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<TaskInfoRespVO> jpaQuery = select(TaskInfoRespVO.class).where(ExpressionUtils.allOf(where));
        return jpaQuery.fetch();
    }

    public List<TaskInfoRespVO> selectPageByQueryVO(TaskInfoQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<TaskInfoRespVO> jpaQuery = select(TaskInfoRespVO.class).where(ExpressionUtils.allOf(where));
        queryVO.setPaging(jpaQuery);
        queryVO.fillOrders(jpaQuery, qTaskInfoDO);
        return jpaQuery.fetch();
    }

    public PagingVO<TaskInfoRespVO> page(TaskInfoQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        JPAQuery<TaskInfoRespVO> query = select(TaskInfoRespVO.class).where(ExpressionUtils.allOf(where));
        queryVO.setPaging(query);
        queryVO.fillOrders(query, qTaskInfoDO);
        return PagingVO.<TaskInfoRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private List<Predicate> where(TaskInfoQueryVO queryVO) {
        List<Predicate> predicates = new ArrayList<>();
        //predicates.add(qTaskInfoDO.deleteFlag.eq(0).or(qTaskInfoDO.deleteFlag.isNull()));

        if (!Objects.isNull(queryVO.getId())) {
            predicates.add(qTaskInfoDO.id.eq(queryVO.getId()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getIds())) {
            predicates.add(qTaskInfoDO.id.in(queryVO.getIds()));
        }
        if (!StringUtils.isEmpty(queryVO.getCode())) {
            predicates.add(qTaskInfoDO.code.eq(queryVO.getCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getCodeList())) {
            predicates.add(qTaskInfoDO.code.in(queryVO.getCodeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getCodeKeyword())) {
            predicates.add(qTaskInfoDO.code.like("%" + queryVO.getCodeKeyword() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getName())) {
            predicates.add(qTaskInfoDO.name.like("%" + queryVO.getName() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getTaskKeyword())) {
            predicates.add(qTaskInfoDO.code.like("%" + queryVO.getTaskKeyword() + "%").or(qTaskInfoDO.name.like("%" + queryVO.getTaskKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(queryVO.getState())) {
            predicates.add(qTaskInfoDO.state.eq(queryVO.getState()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getStateList())) {
            predicates.add(qTaskInfoDO.state.in(queryVO.getStateList()));
        }
        if (!StringUtils.isEmpty(queryVO.getDelayFlag())) {
            predicates.add(qTaskInfoDO.delayFlag.eq(queryVO.getDelayFlag()));
        }
        if (!StringUtils.isEmpty(queryVO.getType())) {
            predicates.add(qTaskInfoDO.type.eq(queryVO.getType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getTypeList())) {
            predicates.add(qTaskInfoDO.type.in(queryVO.getTypeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getOuCode())) {
            predicates.add(qTaskInfoDO.ouCode.eq(queryVO.getOuCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getOuCodeList())) {
            predicates.add(qTaskInfoDO.ouCode.in(queryVO.getOuCodeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getUrgencyLevel())) {
            predicates.add(qTaskInfoDO.urgencyLevel.eq(queryVO.getUrgencyLevel()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getUrgencyLevelList())) {
            predicates.add(qTaskInfoDO.urgencyLevel.in(queryVO.getUrgencyLevelList()));
        }

        if (queryVO.getStartTimeS() != null && queryVO.getStartTimeE() != null) {
            predicates.add(qTaskInfoDO.startTime.between(queryVO.getStartTimeS(), queryVO.getStartTimeE()));
        } else {
            if (queryVO.getStartTimeS() != null) {
                predicates.add(qTaskInfoDO.startTime.goe(queryVO.getStartTimeS()));
            }
            if (queryVO.getStartTimeE() != null) {
                predicates.add(qTaskInfoDO.startTime.loe(queryVO.getStartTimeE()));
            }
        }
        if (queryVO.getEndTimeS() != null && queryVO.getEndTimeE() != null) {
            predicates.add(qTaskInfoDO.endTime.between(queryVO.getEndTimeS(), queryVO.getEndTimeE()));
        } else {
            if (queryVO.getEndTimeS() != null) {
                predicates.add(qTaskInfoDO.endTime.goe(queryVO.getEndTimeS()));
            }
            if (queryVO.getEndTimeE() != null) {
                predicates.add(qTaskInfoDO.endTime.loe(queryVO.getEndTimeE()));
            }
        }
        if (queryVO.getCompleteTimeS() != null && queryVO.getCompleteTimeE() != null) {
            predicates.add(qTaskInfoDO.completeTime.between(queryVO.getCompleteTimeS(), queryVO.getCompleteTimeE()));
        } else {
            if (queryVO.getCompleteTimeS() != null) {
                predicates.add(qTaskInfoDO.completeTime.goe(queryVO.getCompleteTimeS()));
            }
            if (queryVO.getCompleteTimeE() != null) {
                predicates.add(qTaskInfoDO.completeTime.loe(queryVO.getCompleteTimeE()));
            }
        }

        if (!StringUtils.isEmpty(queryVO.getRepeatSet())) {
            predicates.add(qTaskInfoDO.repeatSet.eq(queryVO.getRepeatSet()));
        }
        if (!StringUtils.isEmpty(queryVO.getRepeatType())) {
            predicates.add(qTaskInfoDO.repeatType.eq(queryVO.getRepeatType()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getRepeatTypeList())) {
            predicates.add(qTaskInfoDO.repeatType.in(queryVO.getRepeatTypeList()));
        }

        if (queryVO.getRepeatStartTimeS() != null && queryVO.getRepeatStartTimeE() != null) {
            predicates.add(qTaskInfoDO.repeatStartTime.between(queryVO.getRepeatStartTimeS(), queryVO.getRepeatStartTimeE()));
        } else {
            if (queryVO.getRepeatStartTimeS() != null) {
                predicates.add(qTaskInfoDO.repeatStartTime.goe(queryVO.getRepeatStartTimeS()));
            }
            if (queryVO.getRepeatStartTimeE() != null) {
                predicates.add(qTaskInfoDO.repeatStartTime.loe(queryVO.getRepeatStartTimeE()));
            }
        }
        if (queryVO.getRepeatEndTimeS() != null && queryVO.getRepeatEndTimeE() != null) {
            predicates.add(qTaskInfoDO.repeatEndTime.between(queryVO.getRepeatEndTimeS(), queryVO.getRepeatEndTimeE()));
        } else {
            if (queryVO.getRepeatEndTimeS() != null) {
                predicates.add(qTaskInfoDO.repeatEndTime.goe(queryVO.getRepeatEndTimeS()));
            }
            if (queryVO.getRepeatEndTimeE() != null) {
                predicates.add(qTaskInfoDO.repeatEndTime.loe(queryVO.getRepeatEndTimeE()));
            }
        }
        if (queryVO.getExecutTimeS() != null && queryVO.getExecutTimeE() != null) {
            predicates.add(qTaskInfoDO.executTime.between(queryVO.getExecutTimeS(), queryVO.getExecutTimeE()));
        } else {
            if (queryVO.getExecutTimeS() != null) {
                predicates.add(qTaskInfoDO.executTime.goe(queryVO.getExecutTimeS()));
            }
            if (queryVO.getExecutTimeE() != null) {
                predicates.add(qTaskInfoDO.executTime.loe(queryVO.getExecutTimeE()));
            }
        }

        if (!StringUtils.isEmpty(queryVO.getPromotionCode())) {
            predicates.add(qTaskInfoDO.promotionCode.eq(queryVO.getPromotionCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getPromotionCodeList())) {
            predicates.add(qTaskInfoDO.promotionCode.in(queryVO.getPromotionCodeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getPromotionName())) {
            predicates.add(qTaskInfoDO.promotionName.like("%" + queryVO.getPromotionName() + "%"));
        }

        if (!StringUtils.isEmpty(queryVO.getForceSignFlag())) {
            predicates.add(qTaskInfoDO.forceSignFlag.eq(queryVO.getForceSignFlag()));
        }
        if (!Objects.isNull(queryVO.getPublishUserId())) {
            predicates.add(qTaskInfoDO.publishUserId.eq(queryVO.getPublishUserId()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getPublishUserIds())) {
            predicates.add(qTaskInfoDO.publishUserId.in(queryVO.getPublishUserIds()));
        }
        if (!StringUtils.isEmpty(queryVO.getPublishUser())) {
            predicates.add(qTaskInfoDO.publishUser.like("%" + queryVO.getPublishUser() + "%"));
        }
        if (!CollectionUtils.isEmpty(queryVO.getPublishUserCodes())) {
            predicates.add(qTaskInfoDO.publishUserCode.in(queryVO.getPublishUserCodes()));
        }
        if (!StringUtils.isEmpty(queryVO.getPublishUserCode())) {
            predicates.add(qTaskInfoDO.publishUserCode.eq(queryVO.getPublishUserCode()));
        }
        if (!StringUtils.isEmpty(queryVO.getExecutTemplate())) {
            predicates.add(qTaskInfoDO.executTemplate.eq(queryVO.getExecutTemplate()));
        }
        if (!StringUtils.isEmpty(queryVO.getExecutTemplateCode())) {
            predicates.add(qTaskInfoDO.executTemplateCode.eq(queryVO.getExecutTemplateCode()));
        }
        if (!CollectionUtils.isEmpty(queryVO.getExecutTemplateCodeList())) {
            predicates.add(qTaskInfoDO.executTemplateCode.in(queryVO.getExecutTemplateCodeList()));
        }
        if (!StringUtils.isEmpty(queryVO.getExecutTemplateName())) {
            predicates.add(qTaskInfoDO.executTemplateName.like("%" + queryVO.getExecutTemplateName() + "%"));
        }
        if (!StringUtils.isEmpty(queryVO.getExecutTemplateKeyword())) {
            predicates.add(qTaskInfoDO.executTemplateCode.like("%" + queryVO.getExecutTemplateKeyword() + "%").or(qTaskInfoDO.executTemplateName.like("%" + queryVO.getExecutTemplateKeyword() + "%")));
        }


        return predicates;
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qTaskInfoDO.id,
                qTaskInfoDO.code,
                qTaskInfoDO.name,
                qTaskInfoDO.state,
                qTaskInfoDO.delayFlag,
                qTaskInfoDO.progress,
                qTaskInfoDO.type,
                qTaskInfoDO.ouCode,
                qTaskInfoDO.urgencyLevel,
                qTaskInfoDO.startTime,
                qTaskInfoDO.endTime,
                qTaskInfoDO.completeTime,
                qTaskInfoDO.repeatSet,
                qTaskInfoDO.repeatType,
                qTaskInfoDO.repeatInterval,
                qTaskInfoDO.appointDay,
                qTaskInfoDO.repeatStartTime,
                qTaskInfoDO.repeatEndTime,
                qTaskInfoDO.executTime,
                qTaskInfoDO.promotionCode,
                qTaskInfoDO.promotionName,
                qTaskInfoDO.forceSignFlag,
                qTaskInfoDO.signInRange,
                qTaskInfoDO.signOutRange,
                qTaskInfoDO.publishUser,
                qTaskInfoDO.publishUserId,
                qTaskInfoDO.publishUserCode,
                qTaskInfoDO.executTemplate,
                qTaskInfoDO.taskDesc,
                qTaskInfoDO.fileInfo,
                qTaskInfoDO.executTemplateId,
                qTaskInfoDO.executTemplateCode,
                qTaskInfoDO.executTemplateName,
                qTaskInfoDO.remark,
                qTaskInfoDO.createTime,
                qTaskInfoDO.createUserId,
                qTaskInfoDO.creator,
                qTaskInfoDO.modifyTime,
                qTaskInfoDO.modifyUserId,
                qTaskInfoDO.updater,
                qTaskInfoDO.tenantId,
                qTaskInfoDO.deleteFlag
        )).from(qTaskInfoDO);
    }

    public void updateDeleteFlagBatch(Integer deleteFlag, List<Long> ids) {
        jpaQueryFactory.update(qTaskInfoDO)
                .set(qTaskInfoDO.deleteFlag, deleteFlag)
                .where(qTaskInfoDO.id.in(ids))
                .execute();
    }

    public void updateStateById(String state, Long id) {
        jpaQueryFactory.update(qTaskInfoDO)
                .set(qTaskInfoDO.state, state)
                .where(qTaskInfoDO.id.eq(id))
                .execute();
    }

    public void updateExecuteTemplateCodeById(Long executTemplateId, String executeTemplateCode, String executTemplateName, Long id) {
        jpaQueryFactory.update(qTaskInfoDO)
                .set(qTaskInfoDO.executTemplateId, executTemplateId)
                .set(qTaskInfoDO.executTemplateCode, executeTemplateCode)
                .set(qTaskInfoDO.executTemplateName, executTemplateName)
                .where(qTaskInfoDO.id.eq(id))
                .execute();
    }

    public void updateStateAndCompleteTimeById(String state, LocalDateTime completeTime, Long id) {
        jpaQueryFactory.update(qTaskInfoDO)
                .set(qTaskInfoDO.state, state)
                .set(qTaskInfoDO.completeTime, completeTime)
                .where(qTaskInfoDO.id.eq(id))
                .execute();
    }

    public void updateProgressById(BigDecimal progress, Long id) {
        jpaQueryFactory.update(qTaskInfoDO)
                .set(qTaskInfoDO.progress, progress)
                .where(qTaskInfoDO.id.eq(id))
                .execute();
    }


    public void updateDelayFlagByIdBatch(String delayFlag, List<Long> ids) {
        jpaQueryFactory.update(qTaskInfoDO)
                .set(qTaskInfoDO.delayFlag, delayFlag)
                .where(qTaskInfoDO.id.in(ids))
                .execute();
    }

    public void updateExecutTimeById(LocalDateTime executTime, Long id) {
        jpaQueryFactory.update(qTaskInfoDO)
                .set(qTaskInfoDO.executTime, executTime)
                .where(qTaskInfoDO.id.eq(id))
                .execute();
    }

    public void updateRepeatSetById(TaskInfoSaveVO saveVO) {
        JPAUpdateClause update = jpaQueryFactory.update(qTaskInfoDO);
        update.set(qTaskInfoDO.repeatSet, saveVO.getRepeatSet());
        if (StringUtils.isNotBlank(saveVO.getRepeatType())) {
            update.set(qTaskInfoDO.repeatType, saveVO.getRepeatType());
        }
        if (!Objects.isNull(saveVO.getRepeatInterval())) {
            update.set(qTaskInfoDO.repeatInterval, saveVO.getRepeatInterval());
        }
        if (StringUtils.isNotBlank(saveVO.getAppointDay())) {
            update.set(qTaskInfoDO.appointDay, saveVO.getAppointDay());
        }
        if (!Objects.isNull(saveVO.getRepeatStartTime())) {
            update.set(qTaskInfoDO.repeatStartTime, saveVO.getRepeatStartTime());
        }
        if (!Objects.isNull(saveVO.getRepeatEndTime())) {
            update.set(qTaskInfoDO.repeatEndTime, saveVO.getRepeatEndTime());
        }
        if (!Objects.isNull(saveVO.getExecutTime())) {
            update.set(qTaskInfoDO.executTime, saveVO.getExecutTime());
        }
        update.where(qTaskInfoDO.id.eq(saveVO.getId()))
                .execute();
    }


    public PagingVO<TaskInfoExportRespVO> exportPage(TaskInfoQueryVO queryVO) {
        List<Predicate> where = where(queryVO);
        List<Predicate> dtlWhere = dtlWhere(queryVO);
        JPAQuery<TaskInfoExportRespVO> query = exportSelect(TaskInfoExportRespVO.class)
                .where(ExpressionUtils.allOf(where))
                .where(ExpressionUtils.allOf(dtlWhere));

        queryVO.setPaging(query);
        queryVO.fillOrders(query, qTaskInfoDO);
        return PagingVO.<TaskInfoExportRespVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private List<Predicate> dtlWhere(TaskInfoQueryVO queryVO) {
        List<Predicate> predicates = new ArrayList<>();

        if (!StringUtils.isEmpty(queryVO.getBusinessKeyword())) {
            predicates.add(qTaskInfoDtlDO.businessCode.like("%" + queryVO.getBusinessKeyword() + "%").or(qTaskInfoDtlDO.businessName.like("%" + queryVO.getBusinessKeyword() + "%")));
        }
        if (!CollectionUtils.isEmpty(queryVO.getExecutUserCodes())) {
            predicates.add(qTaskInfoDtlDO.executUserCode.in(queryVO.getExecutUserCodes()));
        }
        if (!StringUtils.isEmpty(queryVO.getExecutRecordKeyword())) {
            predicates.add(qTaskInfoDtlDO.executRecordCode.like("%" + queryVO.getExecutRecordKeyword() + "%").or(qTaskInfoDtlDO.executRecordName.like("%" + queryVO.getExecutRecordKeyword() + "%")));
        }

        return predicates;
    }

    private <T> JPAQuery<T> exportSelect(Class<T> cls) {
        return jpaQueryFactory.select(Projections.bean(cls,
                qTaskInfoDO.id,
                qTaskInfoDO.code,
                qTaskInfoDO.name,
                qTaskInfoDO.state,
                qTaskInfoDO.delayFlag,
                qTaskInfoDO.progress,
                qTaskInfoDO.type,
                qTaskInfoDO.ouCode,
                qTaskInfoDO.urgencyLevel,
                qTaskInfoDO.startTime,
                qTaskInfoDO.endTime,
                qTaskInfoDO.completeTime,
                qTaskInfoDO.repeatSet,
                qTaskInfoDO.repeatType,
                qTaskInfoDO.repeatInterval,
                qTaskInfoDO.appointDay,
                qTaskInfoDO.repeatStartTime,
                qTaskInfoDO.repeatEndTime,
                qTaskInfoDO.executTime,
                qTaskInfoDO.promotionCode,
                qTaskInfoDO.promotionName,
                qTaskInfoDO.forceSignFlag,
                qTaskInfoDO.signInRange,
                qTaskInfoDO.signOutRange,
                qTaskInfoDO.publishUser,
                qTaskInfoDO.publishUserId,
                qTaskInfoDO.publishUserCode,
                qTaskInfoDO.executTemplate,
                qTaskInfoDO.taskDesc,
                qTaskInfoDO.fileInfo,
                qTaskInfoDO.executTemplateId,
                qTaskInfoDO.executTemplateCode,
                qTaskInfoDO.executTemplateName,
                qTaskInfoDO.remark,
                qTaskInfoDO.createTime,
                qTaskInfoDO.createUserId,
                qTaskInfoDO.creator,
                qTaskInfoDO.modifyTime,
                qTaskInfoDO.modifyUserId,
                qTaskInfoDO.updater,
                qTaskInfoDO.tenantId,
                qTaskInfoDO.deleteFlag,
                qTaskInfoDtlDO.id.as("dtlId"),
                qTaskInfoDtlDO.masId,
                qTaskInfoDtlDO.lineNo,
                qTaskInfoDtlDO.businessType,
                qTaskInfoDtlDO.businessCode,
                qTaskInfoDtlDO.businessId,
                qTaskInfoDtlDO.custCode2,
                qTaskInfoDtlDO.businessName,
                qTaskInfoDtlDO.dealerId,
                qTaskInfoDtlDO.dealerCode,
                qTaskInfoDtlDO.dealerName,
                qTaskInfoDtlDO.businessTime,
                qTaskInfoDtlDO.country,
                qTaskInfoDtlDO.province,
                qTaskInfoDtlDO.city,
                qTaskInfoDtlDO.district,
                qTaskInfoDtlDO.address,
                qTaskInfoDtlDO.executUser,
                qTaskInfoDtlDO.executUserId,
                qTaskInfoDtlDO.executUserCode,
                qTaskInfoDtlDO.completeTime.as("dtlCompleteTime"),
                qTaskInfoDtlDO.completeState,
                qTaskInfoDtlDO.delayFlag.as("dtlDelayFlag"),
                qTaskInfoDtlDO.executRecordName,
                qTaskInfoDtlDO.executRecordId,
                qTaskInfoDtlDO.executRecordCode,
                qTaskInfoDtlDO.xLon.as("longitude"),
                qTaskInfoDtlDO.yLat.as("latitude"),
                qTaskInfoDtlDO.coordType,
                qTaskInfoDtlDO.employeeId
        )).from(qTaskInfoDO).leftJoin(qTaskInfoDtlDO)
                .on(qTaskInfoDO.id.eq(qTaskInfoDtlDO.masId));
    }

}
