package com.elitesland.yst.production.sale.repo.shop;

import cn.hutool.core.lang.Assert;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponQueryParam;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponCustVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.BipCouponCustDo;
import com.elitesland.yst.production.sale.entity.QBipCouponCustDo;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import java.util.ArrayList;

@Component
@RequiredArgsConstructor
public class BipCouponCustRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private final QBipCouponCustDo qBipCouponCustDo = QBipCouponCustDo.bipCouponCustDo;

    public PagingVO<BipCouponCustVO> pageSearch(BipCouponQueryParam param){
        JPAQuery<BipCouponCustVO> query = selectFromWhere(BipCouponCustVO.class,param);
        param.setPaging(query);
        param.fillOrders(query,qBipCouponCustDo);
        return PagingVO.<BipCouponCustVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> selectFromWhere(Class<T> cls, BipCouponQueryParam param){
        return jpaQueryFactory.select(Projections.bean(cls,
                qBipCouponCustDo.id,
                qBipCouponCustDo.couponId,
                qBipCouponCustDo.couponCode,
                qBipCouponCustDo.ouId,
                qBipCouponCustDo.ouName,
                qBipCouponCustDo.userId,
                qBipCouponCustDo.userName,
                qBipCouponCustDo.useStatus,
                qBipCouponCustDo.validStime,
                qBipCouponCustDo.validEtime,
                qBipCouponCustDo.limitAmt,
                qBipCouponCustDo.freeAmt,
                qBipCouponCustDo.detailInfo,
                qBipCouponCustDo.matchType,
                qBipCouponCustDo.creator,
                qBipCouponCustDo.custId,
                qBipCouponCustDo.custName,
                qBipCouponCustDo.custCode,
                qBipCouponCustDo.type)).from(qBipCouponCustDo).where(where(param));
    }


    public Predicate where(BipCouponQueryParam param){
        List<Predicate> predicate = new ArrayList<>();
        if(null != param.getCouponId()){
            predicate.add(qBipCouponCustDo.couponId.eq(param.getCouponId()));
        }
        if(null != param.getOuId()){
            predicate.add(qBipCouponCustDo.ouId.eq(param.getOuId()));
        }
        if(!StringUtils.isEmpty(param.getCouponCode())){
            predicate.add(qBipCouponCustDo.couponCode.like("%" + param.getCouponCode() + "%"));
        }
        if(!StringUtils.isEmpty(param.getMatchType())){
            predicate.add(qBipCouponCustDo.matchType.like("%" + param.getMatchType() + "%"));
        }
        if(null != param.getValidStime()){
            predicate.add(qBipCouponCustDo.validStime.after(param.getValidStime()));
        }
        if(null != param.getValidEtime()){
            predicate.add(qBipCouponCustDo.validEtime.before(param.getValidEtime()));
        }
        if(!StringUtils.isEmpty(param.getUseStatus())){
            predicate.add(qBipCouponCustDo.useStatus.eq(param.getUseStatus()));
        }
        if(!StringUtils.isEmpty(param.getCustName())){
            predicate.add(qBipCouponCustDo.custName.like("%" + param.getCustName() + "%"));
        }
        if(!StringUtils.isEmpty(param.getType())){
            predicate.add(qBipCouponCustDo.type.eq(param.getType()));
        }
        if(null != param.getCustId()){
            predicate.add(qBipCouponCustDo.userId.eq(param.getCustId()));
        }
        predicate.add(qBipCouponCustDo.deleteFlag.isNull().or(qBipCouponCustDo.deleteFlag.eq(0)));
        predicate.add(DataAuthJpaUtil.dataAuthJpaPredicate(qBipCouponCustDo.getMetadata()));
        return ExpressionUtils.allOf(predicate);
    }

    public List<BipCouponCustDo> findCouponRecordByUserID(Long userId,Long custId){
        Assert.notNull(userId,"请登录！");
        return jpaQueryFactory.select(qBipCouponCustDo).from(qBipCouponCustDo)
                .where(qBipCouponCustDo.userId.eq(userId)
                        .and(qBipCouponCustDo.useStatus.eq(UdcEnum.SAL_COUPON_USE_STATUS_NOTUSED.getValueCode()))
                        .and(qBipCouponCustDo.custId.eq(custId))
                        .and(qBipCouponCustDo.deleteFlag.eq(0)))
                .fetch();
    }

    public boolean isReceived(String code,Long userId){
        List<BipCouponCustDo> fetch = jpaQueryFactory.select(qBipCouponCustDo)
                .from(qBipCouponCustDo)
                .where(qBipCouponCustDo.couponCode.eq(code)
                        .and(qBipCouponCustDo.userId.eq(userId)))
                .limit(1)
                .fetch();
        if (fetch!=null&&fetch.size()>0){
            return true;
        }
        return false;
    }


}
