package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.entity.QBipItemExtDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/19
 */
@Repository
public class BipItemExtRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private static final QBipItemExtDO DO = QBipItemExtDO.bipItemExtDO;

    public BipItemExtRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    /**
     * 更新为待审批
     *
     * @param bipItemIds 商品ID
     */
    public void updateToApprove(List<Long> bipItemIds) {
        jpaQueryFactory.update(DO)
                .set(DO.timeApproveCreate, LocalDateTime.now())
                .setNull(DO.timeOnShelfPlan)
                .setNull(DO.timeOffShelfPlan)
                .where(DO.bipItemId.in(bipItemIds))
                .execute();
    }

    /**
     * 更新为待审批
     * <p>
     * 针对定时上架的提交审批
     *
     * @param bipItemIds 商品ID
     */
    public void updateToApprove(List<Long> bipItemIds, LocalDateTime timeOnShelfPlan, LocalDateTime timeOffShelfPlan) {
        jpaQueryFactory.update(DO)
                .set(DO.timeApproveCreate, LocalDateTime.now())
                .set(DO.timeOnShelfPlan, timeOnShelfPlan)
                .set(DO.timeOffShelfPlan, timeOffShelfPlan)
                .where(DO.bipItemId.in(bipItemIds))
                .execute();
    }

    /**
     * 更新为待审批
     * <p>
     * 针对定时下架的提交审批
     *
     * @param bipItemIds 商品ID
     */
    public void updateToApprove(List<Long> bipItemIds, LocalDateTime timeOffShelfPlan) {
        jpaQueryFactory.update(DO)
                .set(DO.timeApproveCreate, LocalDateTime.now())
                .set(DO.timeOffShelfPlan, timeOffShelfPlan)
                .where(DO.bipItemId.in(bipItemIds))
                .execute();
    }

    /**
     * 更新上架相关信息
     *
     * @param id ID
     */
    public void updateToOnShelf(Long id) {
        jpaQueryFactory.update(DO)
                .set(DO.timeOnShelfPlan, (LocalDateTime) null)
                .where(DO.id.eq(id))
                .execute();
    }

    /**
     * 更新下架相关信息
     *
     * @param id ID
     */
    public void updateToOffShelf(Long id) {
        jpaQueryFactory.update(DO)
                .set(DO.timeOffShelfPlan, (LocalDateTime) null)
                .where(DO.id.eq(id))
                .execute();
    }

    /**
     * 删除商品
     *
     * @param bipItemId 商品ID
     */
    public void deleteByBipItemId(Long bipItemId) {
        jpaQueryFactory.delete(DO)
                .where(DO.bipItemId.eq(bipItemId))
                .execute();
    }

    /**
     * 删除商品
     *
     * @param bipItemIds 商品ID
     */
    public void deleteByBipItemId(List<Long> bipItemIds) {
        jpaQueryFactory.delete(DO)
                .where(DO.bipItemId.in(bipItemIds))
                .execute();
    }

    /**
     * 获取预计上架时间
     *
     * @param id ID
     * @return 预计上架时间
     */
    public LocalDateTime getTimeOnShelfPlan(Long id) {
        return jpaQueryFactory.select(DO.timeOnShelfPlan)
                .from(DO)
                .where(DO.id.eq(id))
                .limit(1)
                .fetchOne();
    }

    /**
     * 获取预计下架时间
     *
     * @param id ID
     * @return 预计上线时间
     */
    public LocalDateTime getTimeOffShelfPlan(Long id) {
        return jpaQueryFactory.select(DO.timeOffShelfPlan)
                .from(DO)
                .where(DO.id.eq(id))
                .limit(1)
                .fetchOne();
    }
}

