package com.elitesland.yst.production.sale.rmi.ystsupport;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.service.OrgOuRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/1 4:42 下午
 */
@Component
@Slf4j
public class RmiOrgOuService {

    @Autowired
    private OrgOuRpcService orgOuRpcService;

    public List<OrgOuRpcDTO> findOuDtoListByParam(OrgOuRpcDtoParam param) {
        try {
            List<OrgOuRpcDTO> ouDtoResult = orgOuRpcService.findOuDtoByParam(param);
            return CollUtil.isNotEmpty(ouDtoResult) ? ouDtoResult : new ArrayList<>(0);
        } catch (Exception e) {
            log.error("远程调用支撑域公司相关服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用支撑域公司相关服务异常" + e, e);
        }
    }

    public List<OrgOuRpcDTO> findOuDtoList(List<Long> ouIds, List<String> ouCodes) {
        var orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(ouIds);
        orgOuRpcDtoParam.setOuCodes(ouCodes);
        return this.findOuDtoListByParam(orgOuRpcDtoParam);
    }

    public List<OrgOuRpcDTO> findOuDtoListByName(List<String> ouNames) {
        var orgOuRpcDtoParam = new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuNames(ouNames);
        return this.findOuDtoListByParam(orgOuRpcDtoParam);
    }


    /**
     * 根据公司编码批量查询公司
     *
     * @param ouCodes 公司编码
     * @return 公司信息
     */
    public List<OrgOuRpcDTO> findOuDtoListByOuCodes(List<String> ouCodes) {
        log.info("调用support域:根据编码查询公司,时间：{},入参：{}", LocalDateTime.now(), ouCodes);
        try {
            if (CollectionUtils.isEmpty(ouCodes)){
                return Collections.emptyList();
            }
            OrgOuRpcDtoParam orgOuRpcDtoParam = new OrgOuRpcDtoParam();
            orgOuRpcDtoParam.setOuCodes(ouCodes);
            List<OrgOuRpcDTO> orgOuRpcDTOList = this.findOuDtoListByParam(orgOuRpcDtoParam);
            log.info("调用support域:根据编码查询公司,时间：{},出参：{}", LocalDateTime.now(), orgOuRpcDTOList);
            return orgOuRpcDTOList;
        } catch (Exception e) {
            log.error("调用support域:根据编码查询公司,error：{}", e.getMessage());
            throw new BusinessException("调用support域:" + e.getMessage());
        }
    }


}
