package com.elitesland.yst.production.sale.rmi.ystsystem;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.system.param.SysUserNewParam;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
//import com.elitescloud.cloudt.system.service.rpc.SysOauth2RpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * <p>
 * 系统域远程调用服务
 * </p>
 *
 * @author ssy
 * @since 2021/9/16
 */
@Component
@Slf4j
public class RmiSysOauth2RpcService {

//    @DubboReference(check = false, timeout = 10000)
//    private SysOauth2RpcService sysOauth2RpcService;
    @Autowired
    private SysUserRpcService sysUserRpcService;

    public ApiResult<Long> sysUserCreate(SysUserNewParam user, String password) {
        try {
            return sysUserRpcService.sysUserCreate(user, password);
        }catch (Exception e) {
            log.error("远程调用系统域创建账户服务异常:{}", e.getMessage());
            throw new BusinessException("远程调用系统域创建账户服务异常"+e,e);
        }
    }
}