package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.ExectRecordService;
import com.elitesland.yst.production.sale.api.service.TaskInfoDtlService;
import com.elitesland.yst.production.sale.api.service.TaskInfoService;
import com.elitesland.yst.production.sale.api.vo.param.com.FileParamVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExectRecordDtlTempQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.ExecutRecordQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.FileInfoQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.*;
import com.elitesland.yst.production.sale.api.vo.save.*;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.ExectRecordConvert;
import com.elitesland.yst.production.sale.convert.ExectRecordDtlConvert;
import com.elitesland.yst.production.sale.convert.ExectRecordDtlTempConvert;
import com.elitesland.yst.production.sale.convert.FileinfoConvert;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.*;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import lombok.AllArgsConstructor;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

@Slf4j
@Service
@RequiredArgsConstructor
public class ExectRecordServiceImpl implements ExectRecordService {

    private final ExecutRecordRepo executRecordRepo;
    private final ExecutRecordRepoProc executRecordRepoProc;
    private final ExecutRecordDtlRepo executRecordDtlRepo;
    private final ExecutRecordDtlRepoProc executRecordDtlRepoProc;
    private final ExectRecordDtlTempRepo exectRecordDtlTempRepo;
    private final ExectRecordDtlTempRepoProc exectRecordDtlTempRepoProc;
    private final SalesmanInfoRepo salesmanInfoRepo;
    private final SalesmanRegionRepo salesmanRegionRepo;
    
    private final RmiSysNextNumberService rmiSysNextNumberService;

    private final SysUdcProxyService sysUdcProxyService;
    private final UdcProvider udcProvider;
    
    private final FileInfoRepoProc fileInfoRepoProc;
    private final FileInfoRepo fileInfoRepo;
    private final TaskInfoDtlService taskInfoDtlService;
    private final TaskInfoService taskInfoService;

    @Value("${file.upload.url}")
    private String fileServerUrl;


    /**
     * 保存不校验必填项
     * @param saveVO
     * @return
     */
    @Override
    @Transactional
    public Long save(ExecutRecordSaveVO saveVO) {
        log.info("执行记录入参:" + JSON.toJSONString(saveVO));
        String orderNo= null;

        //2.没有id新增，有id修改，增加时发号器发号，修改时使用原单号；编辑时需要校验状态
        if(saveVO.getId() != null && saveVO.getId() !=0){
            if (!UdcEnum.EXECT_RECORD_STATUS_DR.getValueCode().equals(saveVO.getState()) &&
                    !UdcEnum.EXECT_RECORD_STATUS_ARN.getValueCode().equals(saveVO.getState()) ){
                throw new BusinessException(ApiCode.FAIL, "非草稿，审核拒绝状态不允许编辑");
            }
            //修改时明细全删全插
            executRecordDtlRepo.deleteByMasId(saveVO.getId());
            //附件表全删全查
            fileInfoRepoProc.sourceDel(Arrays.asList(saveVO.getId()));
            //记录模板附件数据全删全插
            exectRecordDtlTempRepoProc.sourceDel(Arrays.asList(saveVO.getId()));
        }else{
            //发号器发号
            orderNo = rmiSysNextNumberService.generateCode("yst-sale","RCD", new ArrayList<>());
            log.info("执行记录发号："+JSON.toJSONString(orderNo));
        }

        //3.新增/修改单据默认草稿状态
        saveVO.setState(UdcEnum.EXECT_RECORD_STATUS_DR.getValueCode());
        saveVO.setCode(StringUtils.isEmpty(orderNo) ? saveVO.getCode() : orderNo);
        ExecutRecordDO executRecordDO = ExectRecordConvert.INSTANCE.voToDO(saveVO);
        Long id = executRecordRepo.save(executRecordDO).getId();

        //4.保存明细数据
        List<ExecutRecordDtlSaveVO> executRecordDtlSaveVOS = saveVO.getExecutRecordDtlSaveVOS();
        if(!CollectionUtils.isEmpty(executRecordDtlSaveVOS)){
            List<ExecutRecordDtlDO> collect = executRecordDtlSaveVOS.stream().map(t -> {
                ExecutRecordDtlDO executRecordDtlDO = ExectRecordDtlConvert.INSTANCE.voToDO(t);
                executRecordDtlDO.setMasId(id);
                return executRecordDtlDO;
            }).collect(Collectors.toList());
            executRecordDtlRepo.saveAll(collect);
        }

        //5.保存文件数据
        List<FileInfoSaveVO> fileInfoSaveVOS = saveVO.getFileInfoSaveVOS();
        if(!CollectionUtils.isEmpty(fileInfoSaveVOS)){
            List<FileInfoDO> collect = fileInfoSaveVOS.stream().map(t -> {
                FileInfoDO fileInfoDO = FileinfoConvert.INSTANCE.voToDO(t);
                fileInfoDO.setSourceId(id);
                return fileInfoDO;
            }).collect(Collectors.toList());
            fileInfoRepo.saveAll(collect);
        }

        //6.保存记录模板附件数据
        List<ExectRecordDtlTempSaveVO> tempDtlSaveVOS = saveVO.getTempDtlSaveVOS();
        if(!CollectionUtils.isEmpty(tempDtlSaveVOS)){
            List<ExectRecordDtlTempDO> collect = tempDtlSaveVOS.stream().map(t -> {
                ExectRecordDtlTempDO exectRecordDtlTempDO = ExectRecordDtlTempConvert.INSTANCE.voToDO(t);
                exectRecordDtlTempDO.setRecordId(id);
                return exectRecordDtlTempDO;
            }).collect(Collectors.toList());
            exectRecordDtlTempRepo.saveAll(collect);
        }

        //保存时任务状态修改
        if(saveVO.getId() == null || saveVO.getId() ==0) {
            saveVO.setId(id);
            this.updateTask(saveVO, ConstantsSale.TASK_EXECUTION_RECORD_SAVE);
        }
        return id;
    }

    @Override
    @SysCodeProc
    public PagingVO<ExecutRecordRespVO> query(ExecutRecordQueryParam param) {
        log.info("执行记录分页入参"+  JSON.toJSONString(param));
        PagingVO<ExecutRecordRespVO> page = executRecordRepoProc.page(param);
        //设置执行人管辖区域
        setJurisdictionName(page.getRecords());
        return page;
    }

    /**
     * 设置执行人管辖区域
     * @param records
     */
    private void setJurisdictionName(List<ExecutRecordRespVO> records) {
        if (!CollectionUtils.isEmpty(records)) {
            List<String> salesmanNos = records.stream().map(ExecutRecordRespVO::getExecutUserCode).filter(StrUtil::isNotEmpty).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(salesmanNos)) {
                return;
            }
            List<SalesmanInfoDO> bySalesmanNoIn = salesmanInfoRepo.findBySalesmanNoIn(salesmanNos);
            if (CollectionUtils.isEmpty(bySalesmanNoIn)) {
                return;
            }
            List<Long> salesmanIds = bySalesmanNoIn.stream().map(SalesmanInfoDO::getId).collect(Collectors.toList());
            List<SalesmanRegionDO> regionDOS = salesmanRegionRepo.findByMasIdIn(salesmanIds);
            if (CollUtil.isNotEmpty(regionDOS)) {
                Map<Long, List<SalesmanRegionDO>> map = regionDOS.stream().collect(Collectors.groupingBy(SalesmanRegionDO::getMasId));
                Map<String, String> regionMap = udcProvider.getValueMapByUdcCode("yst-supp", "REGION");

                records.forEach(i -> {
                    if (StringUtils.isNotEmpty(i.getExecutUserCode())) {
                        i.setExecutUserId(bySalesmanNoIn.stream().filter(salesmanInfoDO -> salesmanInfoDO.getSalesmanNo().equals(i.getExecutUserCode()))
                                .map(SalesmanInfoDO::getId)
                                .findAny().orElse(null));
                    }
                    if (!CollectionUtils.isEmpty(map.get(i.getExecutUserId()))) {
                        String jurisdictionName = map.get(i.getExecutUserId()).stream().map(SalesmanRegionDO::getRegionCode)
                                .filter(StringUtils::isNotEmpty)
                                .map(regionCode -> regionMap.get(regionCode))
                                .filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
                        i.setJurisdictionName(jurisdictionName);
                    }
                });
            }
        }
    }

    @Override
    @SysCodeProc
    public ExecutRecordRespVO queryDtl(ExecutRecordQueryParam param) {
        log.info("执行记录明细入参"+  JSON.toJSONString(param));
        if(param.getId() == null || param.getId() == 0){
            throw new BusinessException(ApiCode.FAIL, "id为空，请检查！");
        }
        //查询执行记录表，明细表
        ExecutRecordRespVO executRecordRespVO = executRecordRepoProc.get(param.getId());
        List<ExecutRecordDtlRespVO> exectRecordTempDtlRespVOS = executRecordDtlRepoProc.getByMasId(param.getId());
        TaskInfoDtlRespVO taskInfoDtlRespVO = taskInfoDtlService.findById(executRecordRespVO.getTaskDtlId());
        exectRecordTempDtlRespVOS.forEach(x ->{
            x.setBusinessCode(taskInfoDtlRespVO.getBusinessCode());
            x.setBusinessName(taskInfoDtlRespVO.getBusinessName());
            x.setDealerCode(taskInfoDtlRespVO.getDealerCode());
            x.setDealerName(taskInfoDtlRespVO.getDealerName());
        });
        executRecordRespVO.setExecutRecordDtlRespVOS(exectRecordTempDtlRespVOS);
        //设置执行人管辖区域
        setJurisdictionName(List.of(executRecordRespVO));
        //查询文件附件表
        FileInfoQueryVO fileInfoQueryVO = new FileInfoQueryVO();
        fileInfoQueryVO.setSourceId(param.getId());
        List<FileInfoRespVO> list = fileInfoRepoProc.getList(fileInfoQueryVO);
        //更新文件url
        // list.forEach(s -> {
        //     if (StringUtils.isNotBlank(s.getFilePath())){
        //         s.setUrl(fileServerUrl + s.getFilePath());
        //     }
        // });
        executRecordRespVO.setFileInfoRespVOS(list);
        //查询模板附件表
        ExectRecordDtlTempQueryParam exectRecordTempRespVO = new ExectRecordDtlTempQueryParam();
        exectRecordTempRespVO.setRecordId(param.getId());
        List<ExectRecordDtlTempRespVO> tempRespVOS = exectRecordDtlTempRepoProc.getList(exectRecordTempRespVO);
        //更新文件url
        // updateTempUrl(tempRespVOS);
        sysUdcProxyService.translate(tempRespVOS);
        executRecordRespVO.setRecordDtlTempRespVOS(tempRespVOS);

        //查询执行任务
        if(StringUtils.isNotEmpty(executRecordRespVO.getTaskCode())){
            TaskInfoRespVO byCode = taskInfoService.findByCode(executRecordRespVO.getTaskCode());
            executRecordRespVO.setForceSignFlag(byCode.getForceSignFlag());
            executRecordRespVO.setExecutTemplateCode(byCode.getExecutTemplateCode());
        }


        return executRecordRespVO;
    }

    private void updateTempUrl(List<ExectRecordDtlTempRespVO> tempRespVOS) {
        tempRespVOS.forEach(s -> {
            if (StringUtils.isNotBlank(s.getVal()) &&
                    (UdcEnum.TEMP_FILE_UPLOAD.getValueCode().equals(s.getType()) || UdcEnum.TEMP_IMAGE_UPLOAD.getValueCode().equals(s.getType()))){
                JSONArray jsonArray = JSON.parseArray(s.getVal());
                Object[] array = jsonArray.stream().toArray();
                List<FileParamVO> fileParamVOS = new ArrayList<>();
                for (int i = 0; i< array.length; i++){
                    FileParamVO fileParamVO = JSON.parseObject(String.valueOf(array[i]), FileParamVO.class);
                    if (StringUtils.isNotBlank(fileParamVO.getFilePath())){
                        fileParamVO.setUrl(fileServerUrl + fileParamVO.getFilePath());
                    }
                    fileParamVOS.add(fileParamVO);
                }
                s.setVal(JSON.toJSONString(fileParamVOS));
            }
        });
    }

    /**
     * 查看上次记录接口查询逻辑：
     * 只在‘待审核’状态的详情页展示此按钮，查看最近一次的‘审核通过’状态的，根据任务类型+业务编码，匹配执行记录详情展示明细信息；
     * @param param
     * @return
     */
    @Override
    @SysCodeProc
    public ExecutRecordRespVO queryByLast(ExecutRecordQueryParam param) {
        log.info("执行记录明细入参"+  JSON.toJSONString(param));
        if(param.getId() == null || param.getId() == 0){
            throw new BusinessException(ApiCode.FAIL, "主表id为空，请检查！");
        }

        //查询当前数据记录
        ExecutRecordRespVO executRecordRespVO = executRecordRepoProc.get(param.getId());
        if(StringUtils.isEmpty(executRecordRespVO.getTaskType()) || StringUtils.isEmpty(executRecordRespVO.getBusinessCode())){
            throw new BusinessException(ApiCode.FAIL, "任务类型/业务编码为空，请检查");
        }

        //根据任务类型+业务编码查看‘审核通过’状态的数据
        List<ExecutRecordRespVO> executRecordRespVOS = executRecordRepoProc.queryBylast(executRecordRespVO.getTaskType(),executRecordRespVO.getBusinessCode());
        if(CollectionUtils.isEmpty(executRecordRespVOS)){
            return null;
        }

        //udc翻译
        sysUdcProxyService.translate(executRecordRespVOS);
        ExecutRecordQueryParam executRecordQueryParam = new ExecutRecordQueryParam();
        executRecordQueryParam.setId(executRecordRespVOS.get(0).getId());
        return this.queryDtl(executRecordQueryParam);
    }

    @Override
    @Transactional
    public Long approved(ExecutRecordSaveVO saveVO) {
        //校验
        ExecutRecordRespVO executRecordRespVO = this.approvedCheck(saveVO);
        executRecordRespVO.setState(UdcEnum.EXECT_RECORD_STATUS_CPD.getValueCode());
        executRecordRespVO.setAuditDesc(saveVO.getAuditDesc());
        //数据保存
        ExecutRecordDO executRecordDO = ExectRecordConvert.INSTANCE.respToDO(executRecordRespVO);
        Long id = executRecordRepo.save(executRecordDO).getId();
        //任务状态修改
        ExecutRecordSaveVO executRecordSaveVO = new ExecutRecordSaveVO();
        executRecordSaveVO.setTaskDtlId(executRecordRespVO.getTaskDtlId());
        executRecordSaveVO.setId(id);
        executRecordSaveVO.setCode(executRecordRespVO.getCode());
        this.updateTask(executRecordSaveVO,ConstantsSale.TASK_EXECUTION_RECORD_PASS);
        return id;
    }

    @Override
    @Transactional
    public Long refuse(ExecutRecordSaveVO saveVO) {
        //校验
        ExecutRecordRespVO executRecordRespVO = this.approvedCheck(saveVO);
        executRecordRespVO.setState(UdcEnum.EXECT_RECORD_STATUS_ARN.getValueCode());
        executRecordRespVO.setAuditDesc(saveVO.getAuditDesc());
        //数据保存
        ExecutRecordDO executRecordDO = ExectRecordConvert.INSTANCE.respToDO(executRecordRespVO);
        Long id = executRecordRepo.save(executRecordDO).getId();
        //任务状态修改
        ExecutRecordSaveVO executRecordSaveVO = new ExecutRecordSaveVO();
        executRecordSaveVO.setTaskDtlId(executRecordRespVO.getTaskDtlId());
        executRecordSaveVO.setId(id);
        executRecordSaveVO.setCode(executRecordRespVO.getCode());
        this.updateTask(executRecordSaveVO,ConstantsSale.TASK_EXECUTION_RECORD_REFUSE);
        return id;
    }

    @Override
    @Transactional
    public Long submit(ExecutRecordSaveVO saveVO) {
        //1.必填字段非空校验
        this.check(saveVO);
        //保存不校验必填项
        Long save = this.save(saveVO);

        //保存完数据修改主表状态为待审核
        executRecordRepoProc.updateById(save,UdcEnum.EXECT_RECORD_STATUS_WAT.getValueCode());

        //任务状态修改
        this.updateTask(saveVO, ConstantsSale.TASK_EXECUTION_RECORD_SUBMIT);

        return save;
    }

    /**
     * 执行记录 根据编码批量查询执行记录主要信息(ID、编码、名称)
     * @param codes
     * @return
     */
    @Override
    public List<ExecutRecordRespVO> queryByCodes(List<String> codes) {
        log.info("执行记录明细入参"+  JSON.toJSONString(codes));
        if (CollectionUtils.isEmpty(codes)){
            return null;
        }
        List<ExecutRecordRespVO> executRecordRespVOS = executRecordRepoProc.queryByCodes(codes);
        return executRecordRespVOS;
    }

    @Override
    @Transactional
    public Long close(List<String> code) {
        log.info("执行记录状态关闭入参"+  JSON.toJSONString(code));
        if (CollectionUtils.isEmpty(code)){
            throw new BusinessException(ApiCode.FAIL, "入参为空");
        }
        Long aLong = executRecordRepoProc.updateByCode(code,UdcEnum.EXECT_RECORD_STATUS_CSD.getValueCode());
        return aLong;
    }

    @Override
    @Transactional
    public Long filterClose(List<String> codes) {
        log.info("执行记录状态过滤非审核通过入参"+  JSON.toJSONString(codes));
        if (CollectionUtils.isEmpty(codes)){
            throw new BusinessException(ApiCode.FAIL, "入参为空");
        }
        List<ExecutRecordRespVO> executRecordRespVOS = executRecordRepoProc.queryByCodes(codes);
        if(CollectionUtils.isEmpty(executRecordRespVOS)){
            return null;
        }
        List<ExecutRecordRespVO> collect = executRecordRespVOS.stream().filter(t -> !t.getState().equals(UdcEnum.EXECT_RECORD_STATUS_CPD.getValueCode())).collect(Collectors.toList());

       // Long aLong = this.close(CollectionUtils.isEmpty(collect) ? null : collect.stream().map(ExecutRecordRespVO::getCode).collect(Collectors.toList()));

        Long aLong = null;
        if(!CollectionUtils.isEmpty(collect)){
            aLong =  this.close(collect.stream().map(ExecutRecordRespVO::getCode).collect(Collectors.toList()));
        }
        return aLong;
    }

    @Override
    @Transactional
    public Long complete(List<String> codes) {
        log.info("执行记录状态完成入参"+  JSON.toJSONString(codes));
        if (CollectionUtils.isEmpty(codes)){
            throw new BusinessException(ApiCode.FAIL, "入参为空");
        }
        Long aLong = executRecordRepoProc.updateByCode(codes,UdcEnum.EXECT_RECORD_STATUS_CPD.getValueCode());
        return aLong;
    }

    @SysCodeProc
    @Override
    public PagingVO<ExecutRecordExportVO> pageExport(ExecutRecordQueryParam param) {
        PagingVO<ExecutRecordExportVO> executRecordExportVOPagingVO = executRecordRepoProc.pageExport(param);
        //设置执行人管辖区域
        setJurisdictionNameExport(executRecordExportVOPagingVO.getRecords());
        return executRecordExportVOPagingVO;
    }
    private void setJurisdictionNameExport(List<ExecutRecordExportVO> records) {
        if (!CollectionUtils.isEmpty(records)) {
            List<String> salesmanNos = records.stream().map(ExecutRecordExportVO::getExecutUserCode).filter(StrUtil::isNotEmpty).distinct().collect(Collectors.toList());
            if (CollectionUtils.isEmpty(salesmanNos)) {
                return;
            }
            List<SalesmanInfoDO> bySalesmanNoIn = salesmanInfoRepo.findBySalesmanNoIn(salesmanNos);
            if (CollectionUtils.isEmpty(bySalesmanNoIn)) {
                return;
            }
            List<Long> salesmanIds = bySalesmanNoIn.stream().map(SalesmanInfoDO::getId).collect(Collectors.toList());
            List<SalesmanRegionDO> regionDOS = salesmanRegionRepo.findByMasIdIn(salesmanIds);
            if (CollUtil.isNotEmpty(regionDOS)) {
                Map<Long, List<SalesmanRegionDO>> map = regionDOS.stream().collect(Collectors.groupingBy(SalesmanRegionDO::getMasId));
                Map<String, String> regionMap = udcProvider.getValueMapByUdcCode("yst-supp", "REGION");

                records.forEach(i -> {
                    if (StringUtils.isNotEmpty(i.getExecutUserCode())) {
                        i.setExecutUserId(bySalesmanNoIn.stream().filter(salesmanInfoDO -> salesmanInfoDO.getSalesmanNo().equals(i.getExecutUserCode()))
                                .map(SalesmanInfoDO::getId)
                                .findAny().orElse(null));
                    }
                    if (!CollectionUtils.isEmpty(map.get(i.getExecutUserId()))) {
                        String jurisdictionName = map.get(i.getExecutUserId()).stream().map(SalesmanRegionDO::getRegionCode)
                                .filter(StringUtils::isNotEmpty)
                                .map(regionCode -> regionMap.get(regionCode))
                                .filter(StringUtils::isNotEmpty).collect(Collectors.joining(","));
                        i.setJurisdictionName(jurisdictionName);
                    }
                });
            }
        }
    }


    /**
     * 审核通过/拒绝 入参校验
     * @param saveVO
     * @return
     */
    public ExecutRecordRespVO approvedCheck (ExecutRecordSaveVO saveVO) {
        if(saveVO.getId() == null || saveVO.getId() ==0){
            throw new BusinessException(ApiCode.FAIL, "id为空，请检查");
        }
        if (saveVO.getAuditDesc() ==null){
            throw new BusinessException(ApiCode.FAIL, "审核原因内容必填，请检查！");
        }
        ExecutRecordRespVO executRecordRespVO = executRecordRepoProc.get(saveVO.getId());
        if(Objects.isNull(executRecordRespVO)){
            throw new BusinessException(ApiCode.FAIL, "单据不存在，请检查！");
        }
        //校验
        if (!UdcEnum.EXECT_RECORD_STATUS_WAT.getValueCode().equals(executRecordRespVO.getState())){
            throw new BusinessException(ApiCode.FAIL, "非待审核状态不允许审核");
        }
        return  executRecordRespVO;
    }

    /**
     * 必填校验
     * @param saveVO
     */
    private void check(ExecutRecordSaveVO saveVO) {

        if (saveVO.getTaskType() ==null){
            throw new BusinessException(ApiCode.FAIL, "任务类型为空，请检查！");
        }

        if(!CollectionUtils.isEmpty(saveVO.getExecutRecordDtlSaveVOS())){
            saveVO.getExecutRecordDtlSaveVOS().stream().forEach(t -> {
                if (t.getEntryTime() ==null){
                    throw new BusinessException(ApiCode.FAIL, "进店时间为空，请检查！");
                }
                if (t.getLeaveTime() ==null){
                    throw new BusinessException(ApiCode.FAIL, "离店时间为空，请检查！");
                }
            });
        }else {
            throw new BusinessException(ApiCode.FAIL, "执行记录明细为空，请检查！");
        }

    }

    /**
     * 用于后续与任务管理联调
     */
    private void updateTask(ExecutRecordSaveVO saveVO,String type) {
        log.info("调用任务接口入参:" + JSON.toJSONString(saveVO)+","+JSON.toJSONString(type));
        if (saveVO.getTaskDtlId() == 0 || saveVO.getTaskDtlId() == null ){
            return;
        }
        TaskExecutionRecordSaveVO taskExecutionRecordSaveVO = new TaskExecutionRecordSaveVO();
        taskExecutionRecordSaveVO.setExecuteType(type);
        taskExecutionRecordSaveVO.setTaskDtlId(saveVO.getTaskDtlId());
        taskExecutionRecordSaveVO.setExecutRecordId(saveVO.getId());
        taskExecutionRecordSaveVO.setExecutRecordCode(saveVO.getCode());
        taskInfoDtlService.executionRecordCallback(taskExecutionRecordSaveVO);
    }

}
