package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
//import com.elitesland.yst.production.sale.api.service.SalContractService;
import com.elitesland.yst.production.sale.api.service.SalProjService;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalProjPagingParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalProjQueryParam;
import com.elitesland.yst.production.sale.api.vo.param.pro.SalProjSaveParam;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalProjDetailRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalProjPageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.pro.SalProjSimpleRespVO;
import com.elitesland.yst.production.sale.api.vo.save.SalProjImportSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.convert.SalProjConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.QSalProjDO;
import com.elitesland.yst.production.sale.entity.SalProjDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.CrmScustRepoProc;
import com.elitesland.yst.production.sale.repo.SalProjRepo;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgBuService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.support.provider.org.dto.OrgBuRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.hssf.record.DVALRecord;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/8 9:05 上午
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class SalProjServiceImpl extends BaseServiceImpl implements SalProjService {

    private final QSalProjDO qSalProjDO = QSalProjDO.salProjDO;
    private final SalProjRepo salProjRepo;
//    private final SalContractService salContractService;
    private final ComSaleFileInfoService comSaleFileInfoService;
    private final RmiOrgOuService rmiOrgOuService;
    private final RmiSysNextNumberService nextNumberService;
    private final RmiOrgBuService rmiOrgBuService;
    private final CrmCustRepoProc crmCustRepoProc;
    private final CrmScustRepoProc crmScustRepoProc;

    @Override
    @SysCodeProc
    public PagingVO<SalProjPageRespVO> query(SalProjPagingParam pageParam) {
        var predicate = buildPageSearchCondition(pageParam);
        var jpaQuery = jpaQueryFactory.selectFrom(qSalProjDO).where(predicate);
        long total = jpaQuery.fetchCount();
        if (total == 0) {
            return PagingVO.<SalProjPageRespVO>builder().build();
        }
        // 添加分页和排序
        var pageRequest = wrapperPageRequest(pageParam.getPageRequest(), null);
        appendPageAndSort(jpaQuery, pageRequest, qSalProjDO);
        // 查询结果
        List<SalProjDO> queryResult = jpaQuery.fetch();
        List<SalProjPageRespVO> pageResult = queryResult.stream().map(SalProjConvert.INSTANCE::doToPageRespVo).collect(Collectors.toList());

        // 反查公司
        List<Long> ouIds = queryResult.stream().map(SalProjDO::getOuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgOuRpcDTO> ouRpcResult = rmiOrgOuService.findOuDtoList(ouIds, null);

        // 反查公司
        List<Long> buIds = queryResult.stream().map(SalProjDO::getBuId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<OrgBuRpcDTO> buRpcResult = rmiOrgBuService.findBuDtoList(buIds, null);

        pageResult.forEach(r -> {
            // 回填公司名称
            ouRpcResult.stream().filter(ou -> (Objects.nonNull(r.getOuId()) && r.getOuId().equals(ou.getId())))
                    .findFirst().ifPresent(o -> r.setOuName(o.getOuName()));
            // 回填bu组织
            buRpcResult.stream().filter(bu -> (Objects.nonNull(r.getBuId())) && r.getBuId().equals(bu.getId()))
                    .findFirst().ifPresent(b ->r.setBuName(b.getBuName()));
        });

        return PagingVO.<SalProjPageRespVO>builder().total(total).records(pageResult).build();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public JSONObject save(SalProjSaveParam param) {
        // 校验是否已经存在
        SalProjDO checkProjName = salProjRepo.findByProjName(param.getProjName());
        if (Objects.nonNull(checkProjName)) {
            if (Objects.isNull(param.getId()) ||
                    (Objects.nonNull(param.getId()) && !param.getId().equals(checkProjName.getId()))) {
                throw new BusinessException("项目名称已存在，请在查询界面查询此项目");
            }
        }
        // 生成项目编号
        if (Objects.isNull(param.getId())) {
            String projNo = nextNumberService.generateCode("yst-sale","SAL_PROJ_NO", new ArrayList<>());
            param.setProjNo(projNo);
        }else {
            SalProjDO salProjDO = salProjRepo.findById(param.getId()).orElseThrow(new BusinessException("项目不存在"));
            param.setProjNo(salProjDO.getProjNo());
        }
        var salProjDO = SalProjConvert.INSTANCE.paramToDo(param);
        salProjDO.setDeleteFlag(0);
        // 数据权限字段
        salProjDO.setSecBuId(param.getBuId());
        salProjDO.setSecOuId(param.getOuId());
        //获取当前登录人(确定修改人信息)
      //  GeneralUserDetails user = SecurityContextUtil.currentUser();
//        if (!ObjectUtils.isEmpty(user) && !ObjectUtils.isEmpty(user.getSecurityOrgUserEmpBuDTO())){
//            salProjDO.setSecUserId(user.getSecurityOrgUserEmpBuDTO().getEmpId());
//        }
        salProjRepo.save(salProjDO);
        // 保存附件
        comSaleFileInfoService.comSaleFileHardSave("SAL_PROJ", salProjDO.getId(), param.getAttachFiles());
        // 返回项目Id及项目编号
        var result = new JSONObject();
        result.put("id", salProjDO.getId());
        result.put("projNo", salProjDO.getProjNo());
        return result;
    }

    @Override
    @SysCodeProc
    public SalProjDetailRespVO queryOneDetail(Long id) {
        var salProjDO = salProjRepo.findById(id).orElseThrow(new BusinessException("项目不存在"));
        var salProjDetailRespVO = SalProjConvert.INSTANCE.doToDetailRespVo(salProjDO);
        // 填充公司名称
        Long ouId = salProjDetailRespVO.getOuId();
        List<OrgOuRpcDTO> ouRpcResult = rmiOrgOuService.findOuDtoList(Lists.newArrayList(ouId), null);
        ouRpcResult.stream().filter(ou -> (Objects.nonNull(ou) && ouId.equals(ou.getId())))
                .findFirst().ifPresent(o -> salProjDetailRespVO.setOuName(o.getOuName()));
        // 填充组织名称
        Long buId = salProjDetailRespVO.getBuId();
        List<OrgBuRpcDTO> buRpcResult = rmiOrgBuService.findBuDtoList(Lists.newArrayList(buId), null);
        buRpcResult.stream().filter(bu -> (Objects.nonNull(bu) && buId.equals(bu.getId())))
                .findFirst().ifPresent(o -> salProjDetailRespVO.setBuName(o.getBuName()));
        // 填充附件
        List<ComSaleFileComVO> attachFiles = comSaleFileInfoService.findFileByBusinessId("SAL_PROJ", id);
        salProjDetailRespVO.setAttachFiles(attachFiles);
        return salProjDetailRespVO;
    }

    @Override
    public void delSalProj(List<Long> ids) {
        if (CollUtil.isNotEmpty(ids)) {
//            List<SalProjDO> salProjDOS = salProjRepo.findAllById(ids);
//            if (CollUtil.isNotEmpty(salProjDOS)) {
//                List<String> projNames = salProjDOS.stream().map(SalProjDO::getProjName).filter(StrUtil::isNotBlank).collect(Collectors.toList());
//                // 查询是否被合同引用
//                List<String> result = salContractService.queryByProjName(projNames).stream()
//                        .map(SalContractSimpleRespVO::getProjName).distinct().collect(Collectors.toList());
//                if (CollUtil.isNotEmpty(result)) {
//                    StringJoiner proj = new StringJoiner(",", "[", "]");
//                    result.forEach(r -> proj.add(r));
//                    throw new BusinessException("项目" + proj.toString() + "已被合同引用无法删除");
//                }
//                salProjDOS.forEach(s -> s.setDeleteFlag(1));
//                salProjRepo.saveAll(salProjDOS);
//            }
        }
    }

    @Override
    public List<SalProjSimpleRespVO> queryByParam(SalProjQueryParam param) {
        Predicate predicate = qSalProjDO.isNotNull();
        if (Objects.nonNull(param)) {
            if (Objects.nonNull(param.getId())) {
                predicate = ExpressionUtils.and(predicate, qSalProjDO.id.eq(param.getId()));
            }
            if (StrUtil.isNotBlank(param.getProjNo())) {
                predicate = ExpressionUtils.and(predicate, qSalProjDO.projNo.like("%" + param.getProjNo().trim() + "%"));
            }
            if (StrUtil.isNotBlank(param.getProjName())) {
                predicate = ExpressionUtils.and(predicate, qSalProjDO.projName.like("%" + param.getProjName().trim() + "%"));
            }
            if (StrUtil.isNotBlank(param.getProjType())) {
                predicate = ExpressionUtils.and(predicate, qSalProjDO.projType.eq(param.getProjType()));
            }
            if (Objects.nonNull(param.getCustId())) {
                predicate =  ExpressionUtils.and(predicate, qSalProjDO.custId.eq(param.getCustId()));
            }
            if (CollUtil.isNotEmpty(param.getIds())) {
                predicate = ExpressionUtils.and(predicate, qSalProjDO.id.in(param.getIds()));
            }
            if (CollUtil.isNotEmpty(param.getProjNos())) {
                predicate = ExpressionUtils.and(predicate, qSalProjDO.projNo.in(param.getProjNos()));
            }
            if (Objects.nonNull(param.getOuId())) {
                predicate = ExpressionUtils.and(predicate, qSalProjDO.ouId.eq(param.getOuId()));
            }
            if (StrUtil.isNotBlank(param.getProjStatus())) {
                predicate = ExpressionUtils.and(predicate, qSalProjDO.projStatus.eq(param.getProjStatus()));
            }
        } else {
            return new ArrayList<>(0);
        }
        // 查询结果
        var jpaQuery = jpaQueryFactory.selectFrom(qSalProjDO).where(predicate);
        List<SalProjDO> queryResult = jpaQuery.fetch();
        return queryResult.stream().map(SalProjConvert.INSTANCE::doToSimpleVo).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> projImportData(List<SalProjImportSaveVO> parseData) {
        importDataHandle(parseData);
        List<SalProjDO> salProjDOS = parseData.stream().map(SalProjConvert.INSTANCE::importToDo).collect(Collectors.toList());
        salProjRepo.saveAll(salProjDOS);
        return ApiResult.ok();
    }

    private void importDataHandle(List<SalProjImportSaveVO> parseData){
       // Udc 反查
//        List<SysUdcComboVO> regionUdcList = sysUdcService.listCodeCombos("ORG", "OU_REGION");
//        List<SysUdcComboVO> custTypeUdcList = sysUdcService.listCodeCombos("SAL", "PROJ_CUST_TYPE");
//        List<SysUdcComboVO> custSourceTypeUdcList = sysUdcService.listCodeCombos("CRM", "CUST_SOURCE");
//        List<SysUdcComboVO> projTypeUdcList = sysUdcService.listCodeCombos("SAL", "PROJ_TYPE");
//        List<SysUdcComboVO> projPaymentType = sysUdcService.listCodeCombos("SAL", "PROJ_PAYMENT_TYPE");
//        List<SysUdcComboVO> businessTypeUdcList = sysUdcService.listCodeCombos("SAL", "BUSINESS_TYPE");
//        List<SysUdcComboVO> channelUdcList = sysUdcService.listCodeCombos("SAL", "CHANNEL");
//        List<SysUdcComboVO> constrQuaUdcList = sysUdcService.listCodeCombos("SAL", "CONSTR_QUA");
//        List<SysUdcComboVO> custPropUdcList = sysUdcService.listCodeCombos("CRM", "CUST_PROP");
//        List<SysUdcComboVO> financialUdcList = sysUdcService.listCodeCombos("CRM", "FINANCIAL_ATTRIBUTE");
//
//        // excel 数据重复性校验
//        Map<String, List<SalProjImportSaveVO>> projMaps = parseData.stream().collect(Collectors.groupingBy(SalProjImportSaveVO::getProjName));
//        StringBuilder projNameMag = new StringBuilder();
//        for (String proj:projMaps.keySet()) {
//            List<SalProjImportSaveVO> salProjImportSaveVOS = projMaps.get(proj);
//            if (salProjImportSaveVOS.size() > 1){
//                projNameMag.append("【"+proj+"】,");
//            }
//        }
//        if (projNameMag.length() > 0){
//            throw new BusinessException("EXCEL导入的多条数据,项目名称为:"+projNameMag+"数据重复");
//        }
//        // 校验数据处理
//        // 1.项目数据处理
//        List<String> projNames = parseData.stream().map(SalProjImportSaveVO::getProjName).filter(Objects::nonNull).distinct()
//                .collect(Collectors.toList());
//        List<SalProjDO> byProjNameIn = salProjRepo.findByProjNameIn(projNames);
//        // 2.公司
//        List<String> ouCodes = parseData.stream().map(SalProjImportSaveVO::getOuCode).filter(Objects::nonNull).distinct()
//                .collect(Collectors.toList());
//        List<OrgOuRpcDTO> ouDtoList = rmiOrgOuService.findOuDtoList(null, ouCodes);
//        // 3.组织
//        List<String> buCodes = parseData.stream().map(SalProjImportSaveVO::getBuCode).filter(Objects::nonNull).distinct()
//                .collect(Collectors.toList());
//        List<OrgBuRpcDTO> buDtoList = rmiOrgBuService.findBuDtoList(null, buCodes);
//        // 4.客户
//        List<String> custCodes = parseData.stream().map(SalProjImportSaveVO::getCustCode).filter(Objects::nonNull).distinct()
//                .collect(Collectors.toList());
//        List<CrmCustSimpleVO> custByCodes = crmCustRepoProc.getCustByCodes(custCodes);
//        List<CrmScustPageRespVO> scustByCodes = crmScustRepoProc.getScustByCodes(custCodes);
//        parseData.forEach(proj -> {
//         // 生产发号器
//            String projNo = nextNumberService.generateCode("yst-sale","SAL_PROJ_NO", new ArrayList<>());
//            proj.setProjNo(projNo);
//         // 必填校验
//            Assert.isFalse(StringUtils.isEmpty(proj.getProjName()), "excel中存在数据项目名称为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getBusiType()), "项目名称为" + proj.getProjName() + "的数据业务类型为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getChannelType()), "项目名称为" + proj.getProjName() + "的数据渠道来源为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getOuCode()), "项目名称为" + proj.getProjName() + "的数据公司编码为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getBuCode()), "项目名称为" + proj.getProjName() + "的数据组织编码为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getRegion()), "项目名称为" + proj.getProjName() + "的数据区域为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getCustCode()), "项目名称为" + proj.getProjName() + "的数据客户编码为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getCustSource()), "项目名称为" + proj.getProjName() + "的数据客户来源为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getCustAddress()), "项目名称为" + proj.getProjName() + "的数据客户地址为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getCustLevel()), "项目名称为" + proj.getProjName() + "的数据客户等级为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getFinProp()), "项目名称为" + proj.getProjName() + "的数据财务属性为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getCustType()), "项目名称为" + proj.getProjName() + "的数据客户类型为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getIntentTime()), "项目名称为" + proj.getProjName() + "的数据意向时间为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getCustProp()), "项目名称为" + proj.getProjName() + "的数据客户性质为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getIdType()), "项目名称为" + proj.getProjName() + "的数据证件类型为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getIdNo()), "项目名称为" + proj.getProjName() + "的数据证件号码为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getIdExpireDate()), "项目名称为" + proj.getProjName() + "的数据证件失效日期为空");
////            Assert.isFalse(StringUtils.isEmpty(proj.getProjName()), "合同名称为" + proj.getProjName() + "的数据客户名称为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getProjType()), "项目名称为" + proj.getProjName() + "的数据项目类型为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getProjAddress()), "项目名称为" + proj.getProjName() + "的数据项目地址为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getCustPic()), "项目名称为" + proj.getProjName() + "的数据客户联系人为空");
//            Assert.isFalse(StringUtils.isEmpty(proj.getCustPicTel()), "项目名称为" + proj.getProjName() + "的数据客户联系人电话为空");
//            // 相关数据校验
//            // 1.项目信息
//            Optional<SalProjDO> salProjDO = byProjNameIn.stream().filter(proj1 -> proj1.getProjName().equals(proj.getProjName()))
//                    .findFirst();
//            if (salProjDO.isPresent()){
//                throw new BusinessException("项目名称为" + proj.getProjName() + "的销售项目已经在我方系统存在,请到本系统查看.");
//            }
//            // 2.公司信息
//            OrgOuRpcDTO orgOuRpcDTO = ouDtoList.stream().filter(ou -> ou.getOuCode().equals(proj.getOuCode()))
//                    .findFirst().orElseThrow(
//                            new BusinessException("项目名称为" + proj.getProjName() + "的公司在我方系统不存在,请检查")
//                    );
//            proj.setOuName(orgOuRpcDTO.getOuName());
//            proj.setOuId(orgOuRpcDTO.getId());
//            proj.setOuCode(orgOuRpcDTO.getOuCode());
//            // 3.组织信息
//            OrgBuRpcDTO orgBuRpcDTO = buDtoList.stream().filter(bu -> bu.getBuCode().equals(proj.getBuCode()))
//                    .findFirst().orElseThrow(
//                            new BusinessException("项目名称为" + proj.getProjName() + "的组织已经在我方系统不存在,请检查")
//                    );
//            proj.setBuId(orgBuRpcDTO.getId());
//            proj.setBuCode(orgBuRpcDTO.getBuCode());
//            proj.setBuName(orgBuRpcDTO.getBuName());
//            // 4.客户信息
//            if (proj.getCustType2().equals(UdcEnum.SAL_QT_TYPE_B.getValueCodeName())){
//                CrmCustSimpleVO crmCustSimpleVO = custByCodes.stream().filter(cust -> cust.getCustCode().equals(proj.getCustCode()))
//                        .findFirst().orElseThrow(
//                                new BusinessException("项目名称为" + proj.getProjName() + "的客户在我方系统正式客户表不存在,请检查")
//                        );
//                proj.setCustName(crmCustSimpleVO.getCustName());
//                proj.setCustId(crmCustSimpleVO.getId());
//                proj.setCustType2(UdcEnum.SAL_QT_TYPE_B.getValueCode());
//            }else{
//                CrmScustPageRespVO crmScustPageRespVO = scustByCodes.stream().filter(sCust -> sCust.getCustCode().equals(proj.getCustCode()))
//                        .findFirst().orElseThrow(
//                                new BusinessException("项目名称为" + proj.getProjName() + "的客户在我方系统潜在客户表不存在,请检查")
//                        );
//                proj.setCustId(crmScustPageRespVO.getId());
//                proj.setCustName(crmScustPageRespVO.getCustName());
//                proj.setCustType2(UdcEnum.SAL_QT_TYPE_A.getValueCode());
//            }
//            // Udc 补充
//            if(!ObjectUtils.isEmpty(proj.getRegion())){
//                SysUdcComboVO regionUdcVO = regionUdcList.stream().filter(re -> re.getValDesc().equals(proj.getRegion()))
//                        .findFirst().orElseThrow(
//                                new BusinessException("项目名称为" + proj.getProjName() + "的区域填写不正确,请检查")
//                        );
//                proj.setRegion(regionUdcVO.getUdcVal());
//            }
//            if (!ObjectUtils.isEmpty(proj.getCustType())){
//                SysUdcComboVO udcComboVO = custTypeUdcList.stream().filter(cust -> cust.getValDesc().equals(proj.getCustType()))
//                        .findFirst().orElseThrow(
//                                new BusinessException("项目名称为" + proj.getProjName() + "的客户类型填写不正确,请检查")
//                        );
//                proj.setCustType(udcComboVO.getUdcVal());
//            }
//            if(!ObjectUtils.isEmpty(proj.getCustSource())){
//                SysUdcComboVO udcComboVO1 = custSourceTypeUdcList.stream().filter(custSource -> custSource.getValDesc().equals(proj.getCustSource()))
//                        .findFirst().orElseThrow(
//                                new BusinessException("项目名称为" + proj.getProjName() + "的客户来源填写不正确,请检查")
//                        );
//                proj.setCustSource(udcComboVO1.getUdcVal());
//            }
//            if(!ObjectUtils.isEmpty(proj.getProjType())){
//                SysUdcComboVO sysUdcComboVO1 = projTypeUdcList.stream().filter(projType -> projType.getValDesc().equals(proj.getProjType()))
//                        .findFirst().orElseThrow(
//                                new BusinessException("项目名称为" + proj.getProjName() + "的项目类型填写不正确,请检查")
//                        );
//                proj.setProjType(sysUdcComboVO1.getUdcVal());
//            }
//            if(!ObjectUtils.isEmpty(proj.getProjPayMethod())){
//                SysUdcComboVO sysUdcComboVO2 = projPaymentType.stream().filter(projPay -> projPay.getValDesc().equals(proj.getProjPayMethod()))
//                        .findFirst().orElseThrow(
//                                new BusinessException("项目名称为" + proj.getProjName() + "的项目付款方式填写不正确,请检查")
//                        );
//                proj.setProjPayMethod(sysUdcComboVO2.getUdcVal());
//            }
//            if(!ObjectUtils.isEmpty(proj.getBusiType())){
//                SysUdcComboVO sysUdcComboVO3 = businessTypeUdcList.stream().filter(bus -> bus.getValDesc().equals(proj.getBusiType()))
//                        .findFirst().orElseThrow(
//                                new BusinessException("项目名称为" + proj.getProjName() + "的业务类型填写不正确,请检查")
//                        );
//                proj.setBusiType(sysUdcComboVO3.getUdcVal());
//            }
//            if(!ObjectUtils.isEmpty(proj.getChannelType())){
//                SysUdcComboVO sysUdcComboVO4 = channelUdcList.stream().filter(chan -> chan.getValDesc().equals(proj.getChannelType()))
//                        .findFirst().orElseThrow(
//                                new BusinessException("项目名称为" + proj.getProjName() + "的渠道来源填写不正确,请检查")
//                        );
//                proj.setChannelType(sysUdcComboVO4.getUdcVal());
//            }
//            if(!ObjectUtils.isEmpty(proj.getConstructRequire())){
//                SysUdcComboVO sysUdcComboVO = constrQuaUdcList.stream().filter(constr -> constr.getValDesc().equals(proj.getConstructRequire()))
//                        .findFirst().orElseThrow(
//                                new BusinessException("项目名称为:" + proj.getProjName() + "施工资历要求填写不正确,请检查")
//                        );
//                proj.setConstructRequire(sysUdcComboVO.getUdcVal());
//            }
//            if(!ObjectUtils.isEmpty(proj.getCustProp())){
//                SysUdcComboVO sysUdcComboVO5 = custPropUdcList.stream().filter(cust -> cust.getValDesc().equals(proj.getCustProp()))
//                        .findFirst().orElseThrow(
//                                new BusinessException("项目名称为:" + proj.getProjName() + "客户性质填写不正确,请检查")
//                        );
//                proj.setCustProp(sysUdcComboVO5.getUdcVal());
//            }
//            if (!ObjectUtils.isEmpty(proj.getFinProp())){
//                SysUdcComboVO sysUdcComboVO6 = financialUdcList.stream().filter(financial -> financial.getValDesc().equals(proj.getFinProp()))
//                        .findFirst().orElseThrow(
//                                new BusinessException("项目名称为:" + proj.getProjName() + "财务属性填写不正确,请检查")
//                        );
//                proj.setFinProp(sysUdcComboVO6.getUdcVal());
//            }
//        });

    }
    /**
     * 拼接分页查询条件
     */
    private Predicate buildPageSearchCondition(SalProjPagingParam pageParam) {
        Predicate predicate = qSalProjDO.isNotNull();
        if (Objects.nonNull(pageParam)) {
            if (Objects.nonNull(pageParam.getOuId())) {
                predicate = ExpressionUtils.and(predicate, qSalProjDO.ouId.eq(pageParam.getOuId()));
            }
            if (StrUtil.isNotBlank(pageParam.getProjName())) {
                predicate = ExpressionUtils.and(predicate, qSalProjDO.projName.like("%" + pageParam.getProjName().trim() + "%"));
            }
            if (StrUtil.isNotBlank(pageParam.getRegion())) {
                predicate = ExpressionUtils.and(predicate, qSalProjDO.region.eq(pageParam.getRegion()));
            }
            if (Objects.nonNull(pageParam.getCustId())) {
                predicate = ExpressionUtils.and(predicate, qSalProjDO.custId.eq(pageParam.getCustId()));
            }
            if (StrUtil.isNotBlank(pageParam.getCustName())) {
                predicate = ExpressionUtils.and(predicate, qSalProjDO.custName.like("%" + pageParam.getCustName().trim() + "%"));
            }
            if (StrUtil.isNotBlank(pageParam.getCustType2())){
                predicate = ExpressionUtils.and(predicate, qSalProjDO.custType2.eq(pageParam.getCustType2()));
            }
            if (StrUtil.isNotBlank(pageParam.getProjNo())){
                predicate = ExpressionUtils.and(predicate, qSalProjDO.projNo.like(pageParam.getProjNo()+"%"));
            }
            if (StrUtil.isNotBlank(pageParam.getCustCode())){
                predicate = ExpressionUtils.and(predicate, qSalProjDO.custCode.eq(pageParam.getCustCode()));
            }
        }
//        // 添加权限信息
        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qSalProjDO.getMetadata()));
        return predicate;
    }


}
