package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
//import com.elitesland.yst.production.order.service.SalSoReturnRpcService;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderBackToOmsServicei;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.dto.save.BipOrderBackRpcDto;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepo;
import com.elitesland.yst.production.sale.repo.shop.BipOrderBackRepoProc;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import com.elitesland.yst.production.sale.repo.shop.BipSendOrderErrLogRepo;
import com.elitesland.yst.production.sale.service.BipOrderBackRpcService;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.boot.exception.BusinessException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/10/07/13:02
 * @Description:
 */
@Service
@Slf4j
@RestController
@RequestMapping(BipOrderBackRpcService.URI)
public class BipOrderBackRpcServiceImpl implements BipOrderBackRpcService {

    @Autowired
    private BipOrderBackRepo bipOrderBackRepo;
    @Autowired
    private BipOrderBackRepoProc bipOrderBackRepoProc;

    @Autowired
    private BipOrderBackServiceImpl bipOrderBackService;
    @Autowired
    private BipOrderRepo bipOrderRepo;

//    @Autowired
//    private SalSoReturnRpcService salSoReturnRpcService;

    @Autowired
    private BipSendOrderErrLogRepo bipSendOrderErrLogRepo;

    @Autowired
    private BipOrderBackToOmsServicei bipOrderBackToOmsServicei;


  //  @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult updateOrderBackStatus(List<BipOrderBackRpcDto> bipOrderBackRpcDtos){
        log.info("调用通过或者驳回审批的参数:----"+JSON.toJSONString(bipOrderBackRpcDtos));
   //     JSONArray array = new JSONArray();
        List<BipOrderBackDO>  bipOrderBackDOS=new ArrayList<>();
        List<String> docNos = new ArrayList<>();
        for (BipOrderBackRpcDto bipOrderBackRpcDto:bipOrderBackRpcDtos){
            JSONObject jsonObject = new JSONObject();
            if(bipOrderBackRpcDto.getDocNo()==null){
                throw new BusinessException("主表ID不能为空!");
            }
            if(StringUtils.isBlank(bipOrderBackRpcDto.getStatus())){
                throw new BusinessException("状态不能为空!---");
            }
            log.info("查询退货单信息:----");
            BipOrderBackDO bipOrderBackDO=bipOrderBackRepoProc.findOrderBackByDocNo(bipOrderBackRpcDto.getDocNo());
            log.info("退货单的信息"+JSON.toJSONString(bipOrderBackDO));
            bipOrderBackDO.setStatus(bipOrderBackRpcDto.getStatus());
            log.info("设置退货单状态:----");

            if(bipOrderBackDO.getOrderId()==null){
                throw new BusinessException("退货单未关联订单");
            }
            log.info("查询订单信息:----");
            BipOrderDO bipOrderDo=bipOrderRepo.findById(bipOrderBackDO.getOrderId()).get();
            log.info("订单信息:----"+JSON.toJSONString(bipOrderDo));
            //订单中心传过来的WP(退款中)的话这边直接支付
            if("WP".equals(bipOrderBackRpcDto.getStatus())){
                log.info("退款中状态:----");
                if(UdcEnum.SO_BACK_TYPE_10.getValueCode().equals(bipOrderBackDO.getBackType())
                        || UdcEnum.SO_BACK_TYPE_20.getValueCode().equals(bipOrderBackDO.getBackType()) || UdcEnum.SO_BACK_TYPE_30.equals(bipOrderBackDO.getBackType())){
                    log.info("销售订单退货类型为10或者20");
                    if("online".equals(bipOrderDo.getPayMethodName())){
                        log.info("是在线订单");
                    //    CPCN5021Resp resp=bipOrderBackService.cpcn5011Request(bipOrderBackDO.getId());
            //            log.info("调用中金退款返回信息--"+ JSON.toJSONString(resp));
                   //     if(resp==null){
                   //         throw new BusinessException("调用中金退款失败");
                   //     }else {
                            docNos.add(bipOrderBackRpcDto.getDocNo());
                            //退货单流水号
                  //          bipOrderBackDO.setTxsn(resp.getTxSN());
                            //修改状态已退款
                            bipOrderBackDO.setStatus(UdcEnum.SAL_RSO_STATUS_DONE.getValueCode());
                 //       }
                    }
                }
            }
            //退货单单号
      //      jsonObject.put("docNo",bipOrderBackRpcDto.getDocNo());
     //       jsonObject.putOnce("status",bipOrderBackDO.getStatus());
      //      array.add(jsonObject);
            bipOrderBackDOS.add(bipOrderBackDO);
//            if("WK".equals(bipOrderBackRpcDto.getStatus())){
//                if(UdcEnum.SO_BACK_TYPE_10.getValueCode().equals(bipOrderBackDO.getBackType())
//                        || UdcEnum.SO_BACK_TYPE_20.getValueCode().equals(bipOrderBackDO.getBackType())){
//                    if("online".equals(bipOrderDo.getPayMethodName())){
//                        CPCN5021Resp resp=bipOrderBackService.cpcn5011Request(bipOrderBackDO.getId());
//                        log.info("调用中金退款返回信息--"+ JSON.toJSONString(resp));
//                        if(resp==null){
//                            throw new BusinessException("调用中金退款失败");
//                        }
//                    }
//                }
//            }
        }
        log.info("退货单数据:---"+JSON.toJSONString(bipOrderBackDOS));
        bipOrderBackRepo.saveAll(bipOrderBackDOS);



        //生成退款单
        if(null != docNos && !docNos.isEmpty()){
            //退款成功的单号要同步到订单中心
//            log.info("同意退款传给订单中心的参数:"+ docNos );
//            try {
//                ApiResult<Object> res = salSoReturnRpcService.allowReturnMoney(docNos);
//                log.info("退货单同意退款返回:"+JSON.toJSONString(res));
//                if(res.getCode() != 200){
//                    QBipSendOrderErrLogDO qBipSendOrderErrLogDO = QBipSendOrderErrLogDO.bipSendOrderErrLogDO;
//                    BooleanExpression ex = qBipSendOrderErrLogDO.deleteFlag.eq(0).and(qBipSendOrderErrLogDO.type.eq(UdcEnum.SAL_SEND_PARAM_ERR_BACK_ORDER.getValueCode())).and(qBipSendOrderErrLogDO.param.eq(JSONUtil.toJsonStr(docNos)));
//                    Iterable<BipSendOrderErrLogDO> iterable = bipSendOrderErrLogRepo.findAll(ex);
//                    if(IterUtil.isEmpty(iterable)){
//                        BipSendOrderErrLogDO bipSendOrderErrLogDO = new BipSendOrderErrLogDO();
//                        bipSendOrderErrLogDO.setParam(JSONUtil.toJsonStr(docNos));
//                        bipSendOrderErrLogDO.setCount(0);
//                        bipSendOrderErrLogDO.setType(UdcEnum.SAL_SEND_PARAM_ERR_BACK_ORDER.getValueCode());
//                        bipSendOrderErrLogRepo.save(bipSendOrderErrLogDO);
//                    }
//                }
//            }catch (Exception e){
//                //调用订单  如果失败就保存参数 定时进行调用
//                //判断存不存在
//                QBipSendOrderErrLogDO qBipSendOrderErrLogDO = QBipSendOrderErrLogDO.bipSendOrderErrLogDO;
//                BooleanExpression ex = qBipSendOrderErrLogDO.deleteFlag.eq(0).and(qBipSendOrderErrLogDO.type.eq(UdcEnum.SAL_SEND_PARAM_ERR_BACK_ORDER.getValueCode())).and(qBipSendOrderErrLogDO.param.eq(JSONUtil.toJsonStr(docNos)));
//                Iterable<BipSendOrderErrLogDO> iterable = bipSendOrderErrLogRepo.findAll(ex);
//                if(IterUtil.isEmpty(iterable)){
//                    BipSendOrderErrLogDO bipSendOrderErrLogDO = new BipSendOrderErrLogDO();
//                    bipSendOrderErrLogDO.setParam(JSONUtil.toJsonStr(docNos));
//                    bipSendOrderErrLogDO.setCount(0);
//                    bipSendOrderErrLogDO.setType(UdcEnum.SAL_SEND_PARAM_ERR_BACK_ORDER.getValueCode());
//                    bipSendOrderErrLogRepo.save(bipSendOrderErrLogDO);
//                }
//                log.info("退货单同意退款调用异常:"+e.getMessage());
//                throw e;
//            }
//            docNos.stream().forEach(docNo ->{
//                log.info("生成退款单单号:-------"+docNo);
//                bipOrderBackToOmsServicei.createSalReceiptService(docNo);
//            });
        }

        return ApiResult.ok();
    }


}
