package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.IterUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.task.delay.common.DelayTaskSender;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.elitesland.yst.production.order.param.SalDoSignUserInfoDto;
import com.elitesland.yst.production.order.param.SalSoSignReqDto;
import com.elitesland.yst.production.sale.api.service.PriSalePriceService;
import com.elitesland.yst.production.sale.api.service.shop.*;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderDParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipOrderParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipBuyNowSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipCartSettleParmVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipOrderUserParmVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.*;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipAppOrderPayVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipAppOrderSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderDSaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.common.model.UserDTO;
import com.elitesland.yst.production.sale.convert.shop.BipItemConvert;
import com.elitesland.yst.production.sale.convert.shop.BipOrderConvert;
import com.elitesland.yst.production.sale.convert.shop.BipOrderDConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.ext.cpcn.resp.CPCN5011Resp;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.CrmCustRepoProc;
import com.elitesland.yst.production.sale.repo.shop.*;
import com.elitesland.yst.production.sale.rmi.ystorder.RmiDoRpcService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgEmpService;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgOuService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitesland.yst.production.sale.task.delay.BipOrderCancleTask;
import com.elitesland.yst.production.support.provider.org.dto.OrgEmpRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgOuRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgBankAccRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgEmpRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgOuRpcDtoParam;
import com.google.common.collect.Lists;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.*;
import java.util.stream.Collectors;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/07/16:06
 * @Description:
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class BipOrderServiceimpl extends BaseServiceImpl implements BipOrderService {

    @Autowired
    private BipOrderRepo bipOrderRepo;

    @Autowired
    private BipOrderDRepo bipOrderDRepo;

    @Autowired
    private BipOrderBackDRepo bipOrderBackDRepo;

    @Autowired
    private BipCartServiceImpl bipCartService;

    @Autowired
    private BipOrdeDServiceimpl bipOrderDService;
    @Autowired
    private BipAddressServiceImpl bipAddressService;

    @Autowired
    private BipCustUserBindRepoProc bipCustUserBindRepoProc;
    @Autowired
    private CrmCustRepo crmCustRepo;
    @Autowired
    private BipItemSkuRepo bipItemSkuRepo;
    @Autowired
    private BipCouponItemRepo bipCouponItemRepo;

    @Autowired
    private BipOrderRepoProc bipOrderRepoProc;

    @Autowired
    private BipCouponRepo bipCouponRepo;

    @Autowired
    private BipOrderDRepoProc bipOrderDRepoProc;

    @Autowired
    private BipOrderBackRepo bipOrderBackRepo;

    @Autowired
    private final MktDiscountGiftRepoProc mktDiscountGiftRepoProc;

    @Autowired
    private RmiOrgOuService rmiOrgOuService;
//    @Autowired
//    private RmiOrderSalSoService rmiOrderSalSoService;
    @Autowired
    private BipItemService bipItemService;
//    @Autowired
//    private RmiItemService rmiItemService;

    private final RmiSysNextNumberService rmiSysNextNumberService;

    private final QBipOrderDO qBipOrderDo=QBipOrderDO.bipOrderDO;

    private final PriSalePriceService salePriceService;

    private final RmiOrgAddrService rmiOrgAddrService;

    private final BipItemAppService bipItemAppService;

    @Autowired
    private BipCompanyManageService bipCompanyManageService;

    @Autowired
    private BipOrderToOmsServiceimpl bipOrderToOmsServiceimpl;
    @Autowired
    private BipCartRepoProc bipCartRepoProc;
    @Autowired
    private RmiOrgEmpService rmiOrgEmpService;
    @Autowired
    private CrmCustRepoProc crmCustRepoProc;
    @Autowired
    private RmiDoRpcService rmiDoRpcService;

    @Autowired
    private BipCouponCustService bipCouponCustService;
    @Autowired
    private final DelayTaskSender delayTaskSender;

    @Autowired
    private MktGiftRepo mktGiftRepo;

    private final QBipOrderDO qBipOrderDO=QBipOrderDO.bipOrderDO;

    private final MktGiftRepoProc mktGiftRepoProc;

//    @Value("${wx.sale.shop.appid}")
    private String appid;
//    @Value("${wx.sale.shop.secret}")
    private String secret;

//    @Value("${wx.sale.shop.grantType}")
    private String grantType;

//    @Value("${cpcn.sale.payMentNoticrl}")
    private String payMentNoticrl;

    private static final HashMap<String,String> statusMap = new HashMap<>(8);

    private static final HashMap<String,String> payStatusMap = new HashMap<>(8);


    static {
        statusMap.put("unpaid","待付款");
        statusMap.put("shipping","待收货");
        statusMap.put("signed","已签收");
        statusMap.put("cancelled","已取消");

        payStatusMap.put("ps","支付成功");
        payStatusMap.put("pf","支付失败");
        payStatusMap.put("pc","支付取消");

    }



    /**
     * 创建订单
     * @param bipAppOrderSaveVO
     */
    @Transactional(rollbackFor = Exception.class)
    public CPCN5011Resp createOrder(BipAppOrderSaveVO bipAppOrderSaveVO,Map hashMap){
        LocalDateTime nowDateTime = LocalDateTime.now();
        log.info("订单生成---"+JSON.toJSONString(bipAppOrderSaveVO));

        CurrentUserDTO currentUserDTO=UserService.currentUser();

        //获取当前登录人信息和客户信息
        BipCustUserBindDO bipCustUserBindDO=null;

        if(Objects.nonNull(currentUserDTO.getUserId())){
            bipCustUserBindDO=bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        }else{
            throw new BusinessException("请先登录!");
        }

        Long custId = bipCustUserBindDO.getCustId();
        if(custId==null){
            throw new BusinessException("请先绑定公司!");
        }
        BipOrderDO bipOrderDo=new BipOrderDO();
        bipOrderDo.setOuId(bipAppOrderSaveVO.getOuId());
        bipOrderDo.setSecOuId(bipAppOrderSaveVO.getOuId());
        fillOrderCustInfo(bipCustUserBindDO,bipOrderDo);
        bipOrderDo.setRemark(bipAppOrderSaveVO.getRemark());
        bipOrderRepo.saveAndFlush(bipOrderDo);

        List<BipOrderDDO> bipOrderDDOS =new ArrayList<>();
        List<Long> cartIds = bipAppOrderSaveVO.getCartIds();

        //从购物车而来
        if(Objects.nonNull(cartIds)){
            BipCartSettleParmVO bipCartSettleParmVO=new BipCartSettleParmVO();
            bipCartSettleParmVO.setCartIds(cartIds);
            bipCartSettleParmVO.setAddressId(bipAppOrderSaveVO.getAddressId());
            bipCartSettleParmVO.setCouponId(bipAppOrderSaveVO.getCouponId());
            bipCartSettleParmVO.setOuId(bipAppOrderSaveVO.getOuId());
            BipCartVo bipCartVo=bipCartService.findMyCartEable(bipCartSettleParmVO);
            bipOrderDo.setCouponId(bipCartVo.getCouponId());

            log.info("购物车生单优惠券id--"+bipCartVo.getCouponId());
            log.info("订单生成购物车信息---"+JSON.toJSONString(bipCartVo));

            List<BipCartItemRespVO> bipCartItemRespVOs=bipCartVo.getItemList();
            //放入赠品code
            if(bipAppOrderSaveVO.getGiftIdList()!=null && bipAppOrderSaveVO.getGiftIdList().size()>0){
                bipCartItemRespVOs.forEach(item -> {
                    bipAppOrderSaveVO.getGiftIdList().forEach(gift -> {
                        if(gift.get(item.getSkuId())!=null && gift.get(item.getSkuId()).size()>0){
                            item.setGiftCodes(String.join(",",gift.get(item.getSkuId())));
                        }
                    });
                });
            }
            bipOrderDDOS = bipOrderDService.createOrder(bipCartItemRespVOs);

            bipCartRepoProc.deleteCartByIds(cartIds);


        }else if(Objects.nonNull(bipAppOrderSaveVO.getItemId())){
            if(bipAppOrderSaveVO.getItemNum()<=0||bipAppOrderSaveVO.getItemNum()==null){
                throw new BusinessException("商品数量必须大于0!");
            }

            //立即购买
            BipBuyNowSettleParmVO bipBuyNowSettleParmVO=new BipBuyNowSettleParmVO();
            bipBuyNowSettleParmVO.setItemId(bipAppOrderSaveVO.getItemId());
            bipBuyNowSettleParmVO.setSkuId(bipAppOrderSaveVO.getSkuId());
            bipBuyNowSettleParmVO.setItemNum(bipAppOrderSaveVO.getItemNum());
            bipBuyNowSettleParmVO.setFirstItemFlag(bipAppOrderSaveVO.getFirstItemFlag());
            bipBuyNowSettleParmVO.setCouponId(bipAppOrderSaveVO.getCouponId());
            bipBuyNowSettleParmVO.setOuId(bipAppOrderSaveVO.getOuId());
            bipBuyNowSettleParmVO.setAddressId(bipAppOrderSaveVO.getAddressId());
            log.info("立即购买参数---"+JSON.toJSONString(bipBuyNowSettleParmVO));
            BipCartVo bipCartVo= bipCartService.findBuyNowOrderPer(bipBuyNowSettleParmVO);

            log.info("立即购买生单优惠券id--"+bipCartVo.getCouponId());
            bipOrderDo.setCouponId(bipCartVo.getCouponId());

            log.info("订单生成立即购买信息---"+JSON.toJSONString(bipCartVo));
            List<BipCartItemRespVO> bipCartItemRespVOs=bipCartVo.getItemList();
            //放入赠品code
            if(bipAppOrderSaveVO.getGiftIdList()!=null && bipAppOrderSaveVO.getGiftIdList().size()>0){
                bipCartItemRespVOs.forEach(item -> {
                    bipAppOrderSaveVO.getGiftIdList().forEach(gift -> {
                        if(gift.get(item.getSkuId())!=null && gift.get(item.getSkuId()).size()>0){
                            item.setGiftCodes(String.join(",",gift.get(item.getSkuId())));
                        }
                    });
                });
            }
            bipOrderDDOS =bipOrderDService.createOrder(bipCartItemRespVOs);

        }


        String docNo = rmiSysNextNumberService.generateCode("yst-sale","ORDER_DOC_NO", new ArrayList<>());
        bipOrderDo.setDocNo(docNo);
        bipOrderDo.setPayMethodName(bipAppOrderSaveVO.getPayWay());
        bipOrderDo.setStatus("unpaid");
        bipOrderDo.setOrderTime(LocalDateTime.now());

        bipOrderDDOS.stream().forEach(bipOrderDDo -> {
            bipOrderDDo.setOuId(bipOrderDo.getOuId());
            bipOrderDDo.setOuCode(bipOrderDo.getOuCode());
            bipOrderDo.setOuName(bipOrderDo.getOuName());

            bipOrderDDo.setOrderId(bipOrderDo.getId());
            bipOrderDDo.setOrderDocNo(bipOrderDo.getDocNo());

            bipOrderDDo.setAllowBackNum(bipOrderDDo.getBuyQty());

        });

        bulidOrderAmtInfo(bipOrderDo, bipOrderDDOS);

        if(bipOrderDo.getFareAmt().compareTo(BigDecimal.ZERO)>0){
            bipOrderDo.setFreeFare(false);
        }

        buildCouponInfo(bipOrderDo,bipOrderDDOS);


        log.info("订单生成子单信息---"+JSON.toJSONString(bipOrderDDOS));


        bipOrderDRepo.saveAll(bipOrderDDOS);

        bipOrderDo.setAdressId(bipAppOrderSaveVO.getAddressId());
        //地址信息要保存到订单里面 避免通过ID查支撑域那边数据，那边数据调整这边就查不到地址信息
        if (null != bipAppOrderSaveVO.getAddressId()) {
            BipAddressVO bipAddressVO = bipAddressService.findById(bipAppOrderSaveVO.getAddressId());
            bipOrderDo.setCity(bipAddressVO.getCity());
            bipOrderDo.setCityName(bipAddressVO.getCityName());
            bipOrderDo.setCounty(bipAddressVO.getCounty());
            bipOrderDo.setCountyName(bipAddressVO.getCountyName());
            bipOrderDo.setContPerson(bipAddressVO.getContPerson());
            if(null != bipAddressVO.getDefaultFlag()){
                bipOrderDo.setDefaultFlag(bipAddressVO.getDefaultFlag());
            }
            bipOrderDo.setDetailAddr(bipAddressVO.getDetailAddr());
            bipOrderDo.setMobile(bipAddressVO.getMobile());
            bipOrderDo.setProvince(bipAddressVO.getProvince());
            bipOrderDo.setProvinceName(bipAddressVO.getProvinceName());
        }
        if(bipOrderDo.getPayMethodName().equals("offline")){
            bipOrderDo.setPayDoneAmt(BigDecimal.ZERO);
            bipOrderDo.setPayTime(null);
        }


        bipOrderRepo.save(bipOrderDo);

        hashMap.put("id",bipOrderDo.getId());
        log.info("订单生成主单信息---"+JSON.toJSONString(bipOrderDo));

        CPCN5011Resp resp=null;
        if("online".equals(bipAppOrderSaveVO.getPayWay())){
            nowDateTime = nowDateTime.plusMinutes(10);
            if(bipAppOrderSaveVO.getCode()==null){
                throw new BusinessException("线上支付code不能为空");
            }
            if(bipOrderDo.getPayAmt().compareTo(BigDecimal.ZERO) <= 0){
                throw new BusinessException("支付金额必须大于0!");
            }
//            resp=cpcn5011(bipOrderDo,bipAppOrderSaveVO.getCode());
//            if(resp==null){
//                throw new BusinessException("支付异常!");
//            }

        }else {
            nowDateTime = nowDateTime.plusHours(48);
        }
        if("offline".equals(bipAppOrderSaveVO.getPayWay())){
            if(bipOrderDo.getCustId()==null){
                throw new BusinessException("订单客户id为空!");
            }
            //当客户信息上的信贷检查类型为检查，那么每次下单的时候，信贷金额减去下线支付的待付款订单金额总和 再和当前订单比较 如果总和大于
            //订单带总金额（待付款金额）
            //  bipOrderDo.getTotalAmt();
            CrmCustDO crmCustDO = getByCustId(bipOrderDo.getCustId());
            if(null == crmCustDO){
                throw new BusinessException("客户信息不存在!");
            }
            bipOrderToOmsServiceimpl.sendToOms(bipOrderDo.getId());
        }

//        BuildPayOrderSucessInfo(bipOrderDo);

        //延时队列取消订单
        log.info("发起订单取消延时队列");
        delayTaskSender.send(BipOrderCancleTask.TASK_TYPE, String.valueOf(bipOrderDo.getId()), bipOrderDo.getId(), nowDateTime);

        if("online".equals(bipAppOrderSaveVO.getPayWay())){
            String payStatus="ps";
            String status="shipping";
            String txsn="txsn";
            BigDecimal amont=bipOrderDo.getPayAmt();
            amont=amont.divide(BigDecimal.valueOf(100));
            log.info("回调更新订单状态参数：{},{},{},{}",payStatus,status,txsn,amont); // ps,shipping,202111101244021257001697910,0.01

            updateOrderPayStatus(payStatus,docNo,status,txsn, LocalDateTime.now(),amont);
            updateOrderDPayDoneAmt(docNo);
            log.info("订单状态更新成功");
            //更新销量
            log.info("更新销量");
            bipItemAppService.updateItemSalNumAll(docNo);
            log.info("更新销量完成");
            BipOrderDO bipOrderDO=bipOrderRepoProc.findOrderByDocNo(docNo);
            log.info("同步订单信息开始---------------"+bipOrderDO.getDocNo());
            bipOrderToOmsServiceimpl.sendToOms(bipOrderDO.getId());
        }


        return resp;
    }

    /**
     * 历史待付款线下支付订单总应付金额
     * @param custId
     * @return
     */
    public BigDecimal getUnpaidOrderByCustId(Long custId){
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression expression = qBipOrderDO.custId.eq(custId).and(qBipOrderDO.status.eq("unpaid")).and(qBipOrderDO.payMethodName.eq("offline")).and(qBipOrderDO.deleteFlag.eq(0));
        Iterable<BipOrderDO> iterables = bipOrderRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            List<BipOrderDO> list = Lists.newArrayList(iterables);
            return list.stream().map(BipOrderDO :: getPayAmt).reduce(BigDecimal.ZERO,BigDecimal::add);
        }
        return new BigDecimal("0.00");
    }


    /**
     * 客户信息
     * @param custId
     * @return
     */
    public CrmCustDO getByCustId(Long custId){
        QCrmCustDO qCrmCustDO = QCrmCustDO.crmCustDO;
        BooleanExpression expression = qCrmCustDO.id.eq(custId).and(qCrmCustDO.deleteFlag.eq(0));
        Optional<CrmCustDO> optional = crmCustRepo.findOne(expression);
        if(optional.isPresent()){
            return optional.get();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Map saveOrder(BipAppOrderSaveVO bipAppOrderSaveVO){
        Map hashMap=new HashMap();

        //生成订单
        CPCN5011Resp cpcn5011Resp= createOrder(bipAppOrderSaveVO,hashMap);

//        BipOrderDO bipOrderDo=new BipOrderDO();
//        bipOrderDo.setDocNo("0000000000000000001");
//        bipOrderDo.setCustAccountId(0L);
//        CPCN5011Resp resp=cpcn5011(bipOrderDo);
        if(cpcn5011Resp!=null){
            hashMap.put("code",cpcn5011Resp.getQRAuthCode());
        }
        return hashMap;
    };

    /**
        * @Description:构造订单客户信息
        * @Param: [userId, order]
        * @return: void
        * @Author: wangyinghao
        * @Date: 2021/8/11
        */
    private void fillOrderCustInfo(BipCustUserBindDO bipCustUserBindDO, BipOrderDO order){

        Long custId=bipCustUserBindDO.getCustId();
        order.setOuId(bipCustUserBindDO.getOuId());

        Long ouId=bipCustUserBindDO.getOuId();
        List<Long> ouList=new ArrayList<>();
        ouList.add(ouId);
        OrgOuRpcDtoParam orgOuRpcDtoParam=new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(ouList);
        log.info("调用公司接口参数---"+JSON.toJSONString(orgOuRpcDtoParam));

        List<OrgOuRpcDTO> orgOuRpcDTOS=rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);

        if(orgOuRpcDTOS!=null&&!orgOuRpcDTOS.isEmpty()){
            OrgOuRpcDTO orgOuRpcDTO=orgOuRpcDTOS.get(0);
            order.setOuName(orgOuRpcDTO.getOuName());
            order.setOuCode(orgOuRpcDTO.getOuCode());

        }
        OrgEmpRpcDtoParam param = new OrgEmpRpcDtoParam();
        param.setEmpIds(Arrays.asList(bipCustUserBindDO.getAgentEmpId()));
        List<OrgEmpRpcDTO> emp = rmiOrgEmpService.findEmpListByParam(param);
        log.info("调用员工信息:"+JSON.toJSONString(emp));
        emp.stream().filter(emp1 -> emp1.getId().equals(bipCustUserBindDO.getAgentEmpId()))
                .findFirst()
                .ifPresent(oo -> {
                    order.setAgentCode(oo.getBuCode());
                    order.setAgentName(oo.getEmpName());
//                    order.setBuCode(oo.getBuCode());
//                    order.setBuName(oo.getBuName());
                });
        order.setCustId(custId);
        //此处方法有时候返回空 直接查支撑域接口，后期优化可调用此方法本地查询
        List<BipCompanyManageRespVO> bipCompanyManageRespVOS=bipCompanyManageService.findCompanyManageByOuIds(ouList);

        if(bipCompanyManageRespVOS!=null&&!bipCompanyManageRespVOS.isEmpty()){
            BipCompanyManageRespVO bipCompanyManageRespVO=bipCompanyManageRespVOS.get(0);
            order.setBuId(bipCompanyManageRespVO.getBuId());
            order.setBuCode(bipCompanyManageRespVO.getBuCode());
            order.setBuName(bipCompanyManageRespVO.getBuName());
        }


        order.setCustCode(bipCustUserBindDO.getCustCode());
        order.setCustAccountId(bipCustUserBindDO.getUserId());
        order.setCustName(bipCustUserBindDO.getCustName());
        order.setAgentEmpId(bipCustUserBindDO.getAgentEmpId());

    }

    /**
     * 构建订单优惠券信息
     * @param order
     * @param bipOrderDDOS
     */
    public void buildCouponInfo( BipOrderDO order,List<BipOrderDDO> bipOrderDDOS) {
        if (order.getCouponId() != null) {
            List<BipOrderDDO> matchList = match(order, bipOrderDDOS);
            log.info("匹配到的订单信息:"+JSON.toJSONString(matchList));
            Map<Long, List<BipOrderDDO>> map = matchList.stream().collect(Collectors.groupingBy(bipOrderDDO -> bipOrderDDO.getId()));

            if(map==null){
                log.info("优惠券未匹配到订单信息");
                return;
            }
            for (int i = 0; i < bipOrderDDOS.size(); i++) {
                BipOrderDDO bipOrderDDO = bipOrderDDOS.get(i);
                if (map.get(bipOrderDDO.getId()) != null) {
                    BipOrderDDO bipOrderDDOld = map.get(bipOrderDDO.getId()).get(0);
                    bipOrderDDO.setCouponAmt(bipOrderDDOld.getCouponAmt());
                    bipOrderDDO.setPayAmt(bipOrderDDOld.getPayAmt());
                }
            }

            bipCouponCustService.modifyOrderCouponCustUseStatus(order.getCouponId(),UdcEnum.SAL_COUPON_USE_STATUS_USED.getValueCode());
        }

        log.info("未选择优惠券");
        for (int i = 0; i < bipOrderDDOS.size(); i++) {
            BipOrderDDO bipOrderDDO = bipOrderDDOS.get(i);
            BigDecimal couponAmt = bipOrderDDO.getCouponAmt();
            if (couponAmt == null) {
                couponAmt = BigDecimal.ZERO;
            }
            BigDecimal itmeAmt = bipOrderDDO.getItemAmt()==null?BigDecimal.ZERO:bipOrderDDO.getItemAmt();
            BigDecimal fareAmt = bipOrderDDO.getFareAmt()==null?BigDecimal.ZERO:bipOrderDDO.getFareAmt();
            BigDecimal discountAmt = bipOrderDDO.getDiscountAmt()==null?BigDecimal.ZERO:bipOrderDDO.getDiscountAmt();
            BigDecimal payAmt = itmeAmt.add(fareAmt).subtract(discountAmt).subtract(couponAmt);
            BigDecimal num = new BigDecimal(bipOrderDDO.getBuyQty());
  //          BigDecimal buyAmt = (payAmt.subtract(fareAmt)).divide(num,2,RoundingMode.HALF_UP);
            BigDecimal buyAmt = (payAmt.subtract(fareAmt)).divide(num,2,RoundingMode.HALF_UP);
          //  BigDecimal buyAmt = (itmeAmt.subtract(discountAmt.divide(num,RoundingMode.HALF_UP)).subtract(couponAmt.divide(num,RoundingMode.HALF_UP))).divide(num,2,RoundingMode.HALF_UP);
//.divide(BigDecimal.valueOf(100),2,RoundingMode.HALF_UP)
            bipOrderDDO.setPayAmt(payAmt);
            bipOrderDDO.setBuyAmt(buyAmt);
            if(payAmt.compareTo(BigDecimal.ZERO) < 0){
                bipOrderDDO.setPayAmt(BigDecimal.ZERO);
            }
            if(order.getPayMethodName().equals("offline")){
                bipOrderDDO.setPayDoneAmt(BigDecimal.ZERO);
            }
        }
    }


    /**
     * 优惠券匹配到的商品集合
     * @param order
     * @param bipOrderDDOS
     * @return
     */
    public List<BipOrderDDO> match(BipOrderDO order,List<BipOrderDDO> bipOrderDDOS){
        Long couponId=order.getCouponId();
        BipCouponDO bipCouponDO=bipCouponRepo.findById(couponId).get();

        List<BipOrderDDO> matchBipOrderDDOS=new ArrayList<>();
        List<BipCouponItemDO> bipCouponItemDOS=bipCouponItemRepo.findByCouponId(couponId);

        log.info("优惠券的信息:"+JSON.toJSONString(bipCouponItemDOS));

        Set<Long> itemIdSet=bipCouponItemDOS.stream().map(bipCouponItemDO -> { return bipCouponItemDO.getBipItemId();}).collect(Collectors.toSet());

        log.info("优惠券可用商品信息的信息:"+JSON.toJSONString(itemIdSet));

        //该优惠券适合本订单的商品
        List<BipOrderDDO> matchBiprderDDos=bipOrderDDOS.stream().filter(bipOrderDDO -> {
            return itemIdSet.contains(bipOrderDDO.getItemId());
        }).collect(Collectors.toList());

        log.info("匹配到优惠券订单的信息:"+JSON.toJSONString(matchBiprderDDos));

        //

        List<BipOrderDDO> finalBiporderDDos=matchBiprderDDos.stream().filter(bipOrderDDO -> {
            BigDecimal itmeAmt=bipOrderDDO.getItemAmt();
            BigDecimal limitAmt=bipCouponDO.getLimitAmt();

            log.info("itemAmt--"+itmeAmt+"||| limitAmt----"+limitAmt);
            if(itmeAmt.compareTo(limitAmt)>=0){
                return true;
            }
            return false;
        }).collect(Collectors.toList());

        int size=finalBiporderDDos.size();
        if(size>0){
            //修改订单实付金额
            BigDecimal freeAmt=bipCouponDO.getFreeAmt();
            if(freeAmt==null||freeAmt.compareTo(BigDecimal.ZERO)<=0){
                throw new BusinessException("优惠金额必须大于0");
            }

            BigDecimal payAmt=order.getPayAmt();
            if(payAmt==null||payAmt.compareTo(BigDecimal.ZERO)<=0){
                throw new BusinessException("实付金额必须大于0");
            }
            if(freeAmt.compareTo(payAmt)>0){
                throw new BusinessException("优惠券金额不能大于付款金额");
            }
            order.setCouponAmt(freeAmt);
            order.setPayAmt(payAmt.subtract(freeAmt));


            freeAmt.setScale(2,BigDecimal.ROUND_DOWN);
            BigDecimal amt=freeAmt.divide(BigDecimal.valueOf(size));
            BigDecimal balanceAmt=BigDecimal.ZERO;
            for(int i=0;i<size;i++){
                balanceAmt=balanceAmt.add(amt);
                BipOrderDDO bipOrderDDO=finalBiporderDDos.get(i);
                if(i==size){
                    amt=freeAmt.subtract(balanceAmt);
                }
                bipOrderDDO.setCouponAmt(amt);
                log.info("优惠券平摊----"+bipOrderDDO.getCouponAmt());
                bipOrderDDO.setPayAmt(bipOrderDDO.getItemAmt().subtract(amt).subtract(bipOrderDDO.getDiscountAmt()==null?BigDecimal.ZERO:bipOrderDDO.getDiscountAmt()).add(bipOrderDDO.getFareAmt()==null?BigDecimal.ZERO:bipOrderDDO.getFareAmt()));
                matchBipOrderDDOS.add(bipOrderDDO);
            }
        }
        log.info("可用优惠券的商品所在订单的信息:"+JSON.toJSONString(matchBipOrderDDOS));

        return matchBipOrderDDOS;
    }


    /**
        * @Description: 构造订单金额信息
        * @Param: [bipOrderDo, bipOrderDDoList]
        * @return: void
        * @Author: wangyinghao
        * @Date: 2021/8/12
        */
    public void bulidOrderAmtInfo(BipOrderDO bipOrderDo, List<BipOrderDDO> bipOrderDDOList){

        // itemAmt = price * buyQty
        BigDecimal custAmt= bipOrderDDOList.stream().map(bipOrderDDo->{
            if(bipOrderDDo.getItemAmt()==null){
                return BigDecimal.ZERO;
            }else{
                return bipOrderDDo.getItemAmt();
            }
        }).reduce(BigDecimal::add).get();

        BigDecimal couponAmt= bipOrderDDOList.stream().map(bipOrderDDo->{
            if(bipOrderDDo.getCouponAmt()==null){
                return BigDecimal.ZERO;
            }else{
                return bipOrderDDo.getCouponAmt();
            }
        }).reduce(BigDecimal::add).get();

        BigDecimal discountAmt= bipOrderDDOList.stream().map(bipOrderDDo->{
            if(bipOrderDDo.getDiscountAmt()==null){
                return BigDecimal.ZERO;
            }else{
                return bipOrderDDo.getDiscountAmt();
            }
        }).reduce(BigDecimal::add).get();

        BigDecimal fareAmt= bipOrderDDOList.stream().map(bipOrderDDo->{
            if(bipOrderDDo.getFareAmt()==null){
                return BigDecimal.ZERO;
            }else{
                //小于0
                if(bipOrderDDo.getFareAmt().compareTo(BigDecimal.ZERO) < 0){
                    return BigDecimal.ZERO;
                }
                return bipOrderDDo.getFareAmt();
            }
        }).reduce(BigDecimal::add).get();

        bipOrderDo.setCouponAmt(couponAmt);

        bipOrderDo.setDiscountAmt(discountAmt);

        bipOrderDo.setFareAmt(fareAmt);

        BigDecimal payAmt=custAmt.subtract(couponAmt).subtract(discountAmt).add(fareAmt);
        bipOrderDo.setPayAmt(payAmt);

        bipOrderDo.setItemAmt(custAmt);

        BigDecimal totalAmt=custAmt.add(fareAmt);

        bipOrderDo.setFreeFare(fareAmt.compareTo(BigDecimal.ZERO)>0);
        bipOrderDo.setTotalAmt(totalAmt);

    }



    /***
        * @Description: 分页查询
        * @Param: [bipOrderDParmVO]
        * @return: void
        * @Author: wangyinghao
        * @Date: 2021/8/18
        */
    @Override
    public PagingVO<BipOrderRespVO> findPageOrder(BipOrderParmVO bipOrderParmVO){
        Predicate predicate = where(bipOrderParmVO);
        predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qBipOrderDo.getMetadata()));
        Page<BipOrderDO> page= bipOrderRepo.findAll(predicate,bipOrderParmVO.getPageRequest());
        List<BipOrderRespVO> resList=page.getContent().stream().map(BipOrderConvert.INSTANCE::doToResp).collect(Collectors.toList());

        resList.stream().forEach(bipOrderRespVO -> {
            if (bipOrderRespVO.getFareAmt().compareTo(BigDecimal.ZERO) > 0){
                bipOrderRespVO.setFareType("不包邮");
            } else {
                bipOrderRespVO.setFareType("包邮");
            }
            bipOrderRespVO.setStatusName(statusMap.get(bipOrderRespVO.getStatus()));
        });

        return PagingVO.<BipOrderRespVO>builder()
                .total(page.getTotalElements())
                .records(resList)
                .build();
    }

    /**
     * 根据订单id
     * @param orderId 查询 order 聚合信息包含明细信息
     * @return
     */
    @Override
    public BipOrderRespVO findPolymerizeOrder(Long orderId){
        BipOrderDO biporderDo=bipOrderRepo.findById(orderId).get();
        BipOrderRespVO bipOrderRespVO=BipOrderConvert.INSTANCE.doToResp(biporderDo);

        // 设置订单包邮
        if (bipOrderRespVO.getFareAmt().compareTo(BigDecimal.ZERO) > 0){
            bipOrderRespVO.setFareType("不包邮");
        } else {
            bipOrderRespVO.setFareType("包邮");
        }

        // 订单明细
        BipOrderDParmVO bipOrderDParmVO=new BipOrderDParmVO();
        bipOrderDParmVO.setOrderId(orderId);
        List<BipOrderDRespVO> list=bipOrderDService.findOrderD(bipOrderDParmVO);

        for (BipOrderDRespVO orderDVO : list) {
            //填充sku信息
            if (orderDVO.getSkuId() != null) {
                Long skuId = orderDVO.getSkuId();


                BipItemSkuDO bipItemSkuDO = bipItemSkuRepo.findById(skuId).get();
                BipItemSkuRespVO bipItemSkuRespVO = BipItemConvert.INSTANCE.sku2DetailRespVO(bipItemSkuDO);

                orderDVO.setItemSkuRespVO(bipItemSkuRespVO);
            }

            // 赠品信息
            List<BipOrderDRespVO.BriefGiftVO> briefGiftVOS = new ArrayList<>();
            if(null != orderDVO.getGiftCodes() && orderDVO.getGiftCodes().length() > 0){
                List<Long> giftCodes = Arrays.asList(orderDVO.getGiftCodes().split(","))
                        .stream().map(a->Long.parseLong(a)).collect(Collectors.toList());
                List<MktGiftDO> giftList = mktGiftRepo.findByIdIn(giftCodes);
                giftList.forEach(gift -> {
                    BipOrderDRespVO.BriefGiftVO respVO = new BipOrderDRespVO.BriefGiftVO();
                    respVO.setItemCode(gift.getItemCode());
                    respVO.setItemName(gift.getItemName());
                    briefGiftVOS.add(respVO);
                });

//                String[] gigts = orderDVO.getGiftCodes().split(",");
//                for (String gigt : gigts) {
//                    MktGiftDO giftDO = mktGiftRepoProc.findByCode(gigt);
//                    BipOrderDRespVO.BriefGiftVO respVO = MktGiftCovert.INSTANCE.doTobgVo(giftDO);
//                    briefGiftVOS.add(respVO);
//                }
                orderDVO.setBriefGiftVOS(briefGiftVOS);
            }
        }

        bipOrderRespVO.setOrderDList(list);

        // 订单状态
        if(StringUtils.isNotBlank(biporderDo.getStatus())){
            String statusName=statusMap.get(biporderDo.getStatus());
            bipOrderRespVO.setStatusName(statusName);
        }

        // 优惠券code
        if (bipOrderRespVO.getCouponId()!=null){
            Optional<BipCouponDO> couponDO = bipCouponRepo.findById(bipOrderRespVO.getCouponId());
            if (couponDO.isPresent()) {
                bipOrderRespVO.setCouponCode(couponDO.get().getCouponCode());
            }
        }



        return bipOrderRespVO;
    }

    /***
        * @Description: 根据订单id 查询订单
        * @Param: [ids]
        * @return: java.util.List<com.elitesland.sale.entity.BipOrderDo>
        * @Date: 2021/8/18
     * @Author: wangyinghao
        */
    @Override
    public BipOrderRespVO findOrderById(Long id ){
        BipOrderDO biporderDo=bipOrderRepo.findById(id).get();
        BipOrderRespVO bipOrderRespVO=BipOrderConvert.INSTANCE.doToResp(biporderDo);
        List<BipOrderDDO> bipOrderDDOList =bipOrderDRepo.findByOrderId(id);
        List<BipOrderDRespVO> bipOrderDRespVOS=BipOrderDConvert.INSTANCE.dosToResps(bipOrderDDOList);
        bipOrderRespVO.setOrderDList(bipOrderDRespVOS);
         return bipOrderRespVO;

    }


    /***
        * @Description: 更新订单
        * @Param: [bipOrderDos]
        * @return: void
        * @Author: wangyinghao
        * @Date: 2021/8/18
        */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateOrder(BipOrderSaveVO bipOrderSaveVO){
        if(bipOrderSaveVO.getId()==null){
            throw new BusinessException("订单id不能为空");
        }
        BipOrderDO bipOrderDO=bipOrderRepo.findById(bipOrderSaveVO.getId()).get();
//        BeanUtil.beanCopy(bipOrderSaveVO,bipOrderDO);
        BipOrderConvert.INSTANCE.copySaveToDo(bipOrderSaveVO,bipOrderDO);
        bipOrderRepo.save(bipOrderDO);
    }


    /***
     * @Description: 更新订单
     * @Param: [bipOrderDos]
     * @return: void
     * @Author: wangyinghao
     * @Date: 2021/8/18
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void cancleOrder(BipOrderSaveVO bipOrderSaveVO){
        if(bipOrderSaveVO.getId()==null){
            throw new BusinessException("取消订单id不能为空");
        }
        if(StringUtils.isBlank(bipOrderSaveVO.getStatus())){
            throw new BusinessException("取消订单数据异常!");
        }
        BipOrderDO bipOrderDo=bipOrderRepo.findById(bipOrderSaveVO.getId()).get();

        List<BipOrderDDO> bipOrderDDOList=bipOrderDRepo.findByOrderId(bipOrderSaveVO.getId());
        bipOrderDDOList.stream().forEach(bipOrderDDO -> {
            Long skuId=bipOrderDDO.getSkuId();
            Long qty=bipOrderDDO.getBuyQty();
            bipItemService.incrementStock(skuId,qty.intValue());
            //恢复赠品库存
            if(null != bipOrderDDO.getGiftCodes() && !bipOrderDDO.getGiftCodes().isEmpty()){
                List<Long> giftCodes = Arrays.asList(bipOrderDDO.getGiftCodes().split(","))
                        .stream().map(a->Long.parseLong(a)).collect(Collectors.toList());
                List<MktGiftDO> giftList = mktGiftRepo.findByIdIn(giftCodes);
                List<Long> giftIds = giftList.stream().filter(a->a.getId()!=null).map(MktGiftDO::getId).collect(Collectors.toList());
                mktGiftRepo.addMktGiftById(giftIds);
            }

        });
        bipOrderRepoProc.updatStatus(bipOrderSaveVO);
    }

    /***
        * @Description: 逻辑删除---根据id集合删除订单
        * @Param: [ids]
        * @return: void
        * @Author: wangyinghao
        * @Date: 2021/8/18
        */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteOrderByIds(List<Long> ids){
        bipOrderRepo.deleteOrderByIds(ids);
        bipOrderDRepo.deleteOrderDByOrderIds(ids);

    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteOrderById(Long id){
        List<BipOrderBackDDO> bipOrderBackDDOList=bipOrderBackDRepo.findByOrderIdAndStatusIsNot(id,"DONE");
        if(bipOrderBackDDOList!=null&&bipOrderBackDDOList.size()>0){
            throw new BusinessException("订单关联退货单,不能删除!");
        }
        bipOrderRepo.deleteOrderById(id);
        List<Long> ids=new ArrayList<>();
        ids.add(id);
        bipOrderDRepo.deleteOrderDByOrderIds(ids);

    }

    /***
        * @Description: 逻辑删除----删除订单
        * @Param: [bipOrderDos]
        * @return: void
        * @Author: wangyinghao
        * @Date: 2021/8/18
        */
    @Override
    @Transactional
    public void deleteOrder(List<BipOrderSaveVO> bipOrderSaveVOS){
        List<BipOrderDO> list=bipOrderSaveVOS.stream().map(BipOrderConvert.INSTANCE::saveToDo).collect(Collectors.toList());
        list.stream().forEach( bipOrderDo -> {
            bipOrderDo.setDeleteFlag(1);
                }
        );
        bipOrderRepo.saveAll(list);

    }



    /***
        * @Description: 根据DO  封装查询条件
        * @Param: [bipOrderDParmVO]
        * @return: org.springframework.data.jpa.domain.Specification
        * @Author: wangyinghao
        * @Date: 2021/8/18
        */
    public Predicate where(BipOrderParmVO bipOrderParmVO) {
//        Predicate predicate=qBipOrderDo.isNotNull();
//
//       if (Objects.nonNull(bipOrderParmVO)){
//           if(StringUtils.isNotBlank(bipOrderParmVO.getAgentCode())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.agentCode.like("%" + bipOrderParmVO.getAgentCode() + "%"));
//           }
//
//           if(StringUtils.isNotBlank(bipOrderParmVO.getAgentName())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.agentName.like("%" + bipOrderParmVO.getAgentName() + "%"));
//           }
//
//           if(StringUtils.isNotBlank(bipOrderParmVO.getBackDocNo())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.backDocNo.like("%" + bipOrderParmVO.getBackDocNo() + "%"));
//           }
//
//           if(StringUtils.isNotBlank(bipOrderParmVO.getCustCode())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.custCode.like("%" + bipOrderParmVO.getCustCode() + "%"));
//           }
//
//           if(StringUtils.isNotBlank(bipOrderParmVO.getCustName())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.custName.like("%" + bipOrderParmVO.getCustName() + "%"));
//           }
//
//           if(StringUtils.isNotBlank(bipOrderParmVO.getDocNo())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.docNo.like("%" + bipOrderParmVO.getDocNo() + "%"));
//           }
//
//           if(Objects.nonNull(bipOrderParmVO.getInvoice())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.invoice.eq(bipOrderParmVO.getInvoice()));
//           }
//
//           if(Objects.nonNull(bipOrderParmVO.getId())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.id.eq(bipOrderParmVO.getId()));
//           }
//
//           if(StringUtils.isNotBlank(bipOrderParmVO.getPayMethod())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.payMethodName.like("%" + bipOrderParmVO.getPayMethod() + "%"));
//           }
//
//           if(Objects.nonNull(bipOrderParmVO.getPayTime())){
//               LocalDateTime sTime = bipOrderParmVO.getPayTime();
//               LocalDateTime nTime = sTime.plusDays(1);
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.payTime.goe(sTime).and(qBipOrderDo.payTime.lt(nTime)));
//           }
//
//           if(StringUtils.isNotBlank(bipOrderParmVO.getStatus())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.status.eq(bipOrderParmVO.getStatus()));
//           }
//
//           if(Objects.nonNull(bipOrderParmVO.getAgentEmpId())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.agentEmpId.eq(bipOrderParmVO.getAgentEmpId()));
//           }
//
//           if(Objects.nonNull(bipOrderParmVO.getDemandTime())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.demandTime.eq(bipOrderParmVO.getDemandTime()));
//           }
//
//           if(Objects.nonNull(bipOrderParmVO.getEvalTime())){
//               LocalDateTime sTime = bipOrderParmVO.getEvalTime();
//               LocalDateTime nTime = sTime.plusDays(1);
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.evalTime.goe(sTime).and(qBipOrderDo.evalTime.lt(nTime)));
//           }
//
//           if(Objects.nonNull(bipOrderParmVO.getOrderTime())){
//               LocalDateTime sTime = bipOrderParmVO.getOrderTime();
//               LocalDateTime nTime = sTime.plusDays(1);
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.orderTime.goe(sTime).and(qBipOrderDo.orderTime.lt(nTime)));
//           }
//
//           if(Objects.nonNull(bipOrderParmVO.getFinishTime())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.finishTime.eq(bipOrderParmVO.getFinishTime()));
//           }
//
//           if(Objects.nonNull(bipOrderParmVO.getSignTime())){
//               LocalDateTime sTime = bipOrderParmVO.getSignTime();
//               LocalDateTime nTime = sTime.plusDays(1);
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.signTime.goe(sTime).and(qBipOrderDo.signTime.lt(nTime)));
//           }
//
//           if(StringUtils.isNotBlank(bipOrderParmVO.getOuCode())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.ouCode.like("%"+bipOrderParmVO.getOuCode()+"%"));
//           }
//
//           if(StringUtils.isNotBlank(bipOrderParmVO.getOuName())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.ouName.eq("%"+bipOrderParmVO.getOuName()+"%"));
//           }
//
//           if(StringUtils.isNotBlank(bipOrderParmVO.getBuCode())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.buCode.eq(bipOrderParmVO.getBuCode()));
//           }
//
//           if(StringUtils.isNotBlank(bipOrderParmVO.getBuName())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.buName.eq("%"+bipOrderParmVO.getBuName()+"%"));
//           }
//
//           if(Objects.nonNull(bipOrderParmVO.getOuId())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.ouId.eq(bipOrderParmVO.getOuId()));
//           }
//
//           if(Objects.nonNull(bipOrderParmVO.getBuId())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.buId.eq(bipOrderParmVO.getBuId()));
//           }
//
//           if (Objects.nonNull(bipOrderParmVO.getFreeFare())){
//               if (bipOrderParmVO.getFreeFare()){
//                   predicate=ExpressionUtils.and(predicate,qBipOrderDo.fareAmt.eq(BigDecimal.ZERO));
//               } else {
//                   predicate=ExpressionUtils.and(predicate,qBipOrderDo.fareAmt.gt(BigDecimal.ZERO));
//               }
//           }
//
//           if (Objects.nonNull(bipOrderParmVO.getIsEval())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.isEval.eq(bipOrderParmVO.getIsEval()));
//           }
//
//           if (Objects.nonNull(bipOrderParmVO.getSyncOms())){
//               predicate=ExpressionUtils.and(predicate,qBipOrderDo.syncOms.eq(bipOrderParmVO.getSyncOms()));
//           }
//
//
////           predicate = ExpressionUtils.and(predicate, DataAuthJpaUtil.dataAuthJpaPredicate(qBipOrderDo.getMetadata()));
//       }
//        return predicate;
        return null;
    }

    /**
     *是否首单
     * @param
     * @param userId
     * @param payStatus
     * @return true 支付过不是新用户  false没有支付过 是新用户
     */
    @Override
    public Boolean isFirstOrder(Long userId,String payStatus){

        List<BipOrderDO> bipOrderDOS =bipOrderRepo.findByCustAccountIdAndPayStatus(userId,payStatus);

        return bipOrderDOS != null && bipOrderDOS.size() > 0;
    }

    @Override
    @Transactional
    public Long queryItemByOrderId(Long orderId) {
        List<Long> fetch = jpaQueryFactory.select(qBipOrderDo.ouId).from(qBipOrderDo).where(qBipOrderDo.id.eq(orderId)).fetch();

        return fetch.get(0);
    }

    @Override
    @Transactional
    public void updateItemOrderD(Long orderIds, boolean invoice ,Integer offFlag) {
        jpaQueryFactory.update(qBipOrderDo)
                .set(qBipOrderDo.invoice,true)
                .set(qBipOrderDo.offFlag,offFlag)
                .where(qBipOrderDo.id.in(orderIds)).execute();
    }


    /***
        * @Description: 订单签收
        * @Param: [bipOrderId]
        * @return: void
        * @Author: wangyinghao
        * @Date: 2021/9/14
        */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public ApiResult updateOrderSignStatus(Long bipOrderId) {
        BipOrderDO biporderDo=bipOrderRepo.findById(bipOrderId).get();
        if(biporderDo==null){
            throw new BusinessException("订单不存在!");
        }
        bipOrderRepoProc.updateSignStatus(bipOrderId, "signed");
        CurrentUserDTO currentUserDTO=UserService.currentUser();
        if(currentUserDTO==null){
            throw new BusinessException("获取登录人信息异常!");
        }
        UserDTO userDTO=currentUserDTO.getDetail();
        if(userDTO==null){
            throw new BusinessException("获取登录人信息异常!");
        }
        SalDoSignUserInfoDto salDoSignUserInfoDto=new SalDoSignUserInfoDto();
        salDoSignUserInfoDto.setConfirmUserId(currentUserDTO.getUserId());
        salDoSignUserInfoDto.setConfirmUserName(userDTO.getUsername());


        SalSoSignReqDto salSoSignReqDto=new SalSoSignReqDto();
        salSoSignReqDto.setDocNo(biporderDo.getDocNo());
        salSoSignReqDto.setSalDoSignUserInfoDto(salDoSignUserInfoDto);
        log.info("订单签收用户信息:"+JSON.toJSONString(userDTO));
        log.info("订单签收接口参数:"+JSON.toJSONString(salSoSignReqDto));


    //    ApiResult<Boolean> result= rmiOrderSalSoService.SignBySalSo(salSoSignReqDto);

        return ApiResult.ok();
    }

    /**
     * 更新订单发货状态
     * @param bipOrderId
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateOrderAllowStatus(Long bipOrderId) {
        bipOrderRepoProc.updateOrderAllowStatus(bipOrderId, UdcEnum.SAL_ORDER_STATUS_SHIP.getCode());
        bipOrderDRepoProc.updateOrderDAllowStatus(bipOrderId,UdcEnum.SAL_ORDER_STATUS_SHIP.getCode());

    }

    /**
     * 更新订单支付状态
     * @param bipOrderSaveVO
     */
    @Transactional(rollbackFor = Exception.class)
    public void updatePayStatus(BipOrderSaveVO bipOrderSaveVO) {
        bipOrderSaveVO.setPayTime(LocalDateTime.now());
        updateOrder(bipOrderSaveVO);
        List<BipOrderDDO> list = bipOrderDRepo.findByOrderId(bipOrderSaveVO.getId());
        list.stream().forEach(bipOrderDDO -> {
            bipOrderDDO.setPayDoneAmt(bipOrderDDO.getPayAmt());
            bipOrderDDO.setPayTime(LocalDateTime.now());
        });
        bipOrderDRepo.saveAll(list);
    }
    /**
     * 待付款 待收货 待评价
     * @param bipOrderUserParmVO
     */
    public PagingVO<BipOrderRespVO> findUserOrderByStatus(BipOrderUserParmVO bipOrderUserParmVO){
        CurrentUserDTO currentUser = UserService.currentUser();
        Long userId=currentUser.getUserId();

        if(currentUser==null||userId==null){
            throw new BusinessException("请先登录!");
        }

        Predicate predicate=qBipOrderDo.isNotNull();
        predicate=ExpressionUtils.and(predicate,qBipOrderDo.custAccountId.eq(userId));
        predicate=ExpressionUtils.and(predicate,qBipOrderDo.status.eq(bipOrderUserParmVO.getStatus()));

        Page<BipOrderDO> page= bipOrderRepo.findAll(predicate,bipOrderUserParmVO.getPageRequest());
        List<BipOrderRespVO> bipOrderRespVOList=page.getContent().stream().map(BipOrderConvert.INSTANCE::doToResp).collect(Collectors.toList());

        bipOrderRespVOList.stream().forEach(bipOrderRespVO -> {

            Long orderId=bipOrderRespVO.getId();
            List<BipOrderDRespVO> bipOrderDRespVOList=bipOrderDService.fingOrderDByorderId(orderId);

            log.info("订单明细集合——"+ JSON.toJSONString(bipOrderDRespVOList));

            List<Long> skuIds=bipOrderDRespVOList.stream()
                    .filter(bipOrderDRespVO -> bipOrderDRespVO.getSkuId()!=null)
                    .map(bipOrderDRespVO -> bipOrderDRespVO.getSkuId())
                    .distinct()
                    .collect(Collectors.toList());
            List<BipItemSkuDO> bipItemSkuDOS=bipItemSkuRepo.findAllById(skuIds);

            log.info("订单明细sku集合——"+ JSON.toJSONString(bipItemSkuDOS));
            Map<Long,List<BipItemSkuDO>> skuMap=bipItemSkuDOS.stream().collect(Collectors.groupingBy(BipItemSkuDO::getId));

            bipOrderDRespVOList.stream().forEach(bipOrderDRespVO -> {
                if(bipOrderDRespVO.getSkuId()!=null){
                    List<BipItemSkuDO> skus=skuMap.get(bipOrderDRespVO.getSkuId());
                    if(skus!=null &skus.size()>0){
                        BipItemSkuDO skuDO=skus.get(0);
                        BipItemSkuRespVO bipItemSkuRespVO=BipItemConvert.INSTANCE.sku2DetailRespVO(skuDO);
                        bipOrderDRespVO.setItemSkuRespVO(bipItemSkuRespVO);
                    }
                }
            });

            bipOrderRespVO.setOrderDList(bipOrderDRespVOList);
        });

        return PagingVO.<BipOrderRespVO>builder()
                .total(page.getTotalElements())
                .records(bipOrderRespVOList)
                .build();
    }

    /**
     * 全部订单
     * @param
     */
    @Override
    public PagingVO<BipOrderRespVO> findUserOrder(BipOrderUserParmVO bipOrderUserParmVO) {
        log.info("我的订单参数信息--"+JSON.toJSONString(bipOrderUserParmVO));
        CurrentUserDTO currentUser = UserService.currentUser();
        Long userId = currentUser.getUserId();

        BipOrderParmVO bipOrderParmVO=new BipOrderParmVO();
        bipOrderParmVO.setCustAccountId(userId);

        Predicate predicate = qBipOrderDO.isNotNull();

        if(StringUtils.isNotBlank(bipOrderUserParmVO.getStatus())){
            bipOrderParmVO.setStatus(bipOrderUserParmVO.getStatus());
            predicate = ExpressionUtils.and(predicate, qBipOrderDO.status.eq(bipOrderUserParmVO.getStatus()));
        }

        if(bipOrderUserParmVO.getOrderId()!=null){
            bipOrderParmVO.setId(bipOrderUserParmVO.getOrderId());
            predicate = ExpressionUtils.and(predicate, qBipOrderDO.id.eq(bipOrderUserParmVO.getOrderId()));
        }

        if("0".equals(bipOrderUserParmVO.getIsEval())){
            bipOrderParmVO.setIsEval(true);
            predicate = ExpressionUtils.and(predicate, qBipOrderDO.isEval.eq(true));
        }
        if("1".equals(bipOrderUserParmVO.getIsEval())){
            bipOrderParmVO.setIsEval(false);
            predicate = ExpressionUtils.and(predicate, qBipOrderDO.isEval.eq(false));
        }

        if(Objects.nonNull(bipOrderUserParmVO.getInvoice())){
            predicate = ExpressionUtils.and(predicate, qBipOrderDO.invoice.eq(!bipOrderUserParmVO.getInvoice()));
        }

        if(StringUtils.isNotBlank(bipOrderUserParmVO.getKeyword())){
            QBipOrderDDO qBipOrderDDO = QBipOrderDDO.bipOrderDDO;
            List<Long> orderIds = jpaQueryFactory.select(qBipOrderDDO.orderId).from(qBipOrderDDO)
                    .where(qBipOrderDDO.itemTitle.like("%" + bipOrderUserParmVO.getKeyword() + "%").and(qBipOrderDDO.createUserId.eq(userId)))
                    .fetch();
            if (orderIds==null || orderIds.size()==0){
                predicate = ExpressionUtils.and(predicate, qBipOrderDO.docNo.like("%" + bipOrderUserParmVO.getKeyword() + "%"));
            } else {
                predicate = ExpressionUtils.and(predicate, qBipOrderDO.id.in(orderIds));
            }

        }

        if(Objects.nonNull(bipOrderUserParmVO.getTimeTag())){
            if(1==bipOrderUserParmVO.getTimeTag()){
                LocalDateTime lastMonth = LocalDateTime.now().minusMonths(1);
                predicate = ExpressionUtils.and(predicate, qBipOrderDO.createTime.between(lastMonth,LocalDateTime.now()));
            }else if(2==bipOrderUserParmVO.getTimeTag()){
                LocalDateTime lastMonth = LocalDateTime.now().minusMonths(2);
                predicate = ExpressionUtils.and(predicate, qBipOrderDO.createTime.between(lastMonth,LocalDateTime.now()));
            }else if(6==bipOrderUserParmVO.getTimeTag()){
                LocalDateTime lastMonth = LocalDateTime.now().minusMonths(6);
                predicate = ExpressionUtils.and(predicate, qBipOrderDO.createTime.between(lastMonth,LocalDateTime.now()));
            }else if(12==bipOrderUserParmVO.getTimeTag()){
                LocalDateTime lastMonth = LocalDateTime.now().minusMonths(12);
                predicate = ExpressionUtils.and(predicate, qBipOrderDO.createTime.between(lastMonth,LocalDateTime.now()));
            }
        }

        predicate = ExpressionUtils.and(predicate, qBipOrderDO.custAccountId.eq(userId));

//        Page<BipOrderBackDO> page = bipOrderBackRepo.findAll(predicate, bipOrderBackUserParmVO.getPageRequest());

        Page<BipOrderDO> page = bipOrderRepo.findAll(predicate,bipOrderUserParmVO.getPageRequest());
        List<BipOrderRespVO> bipOrderRespVOList=page.getContent().stream().map(BipOrderConvert.INSTANCE::doToResp).collect(Collectors.toList());

        bipOrderRespVOList.stream().forEach(bipOrderRespVO -> {


            Long orderId=bipOrderRespVO.getId();
            List<BipOrderDRespVO> bipOrderDRespVOList=bipOrderDService.fingOrderDByorderId(orderId);


            bipOrderRespVO.setStatusName(statusMap.get(bipOrderRespVO.getStatus()));
            bipOrderRespVO.setTotalItemNum(0L);

            log.info("订单明细集合——"+ JSON.toJSONString(bipOrderDRespVOList));

            List<Long> skuIds=bipOrderDRespVOList.stream()
                    .filter(bipOrderDRespVO -> bipOrderDRespVO.getSkuId()!=null)
                    .map(bipOrderDRespVO -> bipOrderDRespVO.getSkuId())
                    .distinct()
                    .collect(Collectors.toList());
            List<BipItemSkuDO> bipItemSkuDOS=bipItemSkuRepo.findAllById(skuIds);

            log.info("订单明细sku集合——"+ JSON.toJSONString(bipItemSkuDOS));
            Map<Long,List<BipItemSkuDO>> skuMap=bipItemSkuDOS.stream().collect(Collectors.groupingBy(BipItemSkuDO::getId));

            //查询赠品信息
            List<String> giftCodes = bipOrderDRespVOList.stream().filter(a->a.getGiftCodes()!=null).map(BipOrderDRespVO::getGiftCodes).collect(Collectors.toList());
            List<Long> codes = new ArrayList<>();
            giftCodes.forEach(giftCode -> {
                codes.addAll(Arrays.asList(giftCode.split(",")).stream().map(a->Long.parseLong(a)).collect(Collectors.toList()));
            });
            List<BipGiftVO> giftList = mktDiscountGiftRepoProc.getGiftListByCode(codes, null).fetch();

            bipOrderDRespVOList.stream().forEach(bipOrderDRespVO -> {
                //实际付款单价 （应付金额-运费）/数量
                BigDecimal backPrice = (bipOrderDRespVO.getPayAmt().subtract(bipOrderDRespVO.getFareAmt())).divide(new BigDecimal(bipOrderDRespVO.getBuyQty()),2, RoundingMode.UP);
                bipOrderDRespVO.setBackPrice(backPrice);
                bipOrderDRespVO.setBuyAmt(backPrice);
                if(bipOrderDRespVO.getSkuId()!=null){
                    List<BipItemSkuDO> skus=skuMap.get(bipOrderDRespVO.getSkuId());
                    if(skus!=null &skus.size()>0){
                        BipItemSkuDO skuDO=skus.get(0);
                        BipItemSkuRespVO bipItemSkuRespVO=BipItemConvert.INSTANCE.sku2DetailRespVO(skuDO);
                        bipOrderDRespVO.setItemSkuRespVO(bipItemSkuRespVO);

                        List<BipItemSkuAttrRespVO> attrList=convert2List(skuDO.getAttr(), BipItemSkuAttrRespVO.class);

                        //属性转换字符串
                        List<String> list=new ArrayList<>();
                        for(int i=0;i<attrList.size();i++){
                            BipItemSkuAttrRespVO bipItemSkuAttrRespVO=JSON.parseObject(JSON.toJSONString(attrList.get(0)),BipItemSkuAttrRespVO.class);
                            if(bipItemSkuAttrRespVO!=null){
                                list.add(bipItemSkuAttrRespVO.getName()+":"+bipItemSkuAttrRespVO.getValue());
                            }
                        }
                        String attstr=String.join(";",list);
                        bipOrderDRespVO.setAttr(attstr);
                    }
                    //组装赠品信息
                    if(giftList!=null && giftList.size()>0){
                        List<BipGiftVO> giftVOS = new ArrayList<>();
                        giftList.forEach(gift -> {
                            if(gift.getSkuId().equals(bipOrderDRespVO.getSkuId())){
                                giftVOS.add(gift);
                            }
                        });
                        if(giftVOS.size()>0){
                            bipOrderDRespVO.setGiftList(giftVOS);
                        }
                    }
                }

                Long num=bipOrderRespVO.getTotalItemNum()+bipOrderDRespVO.getBuyQty();

                bipOrderRespVO.setTotalItemNum(num);

            });

            bipOrderRespVO.setOrderDList(bipOrderDRespVOList);
            String code=bipOrderRespVO.getPayMethodName();
            if("online".equals(code)){
                bipOrderRespVO.setPayMethodName(UdcEnum.SAL_ORDER_PAY_WAY_ONLINE.getValueCodeName());
            }else if("offline".equals(code)){
                bipOrderRespVO.setPayMethodName(UdcEnum.SAL_ORDER_PAY_WAY_OFFLINE.getValueCodeName());

            }

            if(bipOrderRespVO.getAdressId()!=null){
                //BipAddressVO bipAddressVO=bipAddressService.findById(bipOrderRespVO.getAdressId());
                BipOrderDO bo = bipOrderRepo.findById(bipOrderRespVO.getId()).get();
                if(null != bo){
                    BipAddressVO bipAddressVO = new BipAddressVO();
                    bipAddressVO.setMobile(bo.getMobile());
                    bipAddressVO.setDetailAddr(bo.getDetailAddr());
                    bipAddressVO.setDefaultFlag(bo.getDefaultFlag());
                    bipAddressVO.setCountyName(bo.getCountyName());
                    bipAddressVO.setCounty(bo.getCounty());
                    bipAddressVO.setProvinceName(bo.getProvinceName());
                    bipAddressVO.setProvince(bo.getProvince());
                    bipAddressVO.setCity(bo.getCity());
                    bipAddressVO.setCityName(bo.getCityName());
                    bipOrderRespVO.setBipAddressVO(bipAddressVO);
                }

            }

            // 价格修正
            for (BipOrderDRespVO dRespVO : bipOrderRespVO.getOrderDList()) {
                if (dRespVO.getCustPrice()==null || dRespVO.getCustPrice().compareTo(BigDecimal.ZERO)<=0){
                    dRespVO.setCustPrice(dRespVO.getBasePrice());
                }
            }

        });

        return PagingVO.<BipOrderRespVO>builder()
                .total(page.getTotalElements())
                .records(bipOrderRespVOList)
                .build();
    }


    /**
     * APP 通过订单id 查询 商品详情
     * @param id
     * @return
     */
    @Override
    public BipOrderRespVO findUserOrderDetail(Long id) {
        if (id == null) {
            throw new BusinessException("订单ID不能为空!");
        }

        BipOrderDO bipOrderDO = bipOrderRepo.findById(id).get();

        BipOrderRespVO bipOrderRespVO = BipOrderConvert.INSTANCE.doToResp(bipOrderDO);

        Long orderId = bipOrderRespVO.getId();
        List<BipOrderDRespVO> bipOrderDRespVOList = bipOrderDService.fingOrderDByorderId(orderId);


        bipOrderRespVO.setStatusName(statusMap.get(bipOrderRespVO.getStatus()));
        bipOrderRespVO.setTotalItemNum(0L);

        log.info("订单明细集合——" + JSON.toJSONString(bipOrderDRespVOList));

        List<Long> skuIds = bipOrderDRespVOList.stream()
                .filter(bipOrderDRespVO -> bipOrderDRespVO.getSkuId() != null)
                .map(bipOrderDRespVO -> bipOrderDRespVO.getSkuId())
                .distinct()
                .collect(Collectors.toList());
        List<BipItemSkuDO> bipItemSkuDOS = bipItemSkuRepo.findAllById(skuIds);

        log.info("订单明细sku集合——" + JSON.toJSONString(bipItemSkuDOS));
        Map<Long, List<BipItemSkuDO>> skuMap = bipItemSkuDOS.stream().collect(Collectors.groupingBy(BipItemSkuDO::getId));
        //查询赠品信息
        List<String> giftCodes = bipOrderDRespVOList.stream().filter(a->a.getGiftCodes()!=null).map(BipOrderDRespVO::getGiftCodes).collect(Collectors.toList());
        List<Long> codes = new ArrayList<>();
        giftCodes.forEach(giftCode -> {
            codes.addAll(Arrays.asList(giftCode.split(",")).stream().map(a->Long.parseLong(a)).collect(Collectors.toList()));
        });
        List<BipGiftVO> giftList = new ArrayList<>();
        if(null != codes && !codes.isEmpty()){
            giftList = mktDiscountGiftRepoProc.getGiftListByCode(codes, null).fetch();
        }
        log.info("订单明细");
        List<BipGiftVO> finalGiftList = giftList;
        bipOrderDRespVOList.stream().forEach(bipOrderDRespVO -> {
            if (bipOrderDRespVO.getSkuId() != null) {
                List<BipItemSkuDO> skus = skuMap.get(bipOrderDRespVO.getSkuId());
                if (skus != null & skus.size() > 0) {
                    BipItemSkuDO skuDO = skus.get(0);
                    BipItemSkuRespVO bipItemSkuRespVO = BipItemConvert.INSTANCE.sku2DetailRespVO(skuDO);
                    bipOrderDRespVO.setItemSkuRespVO(bipItemSkuRespVO);

                    List<BipItemSkuAttrRespVO> attrList = convert2List(skuDO.getAttr(), BipItemSkuAttrRespVO.class);

                    //属性转换字符串
                    List<String> list = new ArrayList<>();
                    for (int i = 0; i < attrList.size(); i++) {
                        BipItemSkuAttrRespVO bipItemSkuAttrRespVO = JSON.parseObject(JSON.toJSONString(attrList.get(i)), BipItemSkuAttrRespVO.class);
                        if (bipItemSkuAttrRespVO != null) {
                            list.add(bipItemSkuAttrRespVO.getName() + ":" + bipItemSkuAttrRespVO.getValue());
                        }

                    }

                    String attstr = String.join(";", list);
                    bipOrderDRespVO.setAttr(attstr);
                }
                //组装赠品信息
                if(finalGiftList !=null && finalGiftList.size()>0){
                    List<BipGiftVO> giftVOS = new ArrayList<>();
                    finalGiftList.forEach(gift -> {
                        if(gift.getSkuId().equals(bipOrderDRespVO.getSkuId())){
                            giftVOS.add(gift);
                        }
                    });
                    if(giftVOS.size()>0){
                        bipOrderDRespVO.setGiftList(giftVOS);
                    }
                }
            }

            Long num = bipOrderRespVO.getTotalItemNum() + bipOrderDRespVO.getBuyQty();
            bipOrderRespVO.setTotalItemNum(num);
        });

        log.info("支付方式名称");
        bipOrderRespVO.setOrderDList(bipOrderDRespVOList);
        String code = bipOrderRespVO.getPayMethodName();
        if ("online".equals(code)) {
            bipOrderRespVO.setPayMethodName(UdcEnum.SAL_ORDER_PAY_WAY_ONLINE.getValueCodeName());
        } else if ("offline".equals(code)) {
            bipOrderRespVO.setPayMethodName(UdcEnum.SAL_ORDER_PAY_WAY_OFFLINE.getValueCodeName());
        }

        log.info("地址");
//        if (bipOrderDO.getAdressId() != null) {
//            BipAddressVO bipAddressVO = bipAddressService.findById(bipOrderRespVO.getAdressId());
//            if(null == bipAddressVO){
//                bipAddressVO.setCity(bipOrderDO.getCity());
//                bipAddressVO.setCityName(bipOrderDO.getCityName());
//                bipAddressVO.setProvince(bipOrderDO.getProvince());
//                bipAddressVO.setProvinceName(bipOrderDO.getProvinceName());
//                bipAddressVO.setCounty(bipOrderDO.getCounty());
//                bipAddressVO.setCountyName(bipOrderDO.getCountyName());
//                bipAddressVO.setContPerson(bipOrderDO.getContPerson());
//                bipAddressVO.setDefaultFlag(bipOrderDO.getDefaultFlag());
//                bipAddressVO.setDetailAddr(bipOrderDO.getDetailAddr());
//                bipAddressVO.setMobile(bipOrderDO.getMobile());
//            }
//            bipOrderRespVO.setBipAddressVO(bipAddressVO);
//        }
        if (bipOrderDO.getAdressId() != null) {
            BipAddressVO bipAddressVO = new BipAddressVO();
            bipAddressVO.setCity(bipOrderDO.getCity());
            bipAddressVO.setCityName(bipOrderDO.getCityName());
            bipAddressVO.setProvince(bipOrderDO.getProvince());
            bipAddressVO.setProvinceName(bipOrderDO.getProvinceName());
            bipAddressVO.setCounty(bipOrderDO.getCounty());
            bipAddressVO.setCountyName(bipOrderDO.getCountyName());
            bipAddressVO.setContPerson(bipOrderDO.getContPerson());
            bipAddressVO.setDefaultFlag(bipOrderDO.getDefaultFlag());
            bipAddressVO.setDetailAddr(bipOrderDO.getDetailAddr());
            bipAddressVO.setMobile(bipOrderDO.getMobile());
            bipOrderRespVO.setBipAddressVO(bipAddressVO);
        }
        log.info("发货状态");
        //产品要求如此
//        String docNo=bipOrderRespVO.getDocNo();
//        List<String> docList=new ArrayList<>();
//        docList.add(docNo);
//        ApiResult<List<SalSoStatusRespDTO>> result=rmiDoRpcService.querySalSoStatus(docList);
//
//        log.info("状态查询返回结果--"+JSON.toJSONString(result));
//        if(!result.isSuccess()){
//            throw new BusinessException("查询订单状态异常!");
//        }
//        if(result.isSuccess()){
//            if(result.getData()!=null&&result.getData().size()>0){
//
//                SalSoStatusRespDTO salSoStatusRespDTO=result.getData().get(0);
//
//                String status=salSoStatusRespDTO.getDocStatus();
//                if("SHIP".equals(status)||"SIGN".equals(status)||"PARTSHIP".equals(status)){
//                    bipOrderRespVO.setIsSend(true);
//                }else{
//                    bipOrderRespVO.setIsSend(false);
//                }
//            }else{
//                bipOrderRespVO.setIsSend(false);
//            }
//
//        }

        // 修正价格
        for (BipOrderDRespVO dRespVO : bipOrderRespVO.getOrderDList()) {
            if (dRespVO.getCustPrice()==null || dRespVO.getCustPrice().compareTo(BigDecimal.ZERO)<=0){
                dRespVO.setCustPrice(dRespVO.getBasePrice());
            }
        }

        return bipOrderRespVO;
    }



    /**
     *
     * @param bipOrderDSaveVOS
     * @param userId
     * @param userName
     * @return
     */
    public BipCartItemRespVO buildCartItemRespVO(BipOrderDSaveVO bipOrderDSaveVOS,Long userId,String userName){
        BipCartItemRespVO bipCartItemRespVO=new BipCartItemRespVO();
        bipCartItemRespVO.setItemNum( bipOrderDSaveVOS.getBuyQty() );
        bipCartItemRespVO.setItemId( bipOrderDSaveVOS.getItemId() );
        bipCartItemRespVO.setItemCode( bipOrderDSaveVOS.getItemCode() );
        bipCartItemRespVO.setSkuId( bipOrderDSaveVOS.getSkuId() );
        bipCartItemRespVO.setSkuCode( bipOrderDSaveVOS.getSkuCode() );
        bipCartItemRespVO.setRelateItemId(bipOrderDSaveVOS.getRelateItemId());
        bipCartItemRespVO.setUserId(userId);
        bipCartItemRespVO.setUserName(userName);

        bipCartItemRespVO.setMktDiscountGiftDId(bipOrderDSaveVOS.getDiscountOffsetGiftDId());
        bipCartItemRespVO.setMktDiscountGiftId(bipOrderDSaveVOS.getDiscountOffsetGiftId());
        bipCartItemRespVO.setMktGiftId(bipCartItemRespVO.getMktDiscountGiftId());

        bipCartItemRespVO.setMktDiscountOffsetId(bipOrderDSaveVOS.getDiscountOffsetId());
        bipCartItemRespVO.setMktDiscountGiftDId(bipOrderDSaveVOS.getDiscountOffsetGiftDId());
        bipCartItemRespVO.setMktDiscountOffsetCode(bipOrderDSaveVOS.getDiscountOffsetCode());

        return bipCartItemRespVO;
    }


    /**
     * 订单支付
     * @param orderDocNo
     * @param openId
     * @param payAmt
     */
    public void payOrder(String  orderDocNo,String openId,BigDecimal payAmt){
//        CPCN5011Param cpcn5011Param = new CPCN5011Param();
//        //交易流水号
//        String txSN = CPCNUtils.getTxSN();
//        System.out.println(txSN);
//        cpcn5011Param.setTxSN(txSN);//交易流水号
//        cpcn5011Param.setPayerUserID("000001");//付款账户
//        cpcn5011Param.setPaymentWay("80");//跳转支付
//        cpcn5011Param.setAmount(new BigDecimal("1"));//支付金额
//        cpcn5011Param.setRemark("测试5011支付");//备注信息
//
//
//        cpcn5011Param.setRedirectSource("40");
//        cpcn5011Param.setLimitPay("10");
//        cpcn5011Param.setPayWay("51");
//        cpcn5011Param.setPayType("31");
//        cpcn5011Param.setSubOpenID("o7xbv4o1M6Ddol8vNmEra3CZwUF0");
//        cpcn5011Param.setPlatformName("B端小程序");
//        //商品名称
//        cpcn5011Param.setGoodsName("测试商品");
//        // 收款用户 007087  0001
//        cpcn5011Param.setPayerUserID("00787");
//        cpcn5011Param.setPayeeUserID("00787");
//        cpcn5011Param.setPayeeAccountNumber("0001");
//
//
//        cpcn5011Param.setPageURL("https://nrp-dev.elitescloud.com/yst-sale/doc.html");
//
////        cpcn5011Param.setNoticeUrl("http://nrp-dev.elitescloud.com/yst-fin/fin/cpcn/paymentNotice");//回调地址
//
//        //发送请求
//        CPCN5011Resp cpcn5011Resp = CPCNUtils.cpcn5011Request(cpcn5011Param);


    }

    /**
     * 订单支付成功修改状态
     * @param biporderDo
     */
    @Transactional
    public void BuildPayOrderSucessInfo(BipOrderDO biporderDo){

        biporderDo.setPayDoneAmt(biporderDo.getPayAmt());
        biporderDo.setPayTime(LocalDateTime.now());
        biporderDo.setStatus("shipping");
        bipOrderRepo.save(biporderDo);

        List<BipOrderDDO> list = bipOrderDRepo.findByOrderId(biporderDo.getId());
        for(BipOrderDDO bipOrderDDO:list){
            bipOrderDDO.setPayDoneAmt(biporderDo.getPayAmt());
            bipOrderDDO.setPayTime(LocalDateTime.now());

//            bipOrderDDO.setStatus(UdcEnum.SAL_ORDER_PAY_STATUS_PD.getCode());
        }
        bipOrderDRepo.saveAll(list);

       bipOrderToOmsServiceimpl.sendToOms(biporderDo.getId());
    }


    /**
     * 订单支付成功修改状态
     * @param biporderDo
//     */
//    public void BuildPayOrderSucessInfo(BipOrderDO biporderDo,List<BipOrderDDO> bipOrderDDOS){
//
//        biporderDo.setPayDoneAmt(biporderDo.getPayAmt());
//        biporderDo.setStatus("shipping");
//        biporderDo.setPayTime(LocalDateTime.now());
//
//        for(BipOrderDDO bipOrderDDO:bipOrderDDOS){
//            bipOrderDDO.setPayDoneAmt(biporderDo.getPayAmt());
////            bipOrderDDO.setStatus(UdcEnum.SAL_ORDER_PAY_STATUS_PD.getValueCode());
//        }
//
//    }

    /**
     * 查询客户等级价格
     * @param itemId
     * @param custLevel
     * @return
     */
    @Override
    public BigDecimal getCustPrice(Long itemId,String custLevel) {
        var priceList = salePriceService.queryCustPrice(itemId).getData();
        if (CollUtil.isEmpty(priceList)) {
            return null;
        }

        BigDecimal min = null;
        BigDecimal priceTemp = null;
        for (var custPrice : priceList) {
            priceTemp = custPrice.getPrice();
            if (priceTemp == null) {
                // 价格为空则不需要再判断
                continue;
            }

            if (UdcEnum.PRI_SALE_PRICE_TYPE_GROUP.getValueCode().equals(custPrice.getPriceType())) {
                // 客户等级
                if (ObjectUtil.equal(custLevel, custPrice.getCustGroup())) {
                    min = min == null ? priceTemp : NumberUtil.min(min, priceTemp);
                    continue;
                }
            }
        }
        return min;
    }


    /**
     *更新订单支付状态
     */

    @Override
    @Transactional
    public void updateOrderPayStatus(String payStatus,String docNo,String status,String txsn,LocalDateTime payTime,BigDecimal payDoneAmt){

        bipOrderRepoProc.updateOrderPayStatus(payStatus,docNo,status,txsn,payTime,payDoneAmt);
    }


    /**
     * 更新明细支付金额
     * @param docNo
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void updateOrderDPayDoneAmt(String docNo){

        List<BipOrderDDO> bipOrderDDOS=bipOrderDRepo.findByOrderDocNo(docNo);
        for(BipOrderDDO bipOrderDDO:bipOrderDDOS){
            BigDecimal payAmt=bipOrderDDO.getPayAmt();
            bipOrderDDO.setPayDoneAmt(payAmt);
        }
        bipOrderDRepo.saveAll(bipOrderDDOS);
    }

    @Override
    public JSONObject findUserOrderCount(Long userId) {
        JSONObject jsonObject = new JSONObject();
        if(null == userId){
            jsonObject.put("unpaid",0);
            jsonObject.put("shipping",0);
            jsonObject.put("signed",0);
            jsonObject.put("cancelled",0);
            jsonObject.put("back",0);
            return jsonObject;
        }
        //查询订单数量 待付款unpaid 待收货shipping 已签收signed 已取消cancelled
        QBipOrderDO qBipOrderDO = QBipOrderDO.bipOrderDO;
        BooleanExpression unpaidExpre = qBipOrderDO.deleteFlag.eq(0).and(qBipOrderDO.custAccountId.eq(userId)).and(qBipOrderDO.status.eq("unpaid"));
        Long unpaidCount = bipOrderRepo.count(unpaidExpre);
        jsonObject.put("unpaid",unpaidCount);
        BooleanExpression shippingExpre = qBipOrderDO.deleteFlag.eq(0).and(qBipOrderDO.custAccountId.eq(userId)).and(qBipOrderDO.status.eq("shipping"));
        Long shippingCount = bipOrderRepo.count(shippingExpre);
        jsonObject.put("shipping",shippingCount);
        BooleanExpression signedExpre = qBipOrderDO.deleteFlag.eq(0).and(qBipOrderDO.custAccountId.eq(userId)).and(qBipOrderDO.status.eq("signed"));
        Long signedCount = bipOrderRepo.count(signedExpre);
        jsonObject.put("signed",signedCount);
        BooleanExpression cancelledExpre = qBipOrderDO.deleteFlag.eq(0).and(qBipOrderDO.custAccountId.eq(userId)).and(qBipOrderDO.status.eq("cancelled"));
        Long cancelledCount = bipOrderRepo.count(cancelledExpre);
        jsonObject.put("cancelled",cancelledCount);
        //查询退货数量
        QBipOrderBackDO qBipOrderBackDO = QBipOrderBackDO.bipOrderBackDO;
        BooleanExpression backExpre = qBipOrderBackDO.deleteFlag.eq(0).and(qBipOrderBackDO.custAccountId.eq(userId)).and(qBipOrderBackDO.status.notEqualsIgnoreCase("DONE")).and(qBipOrderBackDO.status.notEqualsIgnoreCase("CL"));
        Long backCount = bipOrderBackRepo.count(backExpre);
        jsonObject.put("back",backCount);
        return jsonObject;
    }

    /**
     *
     */
    public  CPCN5011Resp cpcn5011(BipOrderDO bipOrderDO,String code){

//        Long id=bipOrderDO.getId();
//        List<BipOrderDRespVO> bipOrderDRespVOList=bipOrderDService.fingOrderDByorderId(id);
//
//        RmiOrgBankAccRpcVO rmiOrgBankAccRpcVO = getVirtualInfo(bipOrderDO.getOuId());
//        if(null == rmiOrgBankAccRpcVO){
//            throw new BusinessException("银行信息为空");
//        }
//        String name=bipOrderDRespVOList.stream().map(BipOrderDRespVO::getItemName).distinct().collect(Collectors.joining(","));
//        List<Long> skuIds=bipOrderDRespVOList.stream().map(BipOrderDRespVO::getSkuId).distinct().collect(Collectors.toList());
//
//        log.info("中金支付商品sku集合--"+JSON.toJSONString(skuIds));
//        List<BipItemSkuDO> bipItemSkuDOS=bipItemSkuRepo.findAllById(skuIds);
//        log.info("中金支付商品sku--"+JSON.toJSONString(skuIds));
//
//        String itemName=bipItemSkuDOS.stream().map(BipItemSkuDO::getItemName).distinct().collect(Collectors.joining(","));
//        log.info("中金支付商品名称--"+itemName);
//
//        log.info("获取oppenID--"+code);
//        SysSettingVO settingByCode = rmiSettingService.findSettingByCode("CURR_ENV_SIGN");
//        String settingVal = settingByCode.getSettingVal();
//        String appIdStr = "";
//        String appSecret = "";
//        String oppenId = "";
//        if(StringUtils.isNotBlank(settingVal) && "PD".equals(settingVal)){
//            //使用PD环境的appid
//            appIdStr = "wxa5f61ba7cf17311b";
//            appSecret = "2ac04268b9e8adbf640a921c0c619fad";
//            oppenId = postJsonData(code,appIdStr,appSecret);
//        }else {
//            appIdStr = "wx8b96d73b29ef2bef";
//            appSecret = "b6b237fa607706b93b9daed8c320f493";
//            oppenId=postJsonData(code,appIdStr,appSecret);
//        }
//
//        log.info("返回oppenId---"+oppenId);
//        //交易流水号
//        CPCN5011Param cpcn5011Param = new CPCN5011Param();
//        //交易流水号
//        String txSN = CPCNUtils.getTxSN();
//        System.out.println(txSN);
//        cpcn5011Param.setTxSN(txSN);//交易流水号
////        cpcn5011Param.setPayerUserID("000001");//付款账户
//        cpcn5011Param.setPaymentWay("80");//跳转支付
////        cpcn5011Param.setAmount(new BigDecimal("0.01"));//支付金额
//        cpcn5011Param.setAmount(bipOrderDO.getPayAmt());//支付金额
//
//        cpcn5011Param.setRemark("B端商城订单线上支付");//备注信息
//        cpcn5011Param.setOrderNo(bipOrderDO.getDocNo());
//
//
//        cpcn5011Param.setRedirectSource("40");
//        cpcn5011Param.setLimitPay("10");
//        cpcn5011Param.setPayWay("51");
//        cpcn5011Param.setPayType("31");
//        cpcn5011Param.setSubOpenID(oppenId);
//        cpcn5011Param.setPlatformName("壹品慧生活");
//        cpcn5011Param.setSubAppID(appIdStr);
//        //中燃生产
//        //cpcn5011Param.setSubAppID("wx8b96d73b29ef2bef");
//        //中燃PD
//     //   cpcn5011Param.setSubAppID("wxa5f61ba7cf17311b");
//        //商品名称
//        cpcn5011Param.setGoodsName(itemName);
//        cpcn5011Param.setPayerUserID(String.valueOf(bipOrderDO.getCustAccountId()));
//        // 收款用户 007087  0001   收款账号 通过公司ID查询账户
//     //   cpcn5011Param.setPayeeAccountNumber("0001");
//
//        cpcn5011Param.setPayeeAccountNumber(rmiOrgBankAccRpcVO.getThirdpartyVirtualAcc());
//        cpcn5011Param.setPayeeUserID(rmiOrgBankAccRpcVO.getThirdpartyVirtualUserId());
//
////        cpcn5011Param.setNoticeUrl("http://10.10.30.190:8082/sale/cpcn/paymentNotice");//回调地址
//        log.info("回调地址信息---"+payMentNoticrl);
//        cpcn5011Param.setNoticeUrl(payMentNoticrl);//回调地址
//        //发送请求
//        CPCN5011Resp cpcn5011Resp = CPCNUtils.cpcn5011Request(cpcn5011Param);
//
//        return cpcn5011Resp;
        return null;
    }

    //查询虚拟账号信息
    public RmiOrgBankAccRpcVO getVirtualInfo(Long ouId){
        //查询虚拟用户ID和账户
        List<RmiOrgBankAccRpcVO> resList = new ArrayList<>();
        log.info("订单公司ID:---"+ouId);
        List<Long> ouIds = new ArrayList<>();
        ouIds.add(ouId);
        OrgOuRpcDtoParam orgOuRpcDtoParam=new OrgOuRpcDtoParam();
        orgOuRpcDtoParam.setOuIds(ouIds);
        List<OrgOuRpcDTO> orgOuRpcDTOS = rmiOrgOuService.findOuDtoListByParam(orgOuRpcDtoParam);
        log.info("根据公司的信息获取到公司对应的地址号信息:-----"+JSON.toJSONString(orgOuRpcDTOS));
        if(null != orgOuRpcDTOS && !orgOuRpcDTOS.isEmpty()){
            OrgOuRpcDTO orgOuRpcDTO=orgOuRpcDTOS.get(0);
            OrgBankAccRpcDtoParam orgBankAccRpcDtoParam = new OrgBankAccRpcDtoParam();
            if(null != orgOuRpcDTO.getAddrNo()){
                List<Long> addNos = new ArrayList<>();
                addNos.add(orgOuRpcDTO.getAddrNo());
                orgBankAccRpcDtoParam.setAddrNos(addNos);
                log.info("根据地址信息获取银行信息参数:-----"+JSON.toJSONString(orgBankAccRpcDtoParam));
                List<RmiOrgBankAccRpcVO> list = rmiOrgAddrService.findBankAccRpcDtoByParam(orgBankAccRpcDtoParam);
                log.info("根据地址信息获取银行信息:-----"+JSON.toJSONString(list));
                if(null != list && !list.isEmpty()){
                    list.stream().forEach(l ->{
                        //收款账号
                        if(StringUtils.isNotBlank(l.getAccType()) && "IN".equals(l.getAccType()) && StringUtils.isNotBlank(l.getThirdpartyVirtualUserId()) && StringUtils.isNotBlank(l.getThirdpartyVirtualAcc())){
                            resList.add(l);
                        }
                    });
                }else {
                    throw new BusinessException("银行账户信息获取异常，参数:------"+JSON.toJSONString(orgBankAccRpcDtoParam));
                }
            }else {
                throw new BusinessException("支付时获取的参数:--------"+JSON.toJSONString(orgBankAccRpcDtoParam));
            }
        }
        if(null == resList || resList.isEmpty()){
            return null;
        }
        return resList.get(0);
    }



    public static String  postJsonData(String code, String appid, String appsecret) {

        log.info("获取openID参数--code:"+code+",--appid:"+appid+"--appsecret:"+appsecret);
        String requestUrl = "https://api.weixin.qq.com/sns/jscode2session";
        HttpPost httppost = new HttpPost(requestUrl);
        CloseableHttpClient httpclient = HttpClients.createDefault();
        List<NameValuePair> formparams = new ArrayList<NameValuePair>();
        formparams.add(new BasicNameValuePair("appid", appid));
        formparams.add(new BasicNameValuePair("secret", appsecret));
        formparams.add(new BasicNameValuePair("js_code", code));
        formparams.add(new BasicNameValuePair("grant_type", "authorization_code"));
        log.info("获取openID参数:"+JSON.toJSONString(formparams));
        CloseableHttpResponse response = null;
        try {
            httppost.setEntity(new UrlEncodedFormEntity(formparams));
            response = httpclient.execute(httppost);

        } catch (UnsupportedEncodingException e1) {
            log.info(e1.getMessage());
        } catch (ClientProtocolException e) {
            log.info(e.getMessage());
        } catch (IOException e) {
            log.info(e.getMessage());
        }
        JSONObject jsonObject = null;
        if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
            HttpEntity httpEntity = response.getEntity();
            String result = null;
            try {
                result = EntityUtils.toString(httpEntity);
                log.info("微信请求oppenID返回信息:"+JSON.toJSONString(result));
            } catch (ParseException e) {
                log.info(e.getMessage());
            } catch (IOException e) {
                log.info(e.getMessage());
            }// 返回json格式：
            jsonObject = JSONObject.parseObject(result);
        }
        String access_token = jsonObject.getString("access_token");
        String opendId = jsonObject.getString("openid");
        return opendId;
    }


    /**
     * 待付款订单再次支付
     * @param bipAppOrderPayVO
     * @return
     */
    @Override
    public Map orderPay(BipAppOrderPayVO bipAppOrderPayVO){
        if(bipAppOrderPayVO.getCode()==null){
            throw new BusinessException("Code不能为空!");
        }
        if(bipAppOrderPayVO.getOrderId()==null){
            throw new BusinessException("订单id不能为空!");
        }

        BipOrderDO bipOrderDO=bipOrderRepo.findById(bipAppOrderPayVO.getOrderId()).get();

        CPCN5011Resp cpcn5011Resp=cpcn5011(bipOrderDO,bipAppOrderPayVO.getCode());
        if(cpcn5011Resp==null){
            throw new BusinessException("支付异常!");
        }
        Map hashMap=new HashMap();
        hashMap.put("code",cpcn5011Resp.getQRAuthCode());
        return hashMap;
    }
    public static void main(String[] args) {
//        postJsonData("031CKzFa1Z86WB0lqNHa1ByK0f3CKzFm","wx8b96d73b29ef2bef","b6b237fa607706b93b9daed8c320f493");

        BigDecimal farmt=new BigDecimal(2.01);
        System.out.println(farmt.compareTo(BigDecimal.ZERO));
    }

}
