/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.config;

import com.elitescloud.cloudt.authorization.api.client.config.AuthorizationProperties;
import com.elitescloud.cloudt.authorization.sdk.config.AuthorizationSdkProperties;
import com.elitesland.yst.production.sale.config.cas.UserSourceService;
import com.elitesland.yst.production.sale.config.cas.support.CustomUserDetailManager;
import com.elitesland.yst.production.sale.config.cas.support.UserSyncProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="elitesland.authorization.sdk.cas-client", name={"enabled"}, havingValue="true")
public class AuthConfig
implements InitializingBean {
    private static final Logger log = LogManager.getLogger(AuthConfig.class);
    private final AuthorizationSdkProperties sdkProperties;
    private final AuthorizationProperties authorizationProperties;
    private UserSourceService userSourceService;

    public AuthConfig(AuthorizationSdkProperties sdkProperties, AuthorizationProperties authorizationProperties) {
        this.sdkProperties = sdkProperties;
        this.authorizationProperties = authorizationProperties;
    }

    @Bean
    public UserSyncProvider userSyncProvider() {
        return new UserSyncProvider(this.userSourceService);
    }

    @Bean
    public CustomUserDetailManager customUserDetailManager() {
        return new CustomUserDetailManager((com.elitescloud.boot.auth.client.config.AuthorizationProperties)this.authorizationProperties, this.userSourceService);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.userSourceService == null) {
            log.error("\u7edf\u4e00\u8eab\u4efd\u8ba4\u8bc1\u5f02\u5e38\uff0c\u7f3a\u5c11\u670d\u52a1{}\u5b9e\u73b0\u7c7b", (Object)UserSourceService.class.getName());
        }
    }

    @Autowired(required=false)
    public void setUserSourceService(UserSourceService userSourceService) {
        this.userSourceService = userSourceService;
    }
}

