/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.config.cas.support;

import com.elitescloud.boot.auth.client.common.AuthorizationException;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.authorization.api.provider.provider.user.AbstractUserDetailManager;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.yst.production.sale.config.cas.UserSourceService;
import java.util.List;
import java.util.function.Supplier;
import javax.validation.constraints.NotBlank;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomUserDetailManager
extends AbstractUserDetailManager {
    private static final Logger log = LogManager.getLogger(CustomUserDetailManager.class);
    private final UserSourceService userSourceService;
    private TenantClientProvider tenantClientProvider;
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    public CustomUserDetailManager(AuthorizationProperties authorizationProperties, UserSourceService userSourceService) {
        super(authorizationProperties);
        this.userSourceService = userSourceService;
    }

    public GeneralUserDetails loadUserByUsername(@NotBlank String username) {
        log.info("\u6839\u636e\u7528\u6237\u540d\u767b\u5f55,\u7528\u6237\u540d\u4e3a\u3010" + username + "\u3011");
        return this.loadUser(() -> this.userSourceService.loadUserByUsername(username));
    }

    public GeneralUserDetails loadUserByMobile(@NotBlank String mobile) {
        log.info("\u6839\u636e\u624b\u673a\u53f7\u767b\u5f55,\u624b\u673a\u53f7\u4e3a\u3010" + mobile + "\u3011");
        return this.loadUser(() -> this.userSourceService.loadUserByMobile(mobile));
    }

    public GeneralUserDetails loadUserByEmail(@NotBlank String email) {
        log.error("\u6682\u4e0d\u652f\u6301\u6839\u636e\u90ae\u7bb1\u767b\u5f55");
        throw new AuthorizationException("\u767b\u5f55\u5931\u8d25");
    }

    public GeneralUserDetails loadUserById(@NotBlank String id) {
        log.info("\u6839\u636e\u7528\u6237ID\u4e3a\u3010" + id + "\u3011");
        return this.loadUser(() -> this.userSourceService.loadUserById(Long.valueOf(id)));
    }

    public GeneralUserDetails loadUserByAccount(@NotBlank String account) {
        log.error("\u6682\u4e0d\u652f\u6301\u6839\u636e\u8d26\u53f7\u767b\u5f55");
        throw new AuthorizationException("\u767b\u5f55\u5931\u8d25");
    }

    public GeneralUserDetails loadUserByWechatOpenid(@NotBlank String openId) {
        log.error("\u6682\u4e0d\u652f\u6301\u6839\u636e\u5fae\u4fe1\u53f7\u53f7\u767b\u5f55");
        throw new AuthorizationException("\u767b\u5f55\u5931\u8d25");
    }

    private GeneralUserDetails loadUser(Supplier<SysUserDTO> userDTOSupplier) {
        SysTenantDTO tenant;
        SysUserDTO user = (SysUserDTO)this.tenantDataIsolateProvider.byNone(userDTOSupplier::get);
        if (user == null) {
            return null;
        }
        if (this.tenantClientProvider.enabledTenant() && (tenant = this.tenantClientProvider.getCurrentTenant()) != null) {
            user.setSysTenantVO(tenant);
            user.setSysTenantDTOList(List.of(tenant));
        }
        return super.wrapUserDetails(user);
    }

    @Autowired(required=false)
    public void setTenantClientProvider(TenantClientProvider tenantClientProvider) {
        this.tenantClientProvider = tenantClientProvider;
    }

    @Autowired
    public void setTenantDataIsolateProvider(TenantDataIsolateProvider tenantDataIsolateProvider) {
        this.tenantDataIsolateProvider = tenantDataIsolateProvider;
    }
}

