/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.controller.shop;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.shop.BipItemAppService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemCategoryService;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipItemAppQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.app.BipItemRecommendAppQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.ItemCatTreeRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemAttrAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemDetailAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemHotAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemListAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemRecGoodAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipItemRecommendAppRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipReceiptAddrAppRespVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\uff08app\uff09"})
@ApiSupport(author="Kaiser\uff08wang shao\uff09")
@RestController
@RequestMapping(value={"/bip/app/item"}, produces={"application/json"})
public class BipItemAppController {
    private final BipItemAppService itemAppService;
    private final BipItemCategoryService categoryService;

    public BipItemAppController(BipItemAppService itemAppService, BipItemCategoryService categoryService) {
        this.itemAppService = itemAppService;
        this.categoryService = categoryService;
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u7c7b\u6811\u5f62\u6570\u636e\u83b7\u53d6")
    @ApiOperationSupport(order=1)
    @ApiImplicitParams(value={@ApiImplicitParam(name="ouId", value="\u6240\u5c5e\u516c\u53f8")})
    @GetMapping(value={"/cat/tree"})
    public ApiResult<List<ItemCatTreeRespVO>> tree(Long ouId) {
        return this.categoryService.treeOfOu(ouId);
    }

    @ApiOperation(value="\u5168\u90e8\u5546\u54c1\u5217\u8868")
    @ApiOperationSupport(order=2)
    @PostMapping(value={"/search/all"})
    public ApiResult<PagingVO<BipItemListAppRespVO>> queryAll(@RequestBody BipItemAppQueryParamVO queryParamVO) {
        return this.itemAppService.queryForApp(queryParamVO);
    }

    @ApiOperation(value="\u5546\u54c1\u8be6\u60c5")
    @ApiOperationSupport(order=3)
    @GetMapping(value={"/{id}/{ouId}"})
    public ApiResult<BipItemDetailAppRespVO> detail(@PathVariable Long id, @PathVariable Long ouId) {
        return this.itemAppService.getDetail(id, ouId);
    }

    @ApiOperation(value="\u5546\u54c1SKU\u4fe1\u606f")
    @ApiOperationSupport(order=4)
    @GetMapping(value={"/{id}/sku"})
    public ApiResult<BipItemAttrAppRespVO> getSku(@PathVariable Long id) {
        return this.itemAppService.getItemSku(id);
    }

    @ApiOperation(value="\u6536\u8d27\u5730\u5740\u67e5\u8be2")
    @ApiOperationSupport(order=5)
    @GetMapping(value={"/receipt/address"})
    public ApiResult<List<BipReceiptAddrAppRespVO>> queryAddress() {
        return this.itemAppService.queryReceiptAddr();
    }

    @ApiOperation(value="\u5546\u54c1\u63a8\u8350")
    @ApiOperationSupport(order=6)
    @PostMapping(value={"/recommend"})
    public ApiResult<List<BipItemRecommendAppRespVO>> queryRecommend(@RequestBody BipItemRecommendAppQueryParamVO queryParamVO) {
        return this.itemAppService.queryForAppRecommend(queryParamVO);
    }

    @ApiOperation(value="\u7cbe\u54c1\u63a8\u8350")
    @ApiOperationSupport(order=7)
    @ApiImplicitParams(value={@ApiImplicitParam(name="ouId", value="\u6240\u5c5e\u516c\u53f8ID"), @ApiImplicitParam(name="size", value="\u8bf7\u6c42\u6570\u636e\u6570\u91cf\uff0c\u9ed8\u8ba410")})
    @GetMapping(value={"/rec/good"})
    public ApiResult<List<BipItemRecGoodAppRespVO>> queryRecGood(Long ouId, Integer size) {
        return this.itemAppService.queryForRecGood(ouId, size);
    }

    @ApiOperation(value="\u70ed\u9500\u5546\u54c1")
    @ApiOperationSupport(order=8)
    @GetMapping(value={"/search/hot/{id}"})
    public ApiResult<PagingVO<BipItemHotAppRespVO>> queryHot(@PathVariable Long id) {
        return this.itemAppService.queryForAppHot(id);
    }
}

