/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.event.listener;

import com.elitesland.yst.production.sale.api.service.FirstSpecialItemService;
import com.elitesland.yst.production.sale.event.ItemShelfEvent;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ItemShelfListener
implements ApplicationListener<ItemShelfEvent> {
    private static final Logger log = LoggerFactory.getLogger(ItemShelfListener.class);
    @Autowired
    private FirstSpecialItemService firstSpecialItemService;

    public void onApplicationEvent(ItemShelfEvent event) {
        log.info("\u76d1\u542c\u5230\u5546\u54c1\u4e0a\u4e0b\u67b6\u4e8b\u4ef6\uff1a{}\uff0c{}", (Object)event.getBipItemId(), (Object)event.isOnShelf());
        this.offShelfForSpecial(event);
    }

    private void offShelfForSpecial(ItemShelfEvent event) {
        if (event.isOnShelf()) {
            return;
        }
        CompletableFuture.runAsync(() -> this.firstSpecialItemService.updateItemState(List.of(Long.valueOf(event.getBipItemId())))).whenComplete((res, throwable) -> {
            log.info("\u4e13\u533a\u5546\u54c1\u4e0b\u67b6\u5904\u7406\u5b8c\u6bd5\uff01");
            if (throwable != null) {
                log.error("\u4e13\u533a\u5546\u54c1\u4e0b\u67b6\u5904\u7406\u9047\u5230\u5f02\u5e38\uff1a", throwable);
            }
        });
    }
}

