/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.api.vo.param.shop.MktGiftQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktGiftRespVO;
import com.elitesland.yst.production.sale.entity.MktGiftDO;
import com.elitesland.yst.production.sale.entity.QMktGiftDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class MktGiftRepoProc {
    @Autowired
    private JPAQueryFactory jpaQueryFactory;
    private final QMktGiftDO qMktGiftDO = QMktGiftDO.mktGiftDO;

    public JPAQuery<MktGiftRespVO> select(MktGiftQueryVO queryParam) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(MktGiftRespVO.class, (Expression[])new Expression[]{this.qMktGiftDO.id, this.qMktGiftDO.itemId, this.qMktGiftDO.itemCode, this.qMktGiftDO.itemName, this.qMktGiftDO.validStime, this.qMktGiftDO.validEtime, this.qMktGiftDO.stockNum, this.qMktGiftDO.discountGiftItemId, this.qMktGiftDO.discountGiftCode})).from((EntityPath)this.qMktGiftDO)).where((Predicate)this.qMktGiftDO.deleteFlag.eq((Object)0));
        if (queryParam != null) {
            jpaQuery.where(this.buildCondition(queryParam));
        }
        return jpaQuery;
    }

    private Predicate buildCondition(MktGiftQueryVO queryParam) {
        BooleanExpression predicate = this.qMktGiftDO.isNotNull();
        if (!StringUtils.isEmpty((Object)queryParam.getDiscountGiftCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qMktGiftDO.discountGiftItemId.eq((Object)queryParam.getDiscountGiftItemId()));
        }
        if (queryParam.getDiscountGiftItemId() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qMktGiftDO.discountGiftItemId.eq((Object)queryParam.getDiscountGiftItemId()));
        }
        if (queryParam.getItemId() != null) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qMktGiftDO.itemId.eq((Object)queryParam.getItemId()));
        }
        if (!StringUtils.isEmpty((Object)queryParam.getItemCode())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qMktGiftDO.itemCode.like("%" + queryParam.getItemCode() + "%"));
        }
        if (!StringUtils.isEmpty((Object)queryParam.getItemName())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qMktGiftDO.itemName.like("%" + queryParam.getItemName() + "%"));
        }
        if (!StringUtils.isEmpty((Object)queryParam.getValidStime())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qMktGiftDO.validStime.eq((Object)queryParam.getValidStime()).or((Predicate)this.qMktGiftDO.validStime.after((Comparable)queryParam.getValidStime())));
        }
        if (!StringUtils.isEmpty((Object)queryParam.getValidEtime())) {
            predicate = ExpressionUtils.and((Predicate)predicate, (Predicate)this.qMktGiftDO.validEtime.eq((Object)queryParam.getValidEtime()).or((Predicate)this.qMktGiftDO.validEtime.before((Comparable)queryParam.getValidEtime())));
        }
        return predicate;
    }

    public MktGiftDO findByCode(String code) {
        return (MktGiftDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qMktGiftDO).from((EntityPath)this.qMktGiftDO)).where((Predicate)this.qMktGiftDO.itemCode.eq((Object)code))).limit(1L)).fetchOne();
    }

    public List<MktGiftDO> findByCodes(List<String> codes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qMktGiftDO).from((EntityPath)this.qMktGiftDO)).where((Predicate)this.qMktGiftDO.itemCode.in(codes))).fetch();
    }

    public List<MktGiftDO> findByMktCodes(List<String> codes) {
        if (codes == null || codes.size() == 0) {
            return new ArrayList<MktGiftDO>();
        }
        return ((JPAQuery)this.jpaQueryFactory.select((Expression)this.qMktGiftDO).from((EntityPath)this.qMktGiftDO)).fetch();
    }

    public List<String> findDiscountCode(String giftCode) {
        if (giftCode == null) {
            return new ArrayList<String>();
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qMktGiftDO.discountGiftCode).from((EntityPath)this.qMktGiftDO)).where((Predicate)this.qMktGiftDO.itemCode.like("%" + giftCode + "%"))).fetch();
    }
}

