/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.rmi.ystsupport;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.api.vo.resp.sal.RmiOrgBankAccRpcVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddressRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrAddressRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrQueryRpcParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddressRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.param.OrgBankAccRpcDtoParam;
import com.elitesland.yst.production.support.provider.org.service.OrgAddrRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RmiOrgAddrService {
    private static final Logger log = LoggerFactory.getLogger(RmiOrgAddrService.class);
    @Autowired
    private OrgAddrRpcService orgAddrRpcService;

    public void orgAddrAddressDelete(Long id) {
        try {
            this.orgAddrRpcService.orgAddrAddressDelete(id);
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u76f8\u5173\u670d\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u4fdd\u5b58\u670d\u52a1\u5f02\u5e38" + e, (Throwable)e);
        }
    }

    public ApiResult<Long> orgAddrAddressSaveOrUpdate(OrgAddrAddressRpcSaveParam param) {
        try {
            return this.orgAddrRpcService.orgAddrAddressSaveOrUpdate(param);
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u76f8\u5173\u670d\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u4fdd\u5b58\u670d\u52a1\u5f02\u5e38" + e, (Throwable)e);
        }
    }

    public ApiResult<Long> orgAddrSaveOrUpdate(OrgAddrRpcSaveParam param) {
        try {
            return this.orgAddrRpcService.orgAddrSaveOrUpdateReturnAddrNo(param);
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u76f8\u5173\u670d\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u4fdd\u5b58\u670d\u52a1\u5f02\u5e38" + e, (Throwable)e);
        }
    }

    public ApiResult<Long> orgAddrSaveOrUpdateReturnAddrNo(OrgAddrRpcSaveParam param) {
        try {
            return this.orgAddrRpcService.orgAddrSaveOrUpdateReturnAddrNo(param);
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u76f8\u5173\u670d\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u4fdd\u5b58\u670d\u52a1\u5f02\u5e38" + e, (Throwable)e);
        }
    }

    public ApiResult<OrgAddrDetailsRpcDTO> findAddrByAddrNo(Long addrNo) {
        try {
            OrgAddrQueryRpcParam param = new OrgAddrQueryRpcParam();
            param.setAddrNo(addrNo);
            param.setDataSources(Collections.singletonList(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode()));
            return this.orgAddrRpcService.findRpcDtoByParam(param);
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u76f8\u5173\u670d\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u901a\u8fc7\u5730\u5740\u53f7\u67e5\u8be2\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
    }

    public List<OrgAddressRpcDTO> findAddrAddressListByParam(OrgAddressRpcDtoParam param) {
        try {
            List addressRpcDtoByParam = this.orgAddrRpcService.findAddrAddressRpcDtoByParam(param);
            return CollUtil.isNotEmpty((Collection)addressRpcDtoByParam) ? addressRpcDtoByParam : new ArrayList(0);
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u76f8\u5173\u670d\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u67e5\u8be2\u670d\u52a1\u5f02\u5e38" + e, (Throwable)e);
        }
    }

    @SysCodeProc
    public List<RmiOrgBankAccRpcVO> findBankAccRpcDtoByParam(OrgBankAccRpcDtoParam param) {
        try {
            ArrayList<RmiOrgBankAccRpcVO> list = new ArrayList<RmiOrgBankAccRpcVO>();
            List bankRpcDtoByParam = this.orgAddrRpcService.findBankAccRpcDtoByParam(param);
            bankRpcDtoByParam.forEach(bank -> {
                if (param.getBankAcc() != null) {
                    if (param.getBankAcc().equals(bank.getBankAcc())) {
                        RmiOrgBankAccRpcVO rmiVO = (RmiOrgBankAccRpcVO)BeanUtil.copyProperties((Object)bank, RmiOrgBankAccRpcVO.class, (String[])new String[0]);
                        list.add(rmiVO);
                    }
                } else {
                    RmiOrgBankAccRpcVO rmiVO = (RmiOrgBankAccRpcVO)BeanUtil.copyProperties((Object)bank, RmiOrgBankAccRpcVO.class, (String[])new String[0]);
                    list.add(rmiVO);
                }
            });
            return list;
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u76f8\u5173\u670d\u52a1\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException("\u8fdc\u7a0b\u8c03\u7528\u652f\u6491\u57df\u5730\u5740\u7c3f\u67e5\u8be2\u670d\u52a1\u5f02\u5e38" + e, (Throwable)e);
        }
    }
}

