/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.search.store.service.impl;

import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.FieldFns;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.core.support.udc.support.SysUdcProxyService;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.yst.production.sale.api.service.SaleStatisticsDtlService;
import com.elitesland.yst.production.sale.api.service.SaleStatisticsService;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreDtlQueryVO;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.BaseModelVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreDtlRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.SaleStatisticsStoreRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsStoreSumRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.entity.SaleStatisticsStoreDO;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreRepo;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreRepoProc;
import com.elitesland.yst.production.sale.repo.SaleStatisticsStoreRepoSqlProc;
import com.elitesland.yst.production.sale.search.store.bean.BasicsBean;
import com.elitesland.yst.production.sale.search.store.bean.StatisticsStoreDtlSearchBean;
import com.elitesland.yst.production.sale.search.store.bean.StatisticsStoreSearchBean;
import com.elitesland.yst.production.sale.search.store.service.SearchBeanService;
import com.elitesland.yst.production.sale.search.store.service.StatisticsStoreSearchService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class StatisticsStoreSearchServiceImpl
implements StatisticsStoreSearchService {
    @Autowired
    private SearchBeanService searchBeanService;
    @Autowired
    private SaleStatisticsStoreRepo saleStatisticsStoreRepo;
    @Autowired
    private SaleStatisticsStoreRepoProc saleStatisticsRepoProc;
    @Autowired
    private SaleStatisticsStoreRepoSqlProc saleStatisticsStoreRepoSqlProc;
    @Autowired
    private SysUdcProxyService sysUdcProxyService;
    @Autowired
    private SaleStatisticsService saleStatisticsService;
    @Autowired
    private SaleStatisticsDtlService saleStatisticsDtlService;

    @Override
    @SysCodeProc
    public PagingVO<SaleStatisticsStoreRespVO> page(SaleStatisticsStoreQueryVO pageParam) {
        this.assembleDocTime(pageParam);
        if (Objects.isNull(pageParam.getDocTimeStart()) || Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7edf\u8ba1\u65e5\u671f\u4e3a\u7a7a!");
        }
        PagingVO<SaleStatisticsStoreRespVO> page = this.saleStatisticsRepoProc.pcPage(pageParam);
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        this.sysUdcProxyService.translate((Object)page.getRecords());
        this.translateDealer(page.getRecords());
        return page;
    }

    @Override
    @SysCodeProc
    public PagingVO<SaleStatisticsStoreRespVO> appPage(SaleStatisticsStoreQueryVO pageParam) {
        this.assembleDocTime(pageParam);
        PagingVO<SaleStatisticsStoreRespVO> page = this.saleStatisticsRepoProc.appPage(pageParam);
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return PagingVO.builder().total(0L).records(Collections.EMPTY_LIST).build();
        }
        this.sysUdcProxyService.translate((Object)page.getRecords());
        this.translateDealer(page.getRecords());
        return page;
    }

    @Override
    public StatisticsStoreSumRespVO pageSum(SaleStatisticsStoreQueryVO pageParam) {
        this.assembleDocTime(pageParam);
        StatisticsStoreSumRespVO statisticsStoreSumRespVO = this.saleStatisticsStoreRepoSqlProc.pageSumPc(pageParam);
        if (Objects.isNull(statisticsStoreSumRespVO)) {
            return null;
        }
        return statisticsStoreSumRespVO;
    }

    @Override
    public StatisticsStoreSumRespVO appPageSum(SaleStatisticsStoreQueryVO pageParam) {
        this.assembleDocTime(pageParam);
        StatisticsStoreSumRespVO statisticsStoreSumRespVO = this.saleStatisticsStoreRepoSqlProc.pageSumPc(pageParam);
        if (Objects.isNull(statisticsStoreSumRespVO)) {
            return null;
        }
        return statisticsStoreSumRespVO;
    }

    @Override
    @SysCodeProc
    public PagingVO<SaleStatisticsStoreRespVO> appDetails(SaleStatisticsStoreQueryVO pageParam) {
        if (pageParam.getId() != null) {
            Optional byId = this.saleStatisticsStoreRepo.findById(pageParam.getId());
            if (byId.isPresent()) {
                pageParam.setRegion(((SaleStatisticsStoreDO)((Object)byId.get())).getRegion());
                pageParam.setSalesmanPath(((SaleStatisticsStoreDO)((Object)byId.get())).getSalesmanPath());
                pageParam.setDealerCode(((SaleStatisticsStoreDO)((Object)byId.get())).getDealerCode());
                pageParam.setStoreCode(((SaleStatisticsStoreDO)((Object)byId.get())).getStoreCode());
                pageParam.setDocTimeStart(LocalDateTime.of(((SaleStatisticsStoreDO)((Object)byId.get())).getDocTime().toLocalDate(), LocalTime.MIN));
                pageParam.setDocTimeEnd(LocalDateTime.of(((SaleStatisticsStoreDO)((Object)byId.get())).getDocTime().toLocalDate(), ConstantsSale.LOCAL_TIME_MAX));
            }
            pageParam.setId(null);
        }
        this.appDetailsCheck(pageParam);
        List<SaleStatisticsStoreRespVO> query = this.saleStatisticsRepoProc.query(pageParam);
        this.sysUdcProxyService.translate(query);
        this.translateDealer(query);
        return PagingVO.builder().total((long)query.size()).records(query).build();
    }

    private MapBuilder setMapBuilder(SaleStatisticsStoreQueryVO queryVO) {
        MapBuilder whereSqlMapBuilder = MapUtils.builder().page((long)queryVO.getPageRequest().getPageNumber(), queryVO.getPageRequest().getPageSize());
        ((MapBuilder)whereSqlMapBuilder.field(BasicsBean::getDeleteFlag, new Object[]{0})).op((FieldOp)FieldOps.Equal);
        if (!Objects.isNull(queryVO.getId())) {
            ((MapBuilder)whereSqlMapBuilder.field(BasicsBean::getId, new Object[]{queryVO.getId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getIds())) {
            ((MapBuilder)whereSqlMapBuilder.field(BasicsBean::getId, (Collection)queryVO.getIds())).op((FieldOp)FieldOps.InList);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerCode())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDealerCode, new Object[]{queryVO.getDealerCode()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerName())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDealerName, new Object[]{queryVO.getDealerName()})).op((FieldOp)FieldOps.Contain);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerKeyword())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDealerCode, new FieldFns.FieldFn[]{StatisticsStoreSearchBean::getDealerName})).sql("$1 like '%?' or $2 like '%?' ", new Object[]{queryVO.getDealerKeyword(), queryVO.getDealerKeyword()});
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getKeyword())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getStoreName, new FieldFns.FieldFn[]{StatisticsStoreSearchBean::getStoreCode})).sql("$1 like '%?' or $2 like '%?' ", new Object[]{queryVO.getKeyword(), queryVO.getKeyword()});
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getDealerSerialNo())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDealerSerialNo, new Object[]{queryVO.getDealerSerialNo()})).op((FieldOp)FieldOps.Contain);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getRegion())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getRegion, new Object[]{queryVO.getRegion()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getType())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getType, new Object[]{queryVO.getType()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getSalesmanPath())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getSalesmanPath, new Object[]{queryVO.getSalesmanPath()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getVehicleType())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getVehicleType, new Object[]{queryVO.getVehicleType()})).op((FieldOp)FieldOps.Equal);
        }
        if (queryVO.getDocTimeStart() != null && queryVO.getDocTimeEnd() != null) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDocTime, new Object[]{queryVO.getDocTimeStart(), queryVO.getDocTimeEnd()})).op((FieldOp)FieldOps.Between);
        } else {
            if (queryVO.getDocTimeStart() != null) {
                ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDocTime, new Object[]{queryVO.getDocTimeStart()})).op((FieldOp)FieldOps.GreaterEqual);
            }
            if (queryVO.getDocTimeEnd() != null) {
                ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDocTime, new Object[]{queryVO.getDocTimeEnd()})).op((FieldOp)FieldOps.LessEqual);
            }
        }
        if (Objects.nonNull(queryVO.getDocTimeItStart())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getYearMonthInt, new Object[]{queryVO.getDocTimeItStart()})).op((FieldOp)FieldOps.GreaterEqual);
        }
        if (Objects.nonNull(queryVO.getDocTimeItEnd())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getYearMonthInt, new Object[]{queryVO.getDocTimeItEnd()})).op((FieldOp)FieldOps.LessEqual);
        }
        if (Objects.nonNull(queryVO.getDocMonth())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDocMonth, new Object[]{queryVO.getDocMonth()})).op((FieldOp)FieldOps.Equal);
        }
        if (Objects.nonNull(queryVO.getDocTime())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getDocDate, new Object[]{queryVO.getDocTime().toLocalDate().toString()})).op((FieldOp)FieldOps.Equal);
        }
        if (!Objects.isNull(queryVO.getShipQty())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getShipQty, new Object[]{queryVO.getShipQty()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getItemType3())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getItemType3, new Object[]{queryVO.getItemType3()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getStoreCode())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getStoreCode, new Object[]{queryVO.getStoreCode()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getStoreName())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getStoreName, new Object[]{queryVO.getStoreName()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getEmpCode())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getEmpCode, new Object[]{queryVO.getEmpCode()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getEmpName())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getEmpName, new Object[]{queryVO.getEmpName()})).op((FieldOp)FieldOps.Equal);
        }
        if (!Objects.isNull(queryVO.getUserId2())) {
            ((MapBuilder)whereSqlMapBuilder.field(StatisticsStoreSearchBean::getUserId2, new Object[]{queryVO.getUserId2()})).op((FieldOp)FieldOps.Equal);
        }
        return whereSqlMapBuilder;
    }

    public void assembleDocTime(SaleStatisticsStoreQueryVO pageParam) {
        if (Objects.isNull(pageParam.getDocTimeStart()) || Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7edf\u8ba1\u65e5\u671f\u4e3a\u7a7a!");
        }
        if (Objects.nonNull(pageParam.getDocTimeStart())) {
            LocalDate localDateStart = pageParam.getDocTimeStart().toLocalDate();
            LocalDateTime minTime = LocalDateTime.of(localDateStart, LocalTime.MIN);
            pageParam.setDocTimeStart(minTime);
        }
        if (Objects.nonNull(pageParam.getDocTimeEnd())) {
            LocalDate localDateEnd = pageParam.getDocTimeEnd().toLocalDate();
            LocalDateTime maxTime = LocalDateTime.of(localDateEnd, ConstantsSale.LOCAL_TIME_MAX);
            pageParam.setDocTimeEnd(maxTime);
        }
    }

    private void translateDealer(List<SaleStatisticsStoreRespVO> respVOList) {
        List<Long> idList = respVOList.stream().map(BaseModelVO::getId).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<SaleStatisticsStoreDtlRespVO> dtlRespVOList = this.selectDtlByMasId(idList);
        respVOList.forEach(respVO -> {
            List dtlRespVOS = dtlRespVOList.stream().filter(dtlRespVO -> Objects.equals(dtlRespVO.getMasId(), respVO.getId())).collect(Collectors.toList());
            respVO.setDtlRespVOS(dtlRespVOS);
            String docMonth = respVO.getDocTime().format(DateTimeFormatter.ofPattern("yyyy-MM"));
            respVO.setDocMonth(docMonth);
            dtlRespVOS.stream().forEach(dtlRespVO -> {
                StringJoiner spliceName = new StringJoiner(" ").add(dtlRespVO.getTypeName()).add(dtlRespVO.getName());
                if (Objects.equals("0", dtlRespVO.getLevel())) {
                    respVO.setAgentEmp(dtlRespVO.getCode());
                    respVO.setAgentEmpName(spliceName.toString());
                } else if (Objects.equals("1", dtlRespVO.getLevel())) {
                    respVO.setLevelOne(spliceName.toString());
                } else if (Objects.equals("2", dtlRespVO.getLevel())) {
                    respVO.setLevelTwo(spliceName.toString());
                } else if (Objects.equals("3", dtlRespVO.getLevel())) {
                    respVO.setLevelThree(spliceName.toString());
                } else if (Objects.equals("4", dtlRespVO.getLevel())) {
                    respVO.setLevelFour(spliceName.toString());
                } else if (Objects.equals("5", dtlRespVO.getLevel())) {
                    respVO.setLevelFive(spliceName.toString());
                }
            });
        });
    }

    private MapBuilder setDtlMapBuilder(SaleStatisticsStoreDtlQueryVO queryVO) {
        MapBuilder whereSqlMapBuilderDtl = MapUtils.builder();
        ((MapBuilder)whereSqlMapBuilderDtl.field(com.elitesland.yst.production.sale.search.bean.BasicsBean::getDeleteFlag, new Object[]{0})).op((FieldOp)FieldOps.Equal);
        if (!Objects.isNull(queryVO.getUserId())) {
            ((MapBuilder)whereSqlMapBuilderDtl.field(StatisticsStoreDtlSearchBean::getUserId, new Object[]{queryVO.getUserId()})).op((FieldOp)FieldOps.Equal);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getLevel())) {
            ((MapBuilder)whereSqlMapBuilderDtl.field(StatisticsStoreDtlSearchBean::getLevel, new Object[]{queryVO.getLevel()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getLevels())) {
            ((MapBuilder)whereSqlMapBuilderDtl.field(StatisticsStoreDtlSearchBean::getLevel, (Collection)queryVO.getLevels())).op((FieldOp)FieldOps.InList);
        }
        if (!StringUtils.isEmpty((CharSequence)queryVO.getCode())) {
            ((MapBuilder)whereSqlMapBuilderDtl.field(StatisticsStoreDtlSearchBean::getCode, new Object[]{queryVO.getCode()})).op((FieldOp)FieldOps.Equal);
        }
        if (!CollectionUtils.isEmpty((Collection)queryVO.getCodes())) {
            ((MapBuilder)whereSqlMapBuilderDtl.field(StatisticsStoreDtlSearchBean::getCode, (Collection)queryVO.getCodes())).op((FieldOp)FieldOps.InList);
        }
        return whereSqlMapBuilderDtl;
    }

    private List<SaleStatisticsStoreDtlRespVO> selectDtlByMasId(List<Long> masIds) {
        if (CollectionUtils.isEmpty(masIds)) {
            return Collections.EMPTY_LIST;
        }
        SaleStatisticsStoreDtlQueryVO queryVO = new SaleStatisticsStoreDtlQueryVO();
        queryVO.setMasIds(masIds);
        List dtlRespVOList = this.saleStatisticsDtlService.selectByParam(queryVO);
        if (CollectionUtils.isEmpty((Collection)dtlRespVOList)) {
            return Collections.EMPTY_LIST;
        }
        return dtlRespVOList;
    }

    private void appDetailsCheck(SaleStatisticsStoreQueryVO pageParam) {
        if (StringUtils.isBlank((CharSequence)pageParam.getDealerCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5ba2\u6237\u7f16\u7801\u4e3a\u7a7a!");
        }
        if (Objects.isNull(pageParam.getDocTimeStart()) || Objects.isNull(pageParam.getDocTimeEnd())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u7edf\u8ba1\u65f6\u95f4\u4e3a\u7a7a!");
        }
        if (Objects.isNull(pageParam.getStoreCode())) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u95e8\u5e97\u7f16\u7801\u4e3a\u7a7a!");
        }
    }
}

