/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.yst.production.sale.convert.SalContractDConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.dto.SalContractDQtyRespDTO;
import com.elitesland.yst.production.sale.dto.SalContractDRespDTO;
import com.elitesland.yst.production.sale.dto.SalContractRespDTO;
import com.elitesland.yst.production.sale.entity.QSalContractDDO;
import com.elitesland.yst.production.sale.entity.QSalContractDO;
import com.elitesland.yst.production.sale.entity.SalContractDDO;
import com.elitesland.yst.production.sale.repo.SalContractDRepo;
import com.elitesland.yst.production.sale.repo.SalContractDRepoProc;
import com.elitesland.yst.production.sale.service.SalContractRpcService;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/cloudt/sale/contract"})
public class SalContractRpcServiceImpl
extends BaseServiceImpl
implements SalContractRpcService {
    private static final Logger log = LoggerFactory.getLogger(SalContractRpcServiceImpl.class);
    @Autowired
    private SalContractDRepo salContractDRepo;
    @Autowired
    private SalContractDRepoProc salContractDRepoProc;
    private final QSalContractDDO qSalContractDDO = QSalContractDDO.salContractDDO;
    private final QSalContractDO qSalContractDO = QSalContractDO.salContractDO;

    public ApiResult<SalContractDRespDTO> updateContractD(Long did) {
        SalContractDConvert salContractDConvert = SalContractDConvert.INSTANCE;
        SalContractDRespDTO dto = null;
        Optional byId = this.salContractDRepo.findById(did);
        if (byId.isPresent()) {
            dto = salContractDConvert.do2rpcDTO((SalContractDDO)byId.get());
            return ApiResult.ok((Object)dto);
        }
        return ApiResult.fail((String)"\u67e5\u65e0\u4fe1\u606f");
    }

    public ApiResult<List<SalContractDQtyRespDTO>> queryContractDQty(List<Long> relateDocDids) {
        if (ObjectUtils.isEmpty(relateDocDids)) {
            return null;
        }
        JPAQuery<SalContractDQtyRespDTO> respDTOJPAQuery = this.select(relateDocDids);
        List contractDQtyRespDTOS = respDTOJPAQuery.fetch();
        return ApiResult.ok((Object)contractDQtyRespDTOS);
    }

    public ApiResult<List<SalContractRespDTO>> queryContractByCode(List<String> contractNos) {
        if (CollectionUtils.isEmpty(contractNos)) {
            return null;
        }
        JPAQuery<SalContractRespDTO> jpaQuery = this.selectForContract(contractNos);
        List contractRespDTOS = jpaQuery.fetch();
        return ApiResult.ok((Object)contractRespDTOS);
    }

    public JPAQuery<SalContractRespDTO> selectForContract(List<String> contractNos) {
        Object predicate = null;
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalContractRespDTO.class, (Expression[])new Expression[]{this.qSalContractDO.id.as("contractId"), this.qSalContractDO.contractName, this.qSalContractDO.contractNo})).from((EntityPath)this.qSalContractDO);
        jpaQuery.where(new Predicate[]{predicate, this.qSalContractDO.contractNo.in(contractNos)});
        jpaQuery.where(new Predicate[]{predicate, this.qSalContractDO.deleteFlag.eq((Object)0).or((Predicate)this.qSalContractDO.deleteFlag.isNotNull())});
        return jpaQuery;
    }

    public JPAQuery<SalContractDQtyRespDTO> select(List<Long> relateDocDids) {
        Object predicate = null;
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalContractDQtyRespDTO.class, (Expression[])new Expression[]{this.qSalContractDDO.id, this.qSalContractDDO.qty})).from((EntityPath)this.qSalContractDDO);
        jpaQuery.where(new Predicate[]{predicate, this.qSalContractDDO.id.in(relateDocDids)});
        jpaQuery.where(new Predicate[]{predicate, this.qSalContractDDO.deleteFlag.eq((Object)0).or((Predicate)this.qSalContractDDO.deleteFlag.isNull())});
        return jpaQuery;
    }
}

