/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitesland.yst.production.sale.api.service.SalQuotationDService;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalQuotationDRespVO;
import com.elitesland.yst.production.sale.convert.SalQuotationDConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.entity.QSalQuotationDDO;
import com.elitesland.yst.production.sale.repo.SalQuotationDRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SalQuotationDServiceImpl
extends BaseServiceImpl
implements SalQuotationDService {
    private static final Logger log = LoggerFactory.getLogger(SalQuotationDServiceImpl.class);
    private final QSalQuotationDDO qSalQuotationDDO = QSalQuotationDDO.salQuotationDDO;
    private final SalQuotationDRepo salQuotationdRepo;

    @SysCodeProc
    public List<SalQuotationDRespVO> findSalQuotationdByMasId(Long id) {
        JPAQuery<SalQuotationDRespVO> salQuotationdRespVo = this.findByMasId(id);
        List quotationDRespVOS = salQuotationdRespVo.fetch();
        quotationDRespVOS.forEach(quo -> quo.setTaxRate(quo.getTaxRate().multiply(BigDecimal.valueOf(100L))));
        return quotationDRespVOS;
    }

    @Transactional(rollbackFor={Exception.class})
    public List<SalQuotationDRespVO> createSalQuotationD(List<SalQuotationDRespVO> salQuotationdRespVoS, Long masId) {
        if (CollectionUtils.isEmpty(salQuotationdRespVoS)) {
            return new ArrayList<SalQuotationDRespVO>();
        }
        try {
            this.checkForSave(salQuotationdRespVoS);
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25,\u8bf7\u68c0\u67e5\u5fc5\u586b\u9879");
        }
        this.salQuotationdRepo.deleteByMasId(masId);
        salQuotationdRespVoS.forEach(sal -> sal.setTaxRate(sal.getTaxRate().divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_UP)));
        this.salQuotationdRepo.saveAll(salQuotationdRespVoS.stream().map(SalQuotationDConvert.INSTANCE::RespVOToDo).collect(Collectors.toList()));
        return salQuotationdRespVoS;
    }

    private void checkForSave(List<SalQuotationDRespVO> salQuotationdRespVoS) {
        salQuotationdRespVoS.forEach(sal -> {
            Assert.isFalse((boolean)StringUtils.isEmpty((Object)sal.getItemCode()), (String)"\u4fdd\u5b58\u6570\u636e\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
            Assert.isFalse((boolean)StringUtils.isEmpty((Object)sal.getQty()), (String)"\u4fdd\u5b58\u6570\u636e\u5546\u54c1\u6570\u91cf\u4e3a\u7a7a", (Object[])new Object[0]);
        });
    }

    public JPAQuery<SalQuotationDRespVO> findByMasId(Long masId) {
        return (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SalQuotationDRespVO.class, (Expression[])new Expression[]{this.qSalQuotationDDO.id, this.qSalQuotationDDO.itemId, this.qSalQuotationDDO.itemCode, this.qSalQuotationDDO.itemName, this.qSalQuotationDDO.itemSpec, this.qSalQuotationDDO.itemBrand, this.qSalQuotationDDO.remark, this.qSalQuotationDDO.demandTimespan, this.qSalQuotationDDO.qty, this.qSalQuotationDDO.uom, this.qSalQuotationDDO.netPrice, this.qSalQuotationDDO.netAmt, this.qSalQuotationDDO.price, this.qSalQuotationDDO.amt, this.qSalQuotationDDO.taxAmt, this.qSalQuotationDDO.taxRate, this.qSalQuotationDDO.taxRateDesc, this.qSalQuotationDDO.discRatio, this.qSalQuotationDDO.taxRateNo, this.qSalQuotationDDO.discAmt, this.qSalQuotationDDO.priceOrig, this.qSalQuotationDDO.lineType, this.qSalQuotationDDO.lineNo})).from((EntityPath)this.qSalQuotationDDO)).where((Predicate)this.qSalQuotationDDO.masId.eq((Object)masId));
    }

    public SalQuotationDServiceImpl(SalQuotationDRepo salQuotationdRepo) {
        this.salQuotationdRepo = salQuotationdRepo;
    }
}

