/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.service.shop;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.constant.Terminal;
import com.elitescloud.cloudt.system.param.SysUserNewParam;
import com.elitesland.yst.production.sale.api.service.ComSaleFileInfoService;
import com.elitesland.yst.production.sale.api.service.shop.BipCompanyManageService;
import com.elitesland.yst.production.sale.api.service.shop.BipCrmCustService;
import com.elitesland.yst.production.sale.api.vo.resp.com.ComSaleFileComVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCompanyManageRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCrmCustInfoVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipCustQualifyRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.app.BipCustQualifySaveVO;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipCrmCustSaveVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.convert.CrmCustConvert;
import com.elitesland.yst.production.sale.core.service.BaseServiceImpl;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.BipCustUserBindDO;
import com.elitesland.yst.production.sale.entity.CrmCustDO;
import com.elitesland.yst.production.sale.repo.CrmCustRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepo;
import com.elitesland.yst.production.sale.repo.shop.BipCustUserBindRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsupport.RmiOrgAddrService;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysOauth2RpcService;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrDetailsRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgAddrQualifyRpcDTO;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrQualifyRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.param.OrgAddrRpcSaveParam;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.gson.Gson;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class BipCrmCustServiceImpl
extends BaseServiceImpl
implements BipCrmCustService {
    private static final Logger log = LoggerFactory.getLogger(BipCrmCustServiceImpl.class);
    private static final String REGISTER_ERROR_INFO = "\u5ba2\u6237\uff1a\u3010%s\u3011,\u624b\u673a\u53f7\uff1a\u3010%s\u3011,\u8d26\u6237\u521b\u5efa\u5931\u8d25,\u539f\u56e0\uff1a%s";
    private static final String REGISTER_DEFAULT_PWD = "123456";
    private final CrmCustRepo crmCustRepo;
    private final RmiOrgAddrService rmiOrgAddrService;
    private final RmiSysOauth2RpcService rmiSysOauth2RpcService;
    private final ComSaleFileInfoService comSaleFileInfoService;
    private final BipCustUserBindRepo bipCustUserBindRepo;
    private final BipCustUserBindRepoProc bipCustUserBindRepoProc;
    private final OrgEmpRpcService orgEmpRpcService;
    private final BipCompanyManageService bipCompanyManageService;

    public ApiResult<BipCrmCustInfoVO> searchInfoCurrent() {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        BipCustUserBindDO bipCustUserBindDO = null;
        if (currentUserDTO == null) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        if (Objects.nonNull(currentUserDTO.getUserId())) {
            bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
            if (bipCustUserBindDO == null) {
                return ApiResult.ok();
            }
        } else {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        Long custId = bipCustUserBindDO.getCustId();
        CrmCustDO custDO = (CrmCustDO)this.crmCustRepo.findById(custId).orElseThrow(() -> new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728"));
        log.info("\u8d26\u6237\u4fe1\u606f\u8bbe\u7f6ecustDO" + new Gson().toJson((Object)custDO));
        BipCrmCustInfoVO infoVO = CrmCustConvert.INSTANCE.doToBaseInfoVO(custDO);
        if (!StringUtils.isEmpty((Object)custDO.getAddrNo())) {
            ApiResult<OrgAddrDetailsRpcDTO> rpcDtoByAddrNo = this.rmiOrgAddrService.findAddrByAddrNo(custDO.getAddrNo());
            Assert.isFalse((!rpcDtoByAddrNo.isSuccess() ? 1 : 0) != 0, (String)rpcDtoByAddrNo.getMsg(), (Object[])new Object[0]);
            OrgAddrDetailsRpcDTO orgAddr = (OrgAddrDetailsRpcDTO)rpcDtoByAddrNo.getData();
            if (!ObjectUtils.isEmpty((Object)orgAddr) && !CollectionUtils.isEmpty((Collection)orgAddr.getOrgAddrQualifyVos())) {
                infoVO.setAddrId(orgAddr.getId());
                List qualifyFileNos = orgAddr.getOrgAddrQualifyVos().stream().map(OrgAddrQualifyRpcDTO::getQualifyNo).filter(Objects::nonNull).distinct().collect(Collectors.toList());
                List comSaleFileComVOS = this.comSaleFileInfoService.findFileByBusinessId("BIP_IMAGE", custDO.getId());
                log.info("\u8d26\u6237\u4fe1\u606f\u8bbe\u7f6ecomSaleFileComVOS" + comSaleFileComVOS);
                List custQualifyRespVOS = orgAddr.getOrgAddrQualifyVos().stream().map(qualify -> {
                    BipCustQualifyRespVO bipCustQualifyRespVO = CrmCustConvert.INSTANCE.qualifyRpcToBipAddrVo((OrgAddrQualifyRpcDTO)qualify);
                    if (!CollectionUtils.isEmpty((Collection)qualifyFileNos)) {
                        List pictures = comSaleFileComVOS.stream().filter(cust -> cust.getQualifyNo().equals(qualify.getQualifyNo())).collect(Collectors.toList());
                        log.info("\u8d26\u6237\u4fe1\u606f\u8bbe\u7f6epictures" + pictures);
                        bipCustQualifyRespVO.setEnclosure(pictures);
                    }
                    return bipCustQualifyRespVO;
                }).collect(Collectors.toList());
                infoVO.setQualifyList(custQualifyRespVOS);
            }
        }
        return ApiResult.ok((Object)infoVO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateCurrent(BipCrmCustSaveVO saveVO) {
        CrmCustDO custDO = this.currentCust();
        OrgAddrRpcSaveParam param = new OrgAddrRpcSaveParam();
        ArrayList filesWithId = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)saveVO.getQualifyList())) {
            param.setId(saveVO.getAddrId());
            param.setAddrNo(custDO.getAddrNo());
            param.setAddrName(custDO.getCustName());
            param.setAddrType(UdcEnum.ORG_ADDR_TYPE_CUST.getValueCode());
            List crmCustQualifySaveVOS = saveVO.getQualifyList();
            List addrQualifyRpcSaveParams = crmCustQualifySaveVOS.stream().map(qualify -> {
                OrgAddrQualifyRpcSaveParam orgAddrQualify = CrmCustConvert.INSTANCE.bipSaveVoToQualifyRpc((BipCustQualifySaveVO)qualify);
                orgAddrQualify.setQualifyFileId(qualify.getQualifyOuId());
                for (ComSaleFileComVO fileComVO : qualify.getEnclosure()) {
                    ComSaleFileComVO comSaleFileComVO = new ComSaleFileComVO();
                    comSaleFileComVO.setQualifyNo(qualify.getQualifyNo());
                    comSaleFileComVO.setFileCode(fileComVO.getFileCode());
                    comSaleFileComVO.setOriginalName(fileComVO.getOriginalName());
                    filesWithId.add(comSaleFileComVO);
                }
                return orgAddrQualify;
            }).collect(Collectors.toList());
            param.setOrgAddrQualifySaveParams(addrQualifyRpcSaveParams);
        }
        log.info("\u8d26\u6237\u4fe1\u606f\u4fee\u6539param" + new Gson().toJson((Object)param));
        ApiResult<Long> addrRes = this.rmiOrgAddrService.orgAddrSaveOrUpdate(param);
        this.alterDO(saveVO, custDO);
        log.info("\u8d26\u6237\u4fe1\u606f\u4fee\u6539userDO" + new Gson().toJson((Object)custDO));
        this.crmCustRepo.save(custDO);
        if (!CollectionUtils.isEmpty(filesWithId)) {
            filesWithId.forEach(k -> k.setBusinessId(saveVO.getId()));
            this.comSaleFileInfoService.comSaleFileHardSave("BIP_IMAGE", saveVO.getId(), filesWithId);
        }
    }

    private void alterDO(BipCrmCustSaveVO source, CrmCustDO target) {
        if (!StringUtils.isEmpty((Object)source.getCustCode())) {
            target.setCustCode(source.getCustCode());
        }
        if (!StringUtils.isEmpty((Object)source.getCustCode())) {
            target.setCustCode(source.getCustCode());
        }
        if (!StringUtils.isEmpty((Object)source.getInvAddress())) {
            target.setInvAddress(source.getInvAddress());
        }
        if (!StringUtils.isEmpty((Object)source.getInvTel())) {
            target.setInvTel(source.getInvTel());
        }
        if (!StringUtils.isEmpty((Object)source.getInvBankName())) {
            target.setInvBankName(source.getInvBankName());
        }
        if (!StringUtils.isEmpty((Object)source.getInvBankBranch())) {
            target.setInvBankBranch(source.getInvBankBranch());
        }
        if (!StringUtils.isEmpty((Object)source.getInvBankAcc())) {
            target.setInvBankAcc(source.getInvBankAcc());
        }
        if (!StringUtils.isEmpty((Object)source.getInvPicName())) {
            target.setInvPicName(source.getInvPicName());
        }
        if (!StringUtils.isEmpty((Object)source.getInvPicPhone())) {
            target.setInvPicPhone(source.getInvPicPhone());
        }
    }

    public String createUserAccount(List<Long> ids) {
        CurrentUserDTO currentUser = this.getCurrentUser();
        OrgUserEmpInfoRpcDTO userEmpInfo = this.orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f");
        }
        List manageByOuIds = this.bipCompanyManageService.findCompanyManageByOuIds(Arrays.asList(userEmpInfo.getOuId()));
        if (CollectionUtils.isEmpty((Collection)manageByOuIds)) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u516c\u53f8\u4fe1\u606f\u4e3a\u7a7a");
        }
        StringBuffer resultSB = new StringBuffer();
        Assert.isFalse((boolean)CollectionUtil.isEmpty(ids), (String)"[\u5ba2\u6237\u521b\u5efa\u8d26\u6237]\u64cd\u4f5c\u6570\u636e\u4e3a\u7a7a", (Object[])new Object[0]);
        List crmCustDOList = this.crmCustRepo.findAllById(ids);
        crmCustDOList.forEach(i -> {
            if (StringUtils.isEmpty((Object)i.getContactPhone()) && i.getIsCreatedAccount().booleanValue()) {
                resultSB.append(String.format(REGISTER_ERROR_INFO, i.getCustName(), "", "\u8d26\u6237\u4fe1\u606f\u5f02\u5e38:\u8d26\u6237\u767b\u9646\u624b\u673a\u53f7\u672a\u8bbe\u7f6e\uff0c\u4f46\u5df2\u6ce8\u518c\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\n"));
            } else if (StringUtils.isEmpty((Object)i.getContactPhone())) {
                resultSB.append(String.format(REGISTER_ERROR_INFO, i.getCustName(), "", "\u8d26\u6237\u767b\u9646\u624b\u673a\u53f7\u672a\u8bbe\u7f6e;\n"));
            } else if (i.getIsCreatedAccount().booleanValue()) {
                resultSB.append(String.format(REGISTER_ERROR_INFO, i.getCustName(), i.getContactPhone(), "\u8d26\u6237\u5df2\u6ce8\u518c;\n"));
            }
        });
        Assert.isTrue((boolean)StringUtils.isEmpty((Object)resultSB.toString()), (String)resultSB.toString(), (Object[])new Object[0]);
        List<BipCustUserBindDO> bipCustUserBindDOS = this.bipCustUserBindRepoProc.getAllByEmpIds(ids);
        bipCustUserBindDOS.forEach(i -> {
            if (Objects.nonNull(i.getUserId())) {
                crmCustDOList.stream().filter(c -> c.getId().equals(i.getCustId())).findAny().ifPresent(c -> resultSB.append(String.format(REGISTER_ERROR_INFO, c.getCustName(), c.getContactPhone(), "\u8d26\u6237\u7ed1\u5b9a\u4fe1\u606f\u5f02\u5e38:\u8d26\u6237\u5df2\u6ce8\u518c\u3002\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002\n")));
            }
        });
        Assert.isTrue((boolean)StringUtils.isEmpty((Object)resultSB.toString()), (String)resultSB.toString(), (Object[])new Object[0]);
        crmCustDOList.forEach(i -> {
            SysUserNewParam user = new SysUserNewParam();
            user.setMobile(i.getContactPhone());
            user.setUsername(i.getCustName());
            user.setEnabled(Boolean.valueOf(true));
            user.setOuId(i.getOuId());
            HashSet<Terminal> terminals = new HashSet<Terminal>(4);
            terminals.add(Terminal.APPLET);
            user.setTerminals(terminals);
            ApiResult<Long> longApiResult = this.rmiSysOauth2RpcService.sysUserCreate(user, REGISTER_DEFAULT_PWD);
            ApiResult<OrgAddrDetailsRpcDTO> orgAddrDetailsRpcDTOApiResult = this.rmiOrgAddrService.findAddrByAddrNo(i.getAddrNo());
            if (ApiCode.SUCCESS.getCode() == longApiResult.getCode() && ApiCode.SUCCESS.getCode() == orgAddrDetailsRpcDTOApiResult.getCode()) {
                DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
                transactionDefinition.setPropagationBehavior(3);
                TransactionStatus transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
                try {
                    String certFileCode = Optional.ofNullable((OrgAddrDetailsRpcDTO)orgAddrDetailsRpcDTOApiResult.getData()).map(o -> o.getOrgAddrQualifyVos()).flatMap(o -> o.stream().filter(q -> UdcEnum.ORG_ADDR_QUALIFY_TYPE_10.getValueCode().equals(q.getQualifyType())).findAny()).map(o -> o.getQualifyFileCode()).orElse(null);
                    BipCustUserBindDO bipCustUserBindDO = bipCustUserBindDOS.stream().filter(b -> i.getId().equals(b.getCustId())).findAny().orElse(new BipCustUserBindDO());
                    bipCustUserBindDO.setSecOuId(userEmpInfo.getOuId());
                    bipCustUserBindDO.setSecUserId(userEmpInfo.getUserId());
                    bipCustUserBindDO.setSecBuId(((BipCompanyManageRespVO)manageByOuIds.get(0)).getBuId());
                    bipCustUserBindDO.setUserId((Long)longApiResult.getData());
                    bipCustUserBindDO.setUsername(i.getCustName());
                    bipCustUserBindDO.setCustId(i.getId());
                    bipCustUserBindDO.setCustCode(i.getCustCode());
                    bipCustUserBindDO.setCustName(i.getCustName());
                    bipCustUserBindDO.setOuId(i.getOuId());
                    bipCustUserBindDO.setTaxRegNo(i.getTaxRegNo());
                    bipCustUserBindDO.setCertFileCode(certFileCode);
                    bipCustUserBindDO.setContactName(i.getContactName());
                    bipCustUserBindDO.setContactPhone(i.getContactPhone());
                    bipCustUserBindDO.setState(UdcEnum.BIP_CUST_USER_STATE_ACTIVE.getValueCode());
                    bipCustUserBindDO.setStateApply(UdcEnum.BIP_CUST_USER_APPLY_PASSED.getValueCode());
                    bipCustUserBindDO.setTimeRegister(LocalDateTime.now());
                    bipCustUserBindDO.setTimeApply(LocalDateTime.now());
                    bipCustUserBindDO.setAgentEmpId(currentUser.getUserId());
                    this.bipCustUserBindRepo.save(bipCustUserBindDO);
                    i.setIsCreatedAccount(true);
                    this.crmCustRepo.save(i);
                    this.transactionManager.commit(transactionStatus);
                }
                catch (Exception e) {
                    log.error("\u5ba2\u6237\u4fe1\u606f-\u521b\u5efa\u5ba2\u6237\u767b\u9646\u8d26\u6237\u5f02\u5e38\uff1a{}", (Throwable)e);
                    this.transactionManager.rollback(transactionStatus);
                }
            } else if (ApiCode.SUCCESS.getCode() == longApiResult.getCode() && ApiCode.SUCCESS.getCode() != orgAddrDetailsRpcDTOApiResult.getCode()) {
                resultSB.append(String.format(REGISTER_ERROR_INFO, i.getCustName(), i.getContactPhone(), orgAddrDetailsRpcDTOApiResult.getMsg()));
            } else if (ApiCode.SUCCESS.getCode() != longApiResult.getCode() && ApiCode.SUCCESS.getCode() == orgAddrDetailsRpcDTOApiResult.getCode()) {
                resultSB.append(String.format(REGISTER_ERROR_INFO, i.getCustName(), i.getContactPhone(), longApiResult.getMsg()));
            } else {
                resultSB.append(String.format(REGISTER_ERROR_INFO, i.getCustName(), i.getContactPhone(), longApiResult.getMsg() + "|" + orgAddrDetailsRpcDTOApiResult.getMsg()));
            }
        });
        return resultSB.toString();
    }

    private CurrentUserDTO getCurrentUser() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5f53\u524d\u7528\u6237\u5df2\u5931\u6548,\u8bf7\u91cd\u767b\u5f55\u91cd\u8bd5");
        }
        return currentUser;
    }

    private CrmCustDO currentCust() {
        CurrentUserDTO currentUserDTO = UserService.currentUser();
        BipCustUserBindDO bipCustUserBindDO = null;
        if (currentUserDTO == null) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        if (!Objects.nonNull(currentUserDTO.getUserId())) {
            throw new BusinessException("\u8bf7\u5148\u767b\u5f55!");
        }
        bipCustUserBindDO = this.bipCustUserBindRepoProc.getByUserId(currentUserDTO.getUserId());
        if (bipCustUserBindDO == null) {
            throw new BusinessException("\u8bf7\u7ed1\u5b9a\u516c\u53f8\u4fe1\u606f!");
        }
        Long custId = bipCustUserBindDO.getCustId();
        return (CrmCustDO)this.crmCustRepo.findById(custId).orElseThrow(() -> new BusinessException(ApiCode.BUSINESS_EXCEPTION, "\u5ba2\u6237\u4fe1\u606f\u4e0d\u5b58\u5728"));
    }

    public BipCrmCustServiceImpl(CrmCustRepo crmCustRepo, RmiOrgAddrService rmiOrgAddrService, RmiSysOauth2RpcService rmiSysOauth2RpcService, ComSaleFileInfoService comSaleFileInfoService, BipCustUserBindRepo bipCustUserBindRepo, BipCustUserBindRepoProc bipCustUserBindRepoProc, OrgEmpRpcService orgEmpRpcService, BipCompanyManageService bipCompanyManageService) {
        this.crmCustRepo = crmCustRepo;
        this.rmiOrgAddrService = rmiOrgAddrService;
        this.rmiSysOauth2RpcService = rmiSysOauth2RpcService;
        this.comSaleFileInfoService = comSaleFileInfoService;
        this.bipCustUserBindRepo = bipCustUserBindRepo;
        this.bipCustUserBindRepoProc = bipCustUserBindRepoProc;
        this.orgEmpRpcService = orgEmpRpcService;
        this.bipCompanyManageService = bipCompanyManageService;
    }
}

