/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.yst.production.sale.task.delay;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.core.task.delay.DelayTaskHandler;
import com.elitescloud.cloudt.core.task.delay.TaskInfo;
import com.elitesland.yst.production.sale.api.service.shop.BipOrderService;
import com.elitesland.yst.production.sale.api.vo.save.shop.BipOrderSaveVO;
import com.elitesland.yst.production.sale.entity.BipOrderDO;
import com.elitesland.yst.production.sale.repo.shop.BipOrderRepo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BipOrderCancleTask
implements DelayTaskHandler<Long> {
    private static final Logger log = LoggerFactory.getLogger(BipOrderCancleTask.class);
    public static final String TASK_TYPE = "bip_order_cancle";
    private final BipOrderService bipOrderService;
    @Autowired
    private BipOrderRepo bipOrderRepo;

    public BipOrderCancleTask(BipOrderService bipOrderService) {
        this.bipOrderService = bipOrderService;
    }

    public String[] supportType() {
        return new String[]{TASK_TYPE};
    }

    public boolean execute(TaskInfo<Long> taskInfo) {
        Long orderId = (Long)taskInfo.getPayload();
        log.info("\u8ba2\u5355\u53d6\u6d88--\u8ba2\u5355id", (Object)orderId);
        BipOrderSaveVO bipOrderSaveVO = new BipOrderSaveVO();
        bipOrderSaveVO.setId(orderId);
        bipOrderSaveVO.setStatus("cancelled");
        BipOrderDO bipOrderDO = (BipOrderDO)this.bipOrderRepo.findById(orderId).get();
        if ("unpaid".equals(bipOrderDO.getStatus())) {
            log.info("\u8ba2\u5355\u4fe1\u606f--" + JSON.toJSONString((Object)bipOrderDO));
            this.bipOrderService.cancleOrder(bipOrderSaveVO);
            log.info("\u8ba2\u5355\u53d6\u6d88\u6210\u529f");
        }
        log.info("\u8ba2\u5355\u53d6\u6d88\u6210\u529f");
        return true;
    }
}

