package com.elitesland.yst.production.sale.controller.sal;

import com.elitesland.yst.production.sale.api.service.SalPayDepositService;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalPayDepositApproveParamVO;
import com.elitesland.yst.production.sale.api.vo.param.sal.SalPayDepositParamVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalPayDepositRespVO;
import com.elitesland.yst.production.sale.api.vo.resp.sal.SalPayDepositReturnRespVO;
import com.elitesland.yst.production.sale.controller.BaseController;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2021/7/16 14:13
 */
@RestController
@RequestMapping(value = "/sal/payDeposit", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "支付押金")
@Slf4j
public class SalPayDepositController extends BaseController {

    @Autowired
    private SalPayDepositService salPayDepositService;

    @PostMapping(value = "/search")
    @ApiOperation(value = "分页查询支付押金")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<SalPayDepositRespVO>> search(@RequestBody SalPayDepositParamVO searchParam) {
        return ApiResult.ok(salPayDepositService.search(searchParam));
    }

    @GetMapping(value = "/get/{id}")
    @ApiOperation(value = "查询支付押金单明细信息")
    @ApiOperationSupport(order = 2)
    public ApiResult<SalPayDepositRespVO> getSalPayDepositById(@PathVariable Long id) {
        return ApiResult.ok(salPayDepositService.findSalPayDepositById(id));
    }

    @PostMapping(value = "/save")
    @ApiOperation(value = "保存支付押金单信息")
    @ApiOperationSupport(order = 3)
    public ApiResult<Long> createSalPayDeposit(@RequestBody SalPayDepositRespVO salPayDepositRespVO) {
            return ApiResult.ok(salPayDepositService.createSalPayDeposit(salPayDepositRespVO));
    }

    @PostMapping(value = "/approve")
    @ApiOperation(value = "审批支付押金")
    @ApiOperationSupport(order = 4)
    public ApiResult<Long> approveSalQuotation(@RequestBody SalPayDepositApproveParamVO salPayDepositApproveParamVO) {
        return ApiResult.ok(salPayDepositService.approveSalPayDeposit(salPayDepositApproveParamVO));
    }

    @PostMapping(value = "/submit")
    @ApiOperation(value = "提交支付押金单信息")
    @ApiOperationSupport(order = 5)
    public ApiResult<Long> submitSalPayDeposit(@RequestBody SalPayDepositRespVO salPayDepositRespVO) {
            return ApiResult.ok(salPayDepositService.submitSalPayDeposit(salPayDepositRespVO));
    }

    @GetMapping(value = "/delete/{id}")
    @ApiOperation(value = "删除支付押金")
    @ApiOperationSupport(order = 6)
    public ApiResult<Long> deleteSalQuotation(@PathVariable Long id) {
            return ApiResult.ok(salPayDepositService.deleteSalPayDeposit(id));
    }

    @GetMapping(value = "/refund/queryAll/{docNo}")
    @ApiOperation(value = "根据支付押金单查询支付押金退款单")
    @ApiOperationSupport(order = 7)
    public ApiResult<PagingVO<SalPayDepositReturnRespVO>> findRefundByPayDepositDocNo(@PathVariable String docNo) {
        return ApiResult.ok(salPayDepositService.findRefundByPayDepositDocNo(docNo));
    }

    @PostMapping(value = "/refund/save")
    @ApiOperation(value = "支付押金退款单保存")
    @ApiOperationSupport(order = 8)
    public ApiResult<Long> refundSalQuotationSave(@RequestBody SalPayDepositReturnRespVO salPayDepositReturnRespVO) {
        return ApiResult.ok(salPayDepositService.refundSalQuotationSave(salPayDepositReturnRespVO));
    }

    @PostMapping(value = "/refund/submit")
    @ApiOperation(value = "支付押金退款单提交")
    @ApiOperationSupport(order = 9)
    public ApiResult<Long> refundSalQuotationSubmit(@RequestBody SalPayDepositReturnRespVO salPayDepositReturnRespVO) {
        return ApiResult.ok(salPayDepositService.refundSalQuotationSubmit(salPayDepositReturnRespVO));
    }


    @PostMapping(value = "/refund/approve")
    @ApiOperation(value = "支付押金退款单批准")
    @ApiOperationSupport(order = 10)
    public ApiResult<Long> refundSalQuotationApprove(@RequestBody SalPayDepositApproveParamVO salPayDepositApproveParamVO) {
        return ApiResult.ok(salPayDepositService.refundSalQuotationApprove(salPayDepositApproveParamVO));
    }

    @PostMapping(value = "/refund/refuse")
    @ApiOperation(value = "支付押金退款单拒绝")
    @ApiOperationSupport(order = 11)
    public ApiResult<Long> refundSalQuotationRefuse(@RequestBody SalPayDepositApproveParamVO salPayDepositApproveParamVO) {
        return ApiResult.ok(salPayDepositService.refundSalQuotationRefuse(salPayDepositApproveParamVO));
    }
    @GetMapping(value = "/refund/queryById/{id}")
    @ApiOperation(value = "根据id查询支付押金退款单")
    @ApiOperationSupport(order = 12)
    public ApiResult<SalPayDepositReturnRespVO> refundSalQuotationQueryById(@PathVariable Long id) {
        return ApiResult.ok(salPayDepositService.refundSalQuotationQueryById(id));
    }

}
