package com.elitesland.yst.production.sale.controller.shop;


import com.elitesland.yst.production.sale.api.service.FirstSpecialItemService;
import com.elitesland.yst.production.sale.api.service.shop.BipItemAppService;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateSaveParam;
import com.elitesland.yst.production.sale.api.vo.param.shop.BipCouponQueryParamVO;
import com.elitesland.yst.production.sale.api.vo.param.special.*;
import com.elitesland.yst.production.sale.api.vo.resp.shop.BipCouponVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.FirstSpecialItemVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.FirstSpecialVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.val;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 首单特惠
 * </p>
 *
 * @author Shadow
 * @since 2021-08-11 09:45:54
 */
@RestController
@RequestMapping("/bip/firstspecial")
@Api(value = "首单特惠", tags = {"首单特惠"})
@RequiredArgsConstructor
public class FirstSpecialItemController {

    private final FirstSpecialItemService firstSpecialItemService;

    private final BipItemAppService bipItemAppService;

    /**
     * 分页查询
     *
     * @param param 分类查询、分页和排序对象
     * @return 多条数据
     */
    @PostMapping("/search")
    @ApiOperation("分页查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "param", value = "分页查询参数", required = true, dataType = "FirstSpecialItemQueryParam")
    })
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<FirstSpecialVO>> search(@RequestBody FirstSpecialItemQueryParam param) {
        PagingVO<FirstSpecialVO> ret = firstSpecialItemService.searchAll(param);
        return ApiResult.ok(ret);
    }

    /**
     * 查全部不分页
     *
     * @return 多条数据
     */
    @PostMapping(value = "/searchList")
    @ApiOperation(value = "查全部不分页")
    @ApiOperationSupport(order = 2)
    public ApiResult<List<FirstSpecialItemVO>> searchlist() {
        List<FirstSpecialItemVO> ret = firstSpecialItemService.searchList();
        return ApiResult.ok(ret);
    }


    @PostMapping(value = "/save")
    @ApiOperation(value = "保存")
    @ApiOperationSupport(order = 3)
    public ApiResult<Object> save(@RequestBody FirstSpecialItemSaveParam param) {
        return firstSpecialItemService.save(param);
    }


    @PutMapping(value = "/del")
    @ApiOperation(value = "删除")
    @ApiOperationSupport(order = 4)
    public ApiResult<Object> del(@RequestBody List<Long> ids) {
        return ApiResult.ok(firstSpecialItemService.del(ids));
    }

    @PostMapping(value = "/closeOrActive")
    @ApiOperation(value = "禁用CLOSED/激活ACTIVE")
    @ApiOperationSupport(order = 4)
    public ApiResult<Object> closeOrActive(@RequestBody FirstSpecialStatusParam param) {
        return ApiResult.ok(firstSpecialItemService.closeOrActive(param));
    }

    /**
     * 小程序显示的首单特惠内容
     *
     * @return 多条数据
     */
    @PostMapping(value = "/searchAppFirstSpecial")
    @ApiOperation(value = "小程序显示的首单特惠内容")
    @ApiOperationSupport(order = 2)
    public ApiResult<PagingVO<FirstSpecialItemAppVO>> searchAppFirstSpecial(@RequestBody FirstSpecialItemAppParam param) {
        PagingVO<FirstSpecialItemAppVO> ret = firstSpecialItemService.searchAppFirstSpecial(param);
        return ApiResult.ok(ret);
    }

    /**
     * 主表ID查询明细
     *
     * @return 多条数据
     */
    @GetMapping(value = "/findItemList/{specialId}")
    @ApiOperation(value = "主表ID查询明细")
    @ApiOperationSupport(order = 2)
    public ApiResult<FirstSpecialItemSaveParam> getItemList(@PathVariable Long specialId) {
        FirstSpecialItemSaveParam ret = firstSpecialItemService.getItemList(specialId);
        return ApiResult.ok(ret);
    }

    /**
     * 是否首单商品
     */

    @PostMapping(value = "/isAddShop")
    @ApiOperation(value = "查询首单商品是否能加入购物车")
    @ApiOperationSupport(order = 2)
    public ApiResult<Boolean> isAddShop(@RequestBody FirstIsAddShopParam param) {
        boolean ret = firstSpecialItemService.isAddShop(param);
        return ApiResult.ok(ret);
    }


}
