package com.elitesland.yst.production.sale.controller.zone;

import com.elitesland.yst.production.sale.api.service.ZoneSettingDService;
import com.elitesland.yst.production.sale.api.vo.param.zone.ZoneSettingDetailPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingDVO;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingSaveDVO;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping(value = "/zonedetail/conf", produces = MediaType.APPLICATION_JSON_VALUE)
@Api(tags = "专区明细")
@RequiredArgsConstructor
public class ZoneSettingDetailController {

    private final ZoneSettingDService zoneSettingDService;

    @PostMapping(value = "/findPagingResult")
    @ApiOperation(value = "专区明细列表")
    @ApiOperationSupport(order = 1)
    public ApiResult<PagingVO<ZoneSettingDVO>> findPagingResult(@RequestBody ZoneSettingDetailPageParam param){
        PagingVO<ZoneSettingDVO> list = zoneSettingDService.findPagingResult(param);
        return ApiResult.ok(list);
    }

    @PostMapping(value = "/addZoneDetail")
    @ApiOperation(value = "新增专区商品")
    @ApiOperationSupport(order = 2)
    public ApiResult<Object> addZoneDetail(@RequestBody List<ZoneSettingSaveDVO> param){
        return zoneSettingDService.addZoneDetail(param);
    }

    @PostMapping(value = "/delZoneDetail")
    @ApiOperation(value = "删除专区商品")
    @ApiOperationSupport(order = 2)
    public ApiResult<Object> delZoneDetail(@RequestBody List<Long> ids){
        return zoneSettingDService.delZoneDetail(ids);
    }

    @GetMapping(value = "/updateItemState/{itemId}/{ouId}/{state}")
    @ApiOperation(value = "商品上架时候调用，修改对应的专区商品和菜单商品的商品状态")
    @ApiOperationSupport(order = 2)
    public ApiResult<Object> updateItemState(@PathVariable Long itemId,@PathVariable Long ouId,@PathVariable String state){
        return zoneSettingDService.updateItemState(itemId,ouId,state);
    }

}
