package com.elitesland.yst.production.sale.convert.shop;

import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountOffsetDSaveVO;
import com.elitesland.yst.production.sale.api.vo.param.shop.MktDiscountOffsetSaveVO;
import com.elitesland.yst.production.sale.api.vo.resp.shop.MktDiscountOffsetRespVO;
import com.elitesland.yst.production.sale.core.mapstruct.CustomMapperConfig;
import com.elitesland.yst.production.sale.entity.MktDiscountOffsetDDO;
import com.elitesland.yst.production.sale.entity.MktDiscountOffsetDO;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 * <p>
 * 满减促销对象转换类
 * </p>
 *
 * @author ssy
 * @since 2021/8/18
 */
@Mapper(config = CustomMapperConfig.class)
public interface MktDiscountOffsetConvert {

    MktDiscountOffsetConvert INSTANCE = Mappers.getMapper(MktDiscountOffsetConvert.class);

    /**
     * doToVo
     *
     * @param mktDiscountOffsetDO 满减促销对象主表do
     * @return 满减促销对象主表Vo
     */
    MktDiscountOffsetRespVO doToVo(MktDiscountOffsetDO mktDiscountOffsetDO);

    /**
     * saveVoTodo(主表转换)
     *
     * @param mktDiscountOffsetSaveVO 满减促销保存对象主表vo
     * @return 满减促销对象主表do
     */
    MktDiscountOffsetDO saveVoToDo(MktDiscountOffsetSaveVO mktDiscountOffsetSaveVO);

    /**
     * dsaveVoToDo(明细表转换)
     *
     * @param mktDiscountOffsetSaveDVO 满减促销保存对象明细表vo
     * @return 满减促销对象明细表do
     */
    MktDiscountOffsetDDO dsaveVoToDo(MktDiscountOffsetDSaveVO mktDiscountOffsetSaveDVO);
}
