package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/15:51
 * @Description:
 */

@Entity
@Table(name = "bip_address")
@org.hibernate.annotations.Table(appliesTo = "bip_address", comment = "收货地址")
@Data
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
public class BipAddressDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -1892116624581771386L;

    @Column(name = "name", columnDefinition = "varchar(1024) comment '收货人姓名'")
    private String name;


    @Column(name = "tel", columnDefinition = "varchar(20) comment '收货人联系电话'")
    private String tel;

    @Column(name = "cust_account_id", columnDefinition = "bigInt(20) comment '收货人账户id'")
    private Long custAccountId;

    @Column(name = "is_default", columnDefinition = "bigInt(20) comment '是否默认'")
    private Integer isDefault;

    @Column(name = "pcode", columnDefinition = "varchar(20) comment '发货地省编码'")
    private String pcode;

    @Column(name = "ccode", columnDefinition = "varchar(20) comment '发货地市编码'")
    private String ccode;

    @Column(name = "acode", columnDefinition = "varchar(20) comment '发货地区（县）编码'")
    private String acode;


    @Column(name = "scode", columnDefinition = "varchar(20) comment '发货地区乡编码'")
    private String scode;


    @Column(name = "detai", columnDefinition = "varchar(1024) comment '详细地址'")
    private String detai;

    @Column(name = "area", columnDefinition = "varchar(1024) comment '地区'")
    private String area;
}
