package com.elitesland.yst.production.sale.entity;

import com.elitesland.yst.production.sale.core.convert.BigDecimalConvert;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * Created with IntelliJ IDEA.
 *
 * @Author: wang yinghao
 * @Date: 2021/08/04/16:52
 * @Description:
 */

@Entity
@Table(name = "bip_order_d", indexes = {
        @Index(name = "idx_bip_order_d_item_id", columnList = "item_id"),
        @Index(name = "idx_bip_order_d_pay_time", columnList = "pay_time"),
})
@org.hibernate.annotations.Table(appliesTo = "bip_order_d", comment = "订单表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class BipOrderDDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -8903727818938029276L;

    @Column(name = "p_id", columnDefinition = "bigInt(20) comment '明细单的父id--赠品订单此字段不能为空'")
    private Long pid;

    @Column(name = "item_type", columnDefinition = "varchar(32) comment '商品类型 [UDC]ITM：ITEM_TYPE'")
    private String itemType;

    @Column(name = "ou_id", columnDefinition = "bigInt(20) comment '公司id'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(32) comment '公司编码'")
    private String ouCode;


    @Column(name = "ou_name", columnDefinition = "varchar(32) comment '公司名称'")
    private String ouName;

    @Column(name = "bu_id", columnDefinition = "bigInt(20) comment '组织id'")
    private Long buId;

    @Column(name = "bu_code", columnDefinition = "varchar(32) comment '组织编码'")
    private String buCode;


    @Column(name = "bu_name", columnDefinition = "varchar(20) comment '组织名称'")
    private String buName;

    @Column(name = "order_id", columnDefinition = "bigInt(20) comment '订单主表id'")
    private Long orderId;

    @Column(name = "line_no", columnDefinition = "int(10) default null  comment '行号'")
    private Integer lineNo;

    @Column(name = "order_doc_no", columnDefinition = "varchar(32) comment '订单主表单号'")
    private String orderDocNo;

    @Column(name = "item_id", columnDefinition = "bigInt(20) comment '商品id'")
    private Long itemId;
    @Column(name = "sku_id", columnDefinition = "bigInt(20) comment '商品sku id'")
    private Long skuId;

    @Column(name = "sku_code", columnDefinition = "varchar(32) comment '商品sku编码'")
    private String skuCode;

    @Column(name = "relate_item_id", columnDefinition = "bigInt(20) comment '关联商品中心的商品ID'")
    private Long relateItemId;


    @Column(name = "cust_account_id", columnDefinition = "bigInt(20) comment '账户id'")
    private Long custAccountId;

    @Column(name = "item_pic_file_code", columnDefinition = "bigInt(32) comment '商品图片id'")
    private String itemPicFileCode;

    @Column(name = "item_code", columnDefinition = "varchar(32) comment '商品编码'")
    private String itemCode;


    @Column(name = "item_name", columnDefinition = "varchar(255) comment '商品名称'")
    private String itemName;

    @Column(name = "item_title", columnDefinition = "varchar(1024) comment '商品标题'")
    private String itemTitle;

    @Column(name = "item_brand_id", columnDefinition = "bigInt(20) comment '商品品牌id'")
    private Long itmeBrandID;

    @Column(name = "item_brand_code", columnDefinition = "varchar(64) comment '商品品牌编码'")
    private String itmeBrandCode;

    @Column(name = "item_brand", columnDefinition = "varchar(64) comment '商品品牌名称'")
    private String itemBrand;


    @Column(name = "free_fare", columnDefinition = "tinyint(1) default 0  comment '是否免运费'")
    private Boolean freeFare;


    @Column(name = "base_price", columnDefinition = "decimal(20,2) default 0 comment '基本价格'")
    private BigDecimal basePrice;

    @Column(name = "cust_Price", columnDefinition = "decimal(20,2) default 0 comment '客户价格'")
    private BigDecimal custPrice;

    @Column(name = "coupon_amt", columnDefinition = "decimal(20,2) default 0 comment '优惠券金额'")
    private BigDecimal couponAmt;

    @Column(name = "discount_amt", columnDefinition = "decimal(20,2) default 0 comment '折扣金额'")
    private BigDecimal discountAmt;

    @Column(name = "pay_online_amt", columnDefinition = "decimal(20,2) default 0 comment '线上支付金额'")
    private BigDecimal payOnlineAmt;

    @Column(name = "item_amt", columnDefinition = "decimal(20,2) default 0 comment '商品金额'")
    private BigDecimal itemAmt;

    @Column(name = "buy_amt", columnDefinition = "decimal(20,2) default 0 comment '购买时价格 单价'")
    private BigDecimal buyAmt;

    @Column(name = "buy_qty", columnDefinition = "bigInt(20) comment '商品数量'")
    private Long buyQty;

    @Column(name = "fare_tmpl_id", columnDefinition = "bigInt(20) comment '运费模板id'")
    private Long fareTmplId;


    @Column(name = "fare_amt", columnDefinition = "decimal(20,2) default 0 comment '运费'")
    private BigDecimal fareAmt;

    @Column(name = "pay_amt", columnDefinition = "decimal(20,2) default 0 comment '应付金额'")
    private BigDecimal payAmt;

    @Column(name = "pay_done_amt", columnDefinition = "decimal(20,2) default 0 comment '已付金额'")
    private BigDecimal payDoneAmt;

    @Column(name = "pay_time", columnDefinition = "datetime comment '支付时间'")
    private LocalDateTime payTime;

    @Column(name = "uom", columnDefinition = "varchar(32) comment '商品计量单位'")
    private String uom;
    @Column(name = "item_spec", columnDefinition = "varchar(255) default null  comment '商品规格'")
    private String itemSpec;

    @Column(name = "allow_back_num", columnDefinition = "bigInt(20) comment '允许退货数量'")
    private Long allowBackNum;

    @Column(name = "status", columnDefinition = "varchar(32) comment '订单状态'")
    private String status;

    @Column(name = "logis_id", columnDefinition = "bigInt(20) comment '发货单ID'")
    private Long logisId;

    @Column(name = "logis_no", columnDefinition = "varchar(32) comment '物流单号'")
    private String logisNo;

    //zhao.zhi.hao 2021.09.23
    @Column(name = "inv_serial_num", columnDefinition = "varchar(32) comment '发票流水号'")
    private String invSerialNum;


    @Column(name = "coupon_id", columnDefinition = "varchar(1024) comment '优惠券id'")
    private String couponId;
    @Column(name = "coupon_code", columnDefinition = "varchar(32) comment '优惠券编码'")
    private String couponCode;

    @Column(name = "materiel", columnDefinition = "varchar(512) default '' comment '物料类型'")
    private String materiel;

    @Column(name = "type", columnDefinition = "varchar(512) default '' comment '商品类型'")
    private String type;

    @Column(name = "discountOffset_id", columnDefinition = "bigInt(20) comment '满减折扣id'")
    private Long discountOffsetId;
    @Column(name = "discountOffset_code", columnDefinition = "varchar(32) comment '满减折扣编码'")
    private String discountOffsetCode;

    @Column(name = "discountOffset_d_id", columnDefinition = "bigInt(20) comment '满减折扣明细id'")
    private Long discountOffsetDId;

    @Column(name = "gift_codes", columnDefinition = "varchar(1024) comment '赠品编码'")
    private String giftCodes;

}
