package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;
import org.springframework.data.jpa.repository.config.EnableJpaAuditing;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * <p>
 *
 * </p>
 *
 * @author zhao.zhi.hao
 * @since 2023/2/21 18:29
 */
@Entity
@Table(name = "de_role_view", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "de_role_view", comment = "角色权限关联表")
@EnableJpaAuditing
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class DeRolePurViewDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 5712143279179568581L;

    @ApiModelProperty("角色编码")
    @Column(name = "role_code", columnDefinition = "varchar(64)   comment '角色编码'")
    private String roleCode;

    @ApiModelProperty("权限编码")
    @Column(name = "purview_code", columnDefinition = "varchar(64)   comment '权限编码'")
    private String purviewCode;
}
