package com.elitesland.yst.production.sale.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 赠品表
 * </p>
 *
 * @author ssy
 * @since 2021/8/23
 */
@Entity
@Table(name = "mkt_gift")
@org.hibernate.annotations.Table(appliesTo = "mkt_gift", comment = "赠品表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class MktGiftDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = -1005716393159568575L;

    @Column(name = "discount_gift_code", columnDefinition = "varchar(20)  comment '折扣编码'")
    private String discountGiftCode;

    @Column(name = "discount_gift_item_id", columnDefinition = "bigInt(20)   comment '买赠明细商品id'")
    private Long discountGiftItemId;

    @Column(name = "item_id", columnDefinition = "bigInt(20)   comment '商品id'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(40)   comment '商品code'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(255)   comment '商品名称'")
    private String itemName;

    @Column(name = "stock_num", columnDefinition = "bigInt(20)   comment '库存量'")
    private Long stockNum;

    @Column(name = "valid_stime", columnDefinition = "datetime   comment '生效时间'")
    private LocalDateTime validStime;

    @Column(name = "valid_etime", columnDefinition = "datetime   comment '失效时间'")
    private LocalDateTime validEtime;

    @Column(name = "sku_code", columnDefinition = "varchar(40)   comment '商品sku编码'")
    private String skuCode;

    @Column(name = "sku_name", columnDefinition = "varchar(255)   comment '商品sku名称'")
    private String skuName;

    @Column(name = "materiel", columnDefinition = "varchar(40)   comment '物料类型'")
    private String materiel;

    @Column(name = "type", columnDefinition = "varchar(40)   comment '商品类型'")
    private String type;

    @Column(name = "stock_now_num", columnDefinition = "bigInt(20)   comment '当前库存量'")
    private Long stockNowNum;
}
