package com.elitesland.yst.production.sale.entity;

import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 销售支持中心 - 销售价格变更表
 *
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/5/19 9:44 上午
 */
@Entity
@Table(name = "pri_sale_price_alter", indexes = {
        @Index(name = "idx_doc_no", columnList = "doc_no")
})
@org.hibernate.annotations.Table(appliesTo = "pri_sale_price_alter", comment = "销售价格变更表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0 or delete_flag is null")
public class PriSalePriceAlterDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = -3180455415341382352L;

    @ApiModelProperty(value = "BUID")
    @Column(name = "bu_id", columnDefinition = "bigint(20) default null  comment 'BUID'")
    private Long buId;

    @ApiModelProperty(value = "公司ID")
    @Column(name = "ou_id", columnDefinition = "bigint(20) default null  comment '公司ID'")
    private Long ouId;

    @ApiModelProperty(value = "申请单号")
    @Column(name = "doc_no", columnDefinition = "varchar(40) default null  comment '申请单号'")
    private String docNo;

    @ApiModelProperty(value = "单据类型")
    @Column(name = "doc_type", columnDefinition = "varchar(40) default null  comment '单据类型 [UDC]PRI:SALE_APPLY_TYPE'")
    private String docType;

    @ApiModelProperty(value = "单据类型2")
    @Column(name = "doc_type2", columnDefinition = "varchar(40) default null  comment '单据类型2'")
    private String docType2;

    @ApiModelProperty(value = "单据状态")
    @Column(name = "doc_status", columnDefinition = "varchar(40) default null comment '单据状态 [UDC]PRI:SALE_APPLY_STATUS'")
    private String docStatus;

    @ApiModelProperty(value = "申请人ID")
    @Column(name = "apply_emp_id", columnDefinition = "bigint(20) default null comment '申请人ID'")
    private Long applyEmpId;

    @ApiModelProperty(value = "申请日期")
    @Column(name = "apply_date", columnDefinition = "datetime comment '申请日期'")
    private LocalDateTime applyDate;

    @ApiModelProperty("申请描述")
    @Column(name = "apply_desc", columnDefinition = "varchar(100) comment '申请描述'")
    private String applyDesc;

//    @ApiModelProperty("审批状态")
//    @Column(name = "appr_status", columnDefinition = "varchar(40) comment '审批状态 [UDC]COM:APPR_STATUS'")
//    private String apprStatus;

//    @ApiModelProperty("审批时间")
//    @Column(name = "appr_time", columnDefinition = "datetime comment '审批时间'")
//    private LocalDateTime apprTime;

    @ApiModelProperty("审批人ID")
    @Column(name = "appr_user_id", columnDefinition = "bigint(20) comment '审批人ID'")
    private Long apprUserId;

//    @ApiModelProperty("审批意见")
//    @Column(name = "appr_comment", columnDefinition = "varchar(200) comment '审批意见'")
//    private String apprComment;

    @ApiModelProperty("仓库ID")
    @Column(name = "wh_id", columnDefinition = "bigint(20) comment '仓库ID'")
    private Long whId;

    @ApiModelProperty("限定1")
    @Column(name = "deter1", columnDefinition = "varchar(40) comment '限定1'")
    private String deter1;

    @ApiModelProperty("限定2")
    @Column(name = "deter2", columnDefinition = "varchar(40) comment '限定2'")
    private String deter2;

    @ApiModelProperty("限定3")
    @Column(name = "deter3", columnDefinition = "varchar(40) comment '限定3'")
    private String deter3;

    @ApiModelProperty("限定4")
    @Column(name = "deter4", columnDefinition = "varchar(40) comment '限定4'")
    private String deter4;

    @ApiModelProperty("限定5")
    @Column(name = "deter5", columnDefinition = "varchar(40) comment '限定5'")
    private String deter5;

    @ApiModelProperty("限定6")
    @Column(name = "deter6", columnDefinition = "varchar(40) comment '限定6'")
    private String deter6;

    @ApiModelProperty("限定7")
    @Column(name = "deter7", columnDefinition = "varchar(40) comment '限定7'")
    private String deter7;

    @ApiModelProperty("限定8")
    @Column(name = "deter8", columnDefinition = "varchar(40) comment '限定8'")
    private String deter8;

    @ApiModelProperty("库位")
    @Column(name = "wh_loc", columnDefinition = "varchar(40) comment '库位'")
    private String whLoc;

    @ApiModelProperty("货位")
    @Column(name = "wh_posi", columnDefinition = "varchar(40) comment '货位'")
    private String whPosi;

    @ApiModelProperty("批号")
    @Column(name = "lot_no", columnDefinition = "varchar(100) comment '批号'")
    private String lotNo;

    @ApiModelProperty("销售区域")
    @Column(name = "sale_region", columnDefinition = "varchar(40) comment '销售区域 [UDC]ORG:OU_REGION'")
    private String saleRegion;

    @ApiModelProperty("客户组(客户等级)")
    @Column(name = "cust_group", columnDefinition = "varchar(40) comment '客户组(客户等级) [UDC]CRM:CUST_GROUP'")
    private String custGroup;

    @ApiModelProperty("客户组2")
    @Column(name = "cust_group2", columnDefinition = "varchar(40) comment '客户组2 [UDC]CRM:CUST_GROUP'")
    private String custGroup2;

    @ApiModelProperty("客户组3")
    @Column(name = "cust_group3", columnDefinition = "varchar(40) comment '客户组3 [UDC]CRM:CUST_GROUP'")
    private String custGroup3;

    @ApiModelProperty("客户组4")
    @Column(name = "cust_group4", columnDefinition = "varchar(40) comment '客户组4 [UDC]CRM:CUST_GROUP'")
    private String custGroup4;

    @ApiModelProperty("客户ID")
    @Column(name = "cust_id", columnDefinition = "bigint(20) comment '客户ID'")
    private Long custId;

    @ApiModelProperty("客户编号")
    @Column(name = "cust_code", columnDefinition = "varchar(40) comment '客户编号'")
    private String custCode;

    @ApiModelProperty("客户名称")
    @Column(name = "cust_name", columnDefinition = "varchar(200) comment '客户名称'")
    private String custName;

    @ApiModelProperty(value = "生效日期")
    @Column(name = "valid_from", columnDefinition = "datetime  comment '生效日期'")
    private LocalDateTime validFrom;

    @ApiModelProperty(value = "失效日期")
    @Column(name = "valid_to", columnDefinition = "datetime  comment '失效日期'")
    private LocalDateTime validTo;

    /**
     * 工作流字段
     */
    @ApiModelProperty("流程实例ID")
    @Column
    @Comment("流程实例ID")
    private String procInstId;

    @ApiModelProperty("流程实例状态")
    @Column
    @Comment("流程实例状态")
    @Enumerated(EnumType.STRING)
    private ProcInstStatus procInstStatus;

    @ApiModelProperty(value = "提交时间")
    @Comment("提交时间")
    @Column
    private LocalDateTime submitTime;

    @ApiModelProperty(value = "审批通过时间")
    @Comment("审批通过时间")
    @Column
    private LocalDateTime approvedTime;

}
