package com.elitesland.yst.production.sale.entity;

import com.elitesland.yst.production.sale.core.convert.BigDecimalConvert;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * SAL_INV_APPLY(销售开票申请).
 * <p>
 * 销售开票申请
 *
 * @author JinXK
 * @date 2021/6/2 16:59
 */
@Entity
@Table(name = "sal_inv_apply")
@org.hibernate.annotations.Table(appliesTo = "sal_inv_apply", comment = "销售开票申请")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SalInvApplyDO extends BaseModel implements Serializable {
    private static final long serialVersionUID = 4418883816532338153L;

    @Column(name = "bu_id", columnDefinition = "bigint(18) default null  comment 'BUID'")
    private Long buId;
    @Column(name = "bu_name", columnDefinition = "varchar(200) default null  comment 'BUNAME'")
    private String buName;

    @Column(name = "doc_no", columnDefinition = "varchar(40) default null  comment '单据编号'")
    private String docNo;

    @Column(name = "doc_type", columnDefinition = "varchar(40) default null  comment '单据类型 [UDC]SAL:INV_APPLY_TYPE'")
    private String docType;

    @Column(name = "doc_status", columnDefinition = "varchar(40) default null  comment '单据状态'")
    private String docStatus;

    @Column(name = "apply_emp_id", columnDefinition = "bigint(18) default null comment '申请人员工ID'")
    private Long applyEmpId;

    @Column(name = "apply_name", columnDefinition = "longtext default null  comment '申请人姓名'")
    private String applyName;

    @Column(name = "apply_phone", columnDefinition = "longtext default null  comment '申请人电话'")
    private String applyPhone;

    @Column(name = "apply_date", columnDefinition = "datetime default null  comment '申请日期'")
    private LocalDateTime applyDate;

    @Column(name = "apply_desc", columnDefinition = "varchar(100) default null  comment '申请描述'")
    private String applyDesc;

    @Column(name = "appr_status", columnDefinition = "longtext default null  comment '审批状态 [UDC]COM:APPR_STATUS'")
    private String apprStatus;

    @Column(name = "appr_time", columnDefinition = "datetime default null  comment '审批时间'")
    private LocalDateTime apprTime;

    @Column(name = "appr_user_id", columnDefinition = "int(18) default 0 comment '审批人ID'")
    private Long apprUserId;

    @Column(name = "appr_user_name", columnDefinition = "longtext default null comment '审批人姓名'")
    private String apprUserName;

    @Column(name = "appr_comment", columnDefinition = "varchar(500) default null  comment '审批意见'")
    private String apprComment;

    @Column(name = "cust_id", columnDefinition = "int(10) default 0 comment '客户ID'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "longtext default null  comment '客户编号'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "longtext default null  comment '客户名称'")
    private String custName;

    @Column(name = "contract_id", columnDefinition = "int(10) default 0 comment '合同ID'")
    private Long contractId;

    @Column(name = "contract_code", columnDefinition = "longtext default null  comment '合同编号'")
    private String contractCode;

    @Column(name = "contract_name", columnDefinition = "longtext default null  comment '合同名称'")
    private String contractName;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "inv_amt", columnDefinition = "decimal(20, 4) default null  comment '开票金额'")
    private BigDecimal invAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "tax_amt", columnDefinition = "decimal(20, 4) default null  comment '开票税额'")
    private BigDecimal taxAmt;

    @Column(name = "plan_receipt_date", columnDefinition = "datetime default null  comment '预计到款日期'")
    private LocalDateTime planReceiptDate;

    @Column(name = "tax_rate_no", columnDefinition = "longtext default null  comment '税率编号'")
    private String taxRateNo;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "tax_rate", columnDefinition = "decimal(20, 4) default null  comment '税率'")
    private BigDecimal taxRate;

    @Column(name = "inv_title", columnDefinition = "longtext default null  comment '购方名称'")
    private String invTitle;

    @Column(name = "taxer_no", columnDefinition = "varchar(100) default null  comment '税号'")
    private String taxerNo;

    @Column(name = "inv_type", columnDefinition = "varchar(40) default null  comment '发票类型 [UDC]COM:INV_TYPE'")
    private String invType;

    @Column(name = "inv_tel", columnDefinition = "longtext default null  comment '开票电话'")
    private String invTel;

    @Column(name = "inv_address", columnDefinition = "varchar(200) default null  comment '开票地址'")
    private String invAddress;

    @Column(name = "inv_pic_name", columnDefinition = "longtext default null  comment '开票联系人'")
    private String invPicName;

    @Column(name = "inv_pic_phone", columnDefinition = "longtext default null  comment '开票联系人电话'")
    private String invPicPhone;

    @Column(name = "inv_bank_name", columnDefinition = "longtext default null  comment '开票银行名称'")
    private String invBankName;

    @Column(name = "inv_bank_branch", columnDefinition = "longtext default null  comment '开票银行支行'")
    private String invBankBranch;

    @Column(name = "inv_bank_acc", columnDefinition = "longtext default null  comment '开票银行账号'")
    private String invBankAcc;

    @Column(name = "inv_recv_address", columnDefinition = "varchar(200) default null  comment '开票收件地址'")
    private String invRecvAddress;

    @Column(name = "ou_id", columnDefinition = "bigint(18) default null comment '销售公司ID'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "longtext default null  comment '销售公司编号'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(200) default null  comment '销售公司名称'")
    private String ouName;

    @Column(name = "sale_region", columnDefinition = "varchar(40) default null  comment '销售区域 [UDC]SAL:SAL_REGION'")
    private String saleRegion;

    @Column(name = "so_source", columnDefinition = "varchar(40) default null  comment '下单渠道 [UDC]SAL:SO_SOURCE'")
    private String soSource;

    @Column(name = "soa_or_so", columnDefinition = "varchar(40) default null  comment '对账单或销售单'")
    private String soaOrSo;

    @Column(name = "push_method", columnDefinition = "varchar(40) default null  comment '推送方式 [UDC]FIN:PUSH_METHOD'")
    private String pushMethod;

    @Column(name = "phone", columnDefinition = "varchar(40) default null  comment '手机号'")
    private String phone;

    @Column(name = "email", columnDefinition = "varchar(40) default null  comment '邮箱'")
    private String email;

    @Column(name = "open_type", columnDefinition = "varchar(40) default null  comment '蓝票/红票 [UDC]FIN:OPEN_TYPE'")
    private String openType;

    @Column(name = "off_flag", columnDefinition = "varchar(40) default null  comment '是否红冲'")
    private String offFlag;

    @Column(name = "inv_flow", columnDefinition = "varchar(40) default null  comment '发票系统流水号'")
    private String invFlow;

    @Column(name = "relate_doc_id", columnDefinition = "bigint(18) default null comment '相关单据ID'")
    private Long relateDocId;

    @Column(name = "relate_doc_no", columnDefinition = "longtext default null  comment '相关单据编号 原始单号'")
    private String relateDocNo;

    @Column(name = "off_inv_no", columnDefinition = "varchar(40) default null  comment '原单发票号码'")
    private String offInvNo;

    @Column(name = "off_inv_code", columnDefinition = "varchar(40) default null  comment '原单发票代码'")
    private String offInvCode;

    @Column(name = "off_flow_no", columnDefinition = "varchar(40) default null  comment '原单流水号'")
    private String offFlowNo;

    @Column(name = "inv_date", columnDefinition = "datetime default null comment '开票日期'")
    private LocalDateTime invDate;

}

