package com.elitesland.yst.production.sale.entity;

import com.elitesland.yst.production.sale.core.convert.BigDecimalConvert;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Objects;

/**
 * SAL_RECEIPT_SETTLEDD(订单收款结算细细表).
 * <p>
 * 订单收款结算细细表
 *
 * @author Evin.dong
 * @date 2021/6/28 19:54
 */
@Entity
@Table(name = "sal_receipt_settledd", indexes = {
        @Index(name = "idx_doc_no", columnList = "doc_no")
})
@org.hibernate.annotations.Table(appliesTo = "sal_receipt_settledd", comment = "订单收款结算细细表")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
public class SalReceiptSettleddDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 6296027705427100623L;

    @Column(name = "receipt_settle_docno", columnDefinition = "varchar(100) default null  comment '收款结算单编号'")
    private String receiptSettleDocno;

    @Column(name = "settleitem_id", columnDefinition = "bigint(20) default null comment '商品细表ID'")
    private Long settleitemId;

    @Column(name = "doc_id", columnDefinition = "bigint(20) default null  comment '订单ID'")
    private Long docId;

    @Column(name = "doc_cls", columnDefinition = "varchar(100) default null  comment '订单类别 [UDC]COM:DOC_CLS'")
    private String docCls;

    @Column(name = "doc_type", columnDefinition = "varchar(100) default null  comment '订单类型 [UDC]SAL:SO_TYPE'")
    private String docType;

    @Column(name = "doc_no", columnDefinition = "varchar(100) default null  comment '订单编号'")
    private String docNo;

    @Column(name = "doc_type2", columnDefinition = "varchar(100) default null  comment '订单类型2 [UDC]SAL:SO_TYPE2'")
    private String docType2;

    @Column(name = "so_source", columnDefinition = "varchar(40) default null  comment '下单渠道 [UDC]SAL:SO_SOURCE'")
    private String soSource;

    @Column(name = "doc_d_id", columnDefinition = "bigint(20) default null comment '订单行ID'")
    private Long docDId;

    @Column(name = "line_no", columnDefinition = "varchar(100) default null  comment '订单行号'")
    private BigDecimal lineNo;

    @Column(name = "doc_time", columnDefinition = "datetime default null  comment '订单日期'")
    private LocalDateTime docTime;

    @Column(name = "pno", columnDefinition = "varchar(100) default null  comment '父订单号'")
    private String pno;

    @Column(name = "receipt_type", columnDefinition = "varchar(100) default null  comment '收款类型 [UDC]SAL:SO_RETURN_TYPE'")
    private String receiptType;

    @Column(name = "receipt_method", columnDefinition = "varchar(100) default null  comment '收款方式 [UDC]COM:PAY_METHOD'")
    private String receiptMethod;

    @Column(name = "ou_id", columnDefinition = "bigint(20) default null comment '公司ID'")
    private Long ouId;

    @Column(name = "ou_code", columnDefinition = "varchar(100) default null  comment '公司编号'")
    private String ouCode;

    @Column(name = "ou_name", columnDefinition = "varchar(200) default null  comment '公司名称'")
    private String ouName;

    @Column(name = "bu_id", columnDefinition = "bigint(18) default null  comment 'BUID'")
    private Long buId;

    @Column(name = "bu_code", columnDefinition = "varchar(100) default null  comment 'BU编号'")
    private String buCode;

    @Column(name = "bu_name", columnDefinition = "varchar(200) default null  comment 'BU名称'")
    private String buName;

    @Column(name = "cust_id", columnDefinition = "bigint(20) default null comment '客户ID'")
    private Long custId;

    @Column(name = "cust_code", columnDefinition = "varchar(100) default null  comment '客户编号'")
    private String custCode;

    @Column(name = "cust_name", columnDefinition = "varchar(100) default null  comment '客户名称'")
    private String custName;

    @Column(name = "settle_bu_type", columnDefinition = "varchar(100) default null  comment '结算组织类型'")
    private String settleBuType;

    @Column(name = "curr_code", columnDefinition = "varchar(100) default null  comment '币种'")
    private String currCode;

    @Column(name = "agent_emp_id", columnDefinition = "bigint(20) default 0 comment '业务员员工ID'")
    private Long agentEmpId;

    @Column(name = "agent_user_id", columnDefinition = "bigint(20) default 0 comment '业务员用户ID'")
    private Long agentUserId;

    @Column(name = "agent_code", columnDefinition = "varchar(100) default null  comment '业务员编号'")
    private String agentCode;

    @Column(name = "agent_name", columnDefinition = "varchar(100) default null  comment '业务员姓名'")
    private String agentName;

    @Column(name = "line_type", columnDefinition = "varchar(100) default null  comment '行类型'")
    private String lineType;

    @Column(name = "item_id", columnDefinition = "bigint(20) default null comment '商品ID'")
    private Long itemId;

    @Column(name = "item_code", columnDefinition = "varchar(40) default null  comment '商品编号'")
    private String itemCode;

    @Column(name = "item_name", columnDefinition = "varchar(255) default null  comment '商品名称'")
    private String itemName;

    @Column(name = "item_name2", columnDefinition = "varchar(100) default null  comment '商品名称2'")
    private String itemName2;

    @Column(name = "item_spec", columnDefinition = "varchar(255) default null  comment '商品规格'")
    private String itemSpec;

    @Column(name = "item_cat", columnDefinition = "varchar(100) default null  comment '商品品类'")
    private String itemCat;

    @Column(name = "fin_cat", columnDefinition = "varchar(100) default null  comment '财务分类'")
    private String finCat;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "qty", columnDefinition = "decimal(20, 4) default 0  comment '订单数量'")
    private BigDecimal qty;

    @Column(name = "uom", columnDefinition = "varchar(100) default null  comment '计量单位'")
    private String uom;

    @Column(name = "tax_rate_no", columnDefinition = "varchar(100) default null  comment '税率编号'")
    private String taxRateNo;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "tax_rate", columnDefinition = "decimal(20, 4) default null  comment '税率'")
    private BigDecimal taxRate;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "origin_amt", columnDefinition = "decimal(20, 4) default 0  comment '销售含税金额'")
    private BigDecimal originAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "ap_amt", columnDefinition = "decimal(20, 4) default 0  comment '应收款金额'")
    private BigDecimal apAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "card_amt", columnDefinition = "decimal(20, 4) default 0  comment '购物卡金额'")
    private BigDecimal cardAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "gift_amt", columnDefinition = "decimal(20, 4) default 0  comment '提货券金额'")
    private BigDecimal giftAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "usepoint_amt", columnDefinition = "decimal(20, 4) default 0  comment '使用积分金额'")
    private BigDecimal usepointAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "receipt_amt", columnDefinition = "decimal(20, 4) default 0  comment '收款金额'")
    private BigDecimal receiptAmt;

    @Convert(converter = BigDecimalConvert.class)
    @Column(name = "receipt_tax", columnDefinition = "decimal(20, 4) default 0  comment '收款税额'")
    private BigDecimal receiptTax;

    @Column(name = "receipt_date", columnDefinition = "datetime default null  comment '收款日期'")
    private LocalDateTime receiptDate;

    @Column(name = "approved_user_id", columnDefinition = "bigint(20) default 0 comment '审核人'")
    private Long approvedUserId;

    @Column(name = "coupon_amt", columnDefinition = "decimal(20, 4) default null  comment '优惠券金额'")
    private BigDecimal couponAmt;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SalReceiptSettleddDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SalReceiptSettleddDO entity = (SalReceiptSettleddDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
