package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.entity.SalContractDDO;
import com.elitesland.yst.production.sale.entity.SalContractDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

import java.util.List;

/**
 * @author Eric.li (Li Jia Zhe)
 * @date 2021/6/9 11:26 上午
 */
public interface SalContractRepo extends JpaRepository<SalContractDO, Long>, QuerydslPredicateExecutor<SalContractDO> {

    // 根据合同号查询
    List<SalContractDO> findAllByContractNo(String contractNo);

    // 根据合同号和版本查询
    SalContractDO findByContractNoAndContractVersion(String contractNo, Integer contractVersion);

    SalContractDO findByContractName(String contractName);

    List<SalContractDO> findAllByContractNameIn(List<String> contractNames);

    List<SalContractDO> findAllByContractNoIn(List<String> contractNos);
}
