package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.resp.sal.SalReceiptdRespVO;
import com.elitesland.yst.production.sale.entity.QSalReceiptDDO;
import com.elitesland.yst.production.sale.entity.QSalReceiptDO;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.val;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/**
 * @auther JinXK
 * @date 2021/6/12 11:28
 */
@Repository
public class SalReceiptdRepoProc {

    @Autowired
    private JPAQueryFactory jpaQueryFactory;

    /**
     * 根据masId批量查询销售开票申请明细
     */
    public JPAQuery<SalReceiptdRespVO> findBymasId(Long masId) {
        val salReceiptDDO = QSalReceiptDDO.salReceiptDDO;

        Predicate predicate = salReceiptDDO.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalReceiptdRespVO.class,
                salReceiptDDO.id,
                salReceiptDDO.masId,
                salReceiptDDO.soId,
                salReceiptDDO.soNo,
                salReceiptDDO.soDId,
                salReceiptDDO.soLineNo,
                salReceiptDDO.itemId,
                salReceiptDDO.itemCode,
                salReceiptDDO.itemName,
                salReceiptDDO.itemSpec,
                salReceiptDDO.itemBrand,
                salReceiptDDO.soQty,
                salReceiptDDO.soUom,
                salReceiptDDO.soTaxRateNo,
                salReceiptDDO.soTaxRate,
                salReceiptDDO.soTaxAmt,
                salReceiptDDO.soAmt,
                salReceiptDDO.receiptAmt,
                salReceiptDDO.receiptTax,
                salReceiptDDO.offedAmt,
                salReceiptDDO.offingAmt,
                salReceiptDDO.relateDocId,
                salReceiptDDO.relateDocNo,
                salReceiptDDO.receiptNetamt,
                salReceiptDDO.soaId,
                salReceiptDDO.soaNo,
                salReceiptDDO.dodId,
                salReceiptDDO.doDocNo,
                salReceiptDDO.soaDetailId,
                salReceiptDDO.contractId,
                salReceiptDDO.contractCode,
                salReceiptDDO.contractName,
                salReceiptDDO.remark

        )).from(salReceiptDDO);
        jpaQuery.where(predicate, salReceiptDDO.masId.eq(masId));
        jpaQuery.where(predicate, salReceiptDDO.deleteFlag.eq(0).or(salReceiptDDO.deleteFlag.isNull()));
        return jpaQuery;
    }

    /**
     * 根据relateDocId批量查询销售开票申请明细
     */
    public JPAQuery<SalReceiptdRespVO> findByRelateDocId(Long relateDocId) {
        val salReceiptDDO = QSalReceiptDDO.salReceiptDDO;
        val salReceiptDO = QSalReceiptDO.salReceiptDO;

        Predicate predicate = salReceiptDDO.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalReceiptdRespVO.class,
                salReceiptDDO.id,
                salReceiptDDO.masId,
                salReceiptDDO.soId,
                salReceiptDDO.soNo,
                salReceiptDDO.soDId,
                salReceiptDDO.soLineNo,
                salReceiptDDO.itemId,
                salReceiptDDO.itemCode,
                salReceiptDDO.itemName,
                salReceiptDDO.itemSpec,
                salReceiptDDO.itemBrand,
                salReceiptDDO.soQty,
                salReceiptDDO.soUom,
                salReceiptDDO.soTaxRateNo,
                salReceiptDDO.soTaxRate,
                salReceiptDDO.soTaxAmt,
                salReceiptDDO.soAmt,
                salReceiptDDO.receiptAmt,
                salReceiptDDO.receiptTax,
                salReceiptDDO.offedAmt,
                salReceiptDDO.offingAmt,
                salReceiptDDO.relateDocId,
                salReceiptDDO.relateDocNo,
                salReceiptDDO.receiptNetamt,
                salReceiptDDO.soaId,
                salReceiptDDO.soaNo,
                salReceiptDDO.dodId,
                salReceiptDDO.doDocNo,
                salReceiptDDO.soaDetailId,
                salReceiptDDO.contractId,
                salReceiptDDO.contractCode,
                salReceiptDDO.contractName,
                salReceiptDDO.remark

        )).from(salReceiptDDO)
                .leftJoin(salReceiptDO).on(salReceiptDO.id.eq(salReceiptDDO.masId));
        jpaQuery.where(predicate, salReceiptDDO.deleteFlag.eq(0).or(salReceiptDDO.deleteFlag.isNull()));
        jpaQuery.where(predicate, salReceiptDO.relateDocId.eq(relateDocId));
        jpaQuery.where(predicate, salReceiptDO.docType.eq("RD"));
        jpaQuery.where(predicate, salReceiptDO.docStatus.eq("APPROVING")
                .or(salReceiptDO.docStatus.eq("APPROVED")).or(salReceiptDO.docStatus.eq("RECEIVED")));
        return jpaQuery;
    }

    /**
     * 根据relateDocId批量查询红冲单明细列表
     */
    public JPAQuery<SalReceiptdRespVO> getReds(Long relateDocId) {
        val salReceiptDDO = QSalReceiptDDO.salReceiptDDO;
        val salReceiptDO = QSalReceiptDO.salReceiptDO;

        Predicate predicate = salReceiptDDO.isNotNull();
        val jpaQuery = jpaQueryFactory.select(Projections.bean(SalReceiptdRespVO.class,
                salReceiptDDO.id,
                salReceiptDDO.masId,
                salReceiptDDO.soId,
                salReceiptDDO.soNo,
                salReceiptDDO.soDId,
                salReceiptDDO.soLineNo,
                salReceiptDDO.itemId,
                salReceiptDDO.itemCode,
                salReceiptDDO.itemName,
                salReceiptDDO.itemSpec,
                salReceiptDDO.itemBrand,
                salReceiptDDO.soQty,
                salReceiptDDO.soUom,
                salReceiptDDO.soTaxRateNo,
                salReceiptDDO.soTaxRate,
                salReceiptDDO.soTaxAmt,
                salReceiptDDO.soAmt,
                salReceiptDDO.receiptAmt,
                salReceiptDDO.receiptTax,
                salReceiptDDO.offedAmt,
                salReceiptDDO.offingAmt,
                salReceiptDDO.relateDocId,
                salReceiptDDO.relateDocNo,
                salReceiptDDO.receiptNetamt,
                salReceiptDDO.soaId,
                salReceiptDDO.soaNo,
                salReceiptDDO.dodId,
                salReceiptDDO.doDocNo,
                salReceiptDDO.soaDetailId,
                salReceiptDDO.contractId,
                salReceiptDDO.contractCode,
                salReceiptDDO.contractName,
                salReceiptDDO.remark

        )).from(salReceiptDDO)
                .leftJoin(salReceiptDO).on(salReceiptDO.id.eq(salReceiptDDO.masId));
        jpaQuery.where(predicate, salReceiptDDO.deleteFlag.eq(0).or(salReceiptDDO.deleteFlag.isNull()));
        jpaQuery.where(predicate, salReceiptDO.relateDocId.eq(relateDocId));
        jpaQuery.where(predicate, salReceiptDO.receiptType.eq("RED"));
        jpaQuery.where(predicate, salReceiptDO.docStatus.eq("APPROVING")
                .or(salReceiptDO.docStatus.eq("APPROVED")).or(salReceiptDO.docStatus.eq("RECEIVED")));
        return jpaQuery;
    }
}
