package com.elitesland.yst.production.sale.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitesland.yst.production.sale.api.vo.param.taskinfo.SaleStatisticsStoreQueryVO;
import com.elitesland.yst.production.sale.api.vo.resp.taskinfo.StatisticsStoreSumRespVO;
import com.elitesland.yst.production.sale.common.constant.ConstantsSale;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.entity.QSaleStatisticsStoreDtlDO;
import com.elitesland.yst.production.sale.repo.QsqlDO.QsqlSaleStatisticsStoreDO;
import com.elitesland.yst.production.sale.repo.QsqlDO.QsqlSaleStatisticsStoreDtlDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQueryFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;


/**
 * @author : ssy
 * @date : 2023-8-15
 * @desc : 销售业绩统计-门店 Repo_SQL_Proc
 */
@Component
public class SaleStatisticsStoreRepoSqlProc {

    private final SQLQueryFactory sqlQueryFactory;
    private static final QsqlSaleStatisticsStoreDO qsqlSaleStatisticsStoreDO = QsqlSaleStatisticsStoreDO.saleStatisticsStore;
    private static final QsqlSaleStatisticsStoreDtlDO DTL_DO = QsqlSaleStatisticsStoreDtlDO.saleStatisticsStoreDtlDO;

    private final String SHIP_TOTAL_QTY = "shipTotalQty";
    private final String STORE_TOTAL_QTY = "storeTotalQty";

    public SaleStatisticsStoreRepoSqlProc(SQLQueryFactory sqlQueryFactory) {
        this.sqlQueryFactory = sqlQueryFactory;
    }

    public StatisticsStoreSumRespVO pageSum(SaleStatisticsStoreQueryVO queryVO) {

        // https://www.php.cn/faq/543497.html
        StringPath t = Expressions.stringPath("t");
        List<Predicate> where = where(queryVO);

        SubQueryExpression subQueryExpression = SQLExpressions.select(
                        qsqlSaleStatisticsStoreDO.docTime,
                        qsqlSaleStatisticsStoreDO.storeCode,
                        qsqlSaleStatisticsStoreDO.storeName,
                        qsqlSaleStatisticsStoreDO.empCode,
                        qsqlSaleStatisticsStoreDO.empName,
                        qsqlSaleStatisticsStoreDO.userId2,
                        qsqlSaleStatisticsStoreDO.dealerCode,
                        qsqlSaleStatisticsStoreDO.storeType2,
                        qsqlSaleStatisticsStoreDO.dealerName,
                        qsqlSaleStatisticsStoreDO.dealerSerialNo,
                        qsqlSaleStatisticsStoreDO.region,
                        qsqlSaleStatisticsStoreDO.type,
                        qsqlSaleStatisticsStoreDO.salesmanPath,
                        qsqlSaleStatisticsStoreDO.vehicleType,
                        qsqlSaleStatisticsStoreDO.itemType3,
                        qsqlSaleStatisticsStoreDO.shipQty.sum().as(SHIP_TOTAL_QTY),
                        qsqlSaleStatisticsStoreDO.id,
                        qsqlSaleStatisticsStoreDO.createTime,
                        qsqlSaleStatisticsStoreDO.detailAddr,
                        qsqlSaleStatisticsStoreDO.remark,
                        qsqlSaleStatisticsStoreDO.updateRegionFailureReason,
                        qsqlSaleStatisticsStoreDO.updateSalesmanFailureReason
                ).from(qsqlSaleStatisticsStoreDO)
                .where(ExpressionUtils.allOf(where))
                .groupBy(qsqlSaleStatisticsStoreDO.region, qsqlSaleStatisticsStoreDO.storeCode, qsqlSaleStatisticsStoreDO.dealerCode,
                        qsqlSaleStatisticsStoreDO.salesmanPath, qsqlSaleStatisticsStoreDO.docTime)
                .having(having(queryVO));

        return sqlQueryFactory.select(
                        Projections.bean(StatisticsStoreSumRespVO.class,
                                Expressions.template(BigDecimal.class, "sum(t.shipTotalQty)").as(SHIP_TOTAL_QTY),
                                Expressions.template(Long.class, "count(distinct t.store_code)").as(STORE_TOTAL_QTY)
                        )
                )
                .from(subQueryExpression, t).fetchOne();
    }

    public StatisticsStoreSumRespVO pageSumPc(SaleStatisticsStoreQueryVO queryVO) {

        // https://www.php.cn/faq/543497.html
        StringPath t = Expressions.stringPath("t");
        List<Predicate> where = wherePc(queryVO);

        SubQueryExpression subQueryExpression = SQLExpressions.select(
                qsqlSaleStatisticsStoreDO.docTime,
                qsqlSaleStatisticsStoreDO.storeCode,
                qsqlSaleStatisticsStoreDO.storeName,
                qsqlSaleStatisticsStoreDO.empCode,
                qsqlSaleStatisticsStoreDO.empName,
                qsqlSaleStatisticsStoreDO.userId2,
                qsqlSaleStatisticsStoreDO.dealerCode,
                qsqlSaleStatisticsStoreDO.storeType2,
                qsqlSaleStatisticsStoreDO.dealerName,
                qsqlSaleStatisticsStoreDO.dealerSerialNo,
                qsqlSaleStatisticsStoreDO.region,
                qsqlSaleStatisticsStoreDO.type,
                qsqlSaleStatisticsStoreDO.salesmanPath,
                qsqlSaleStatisticsStoreDO.vehicleType,
                qsqlSaleStatisticsStoreDO.itemType3,
                qsqlSaleStatisticsStoreDO.shipQty.sum().as(SHIP_TOTAL_QTY),
                qsqlSaleStatisticsStoreDO.id,
                qsqlSaleStatisticsStoreDO.createTime,
                qsqlSaleStatisticsStoreDO.detailAddr,
                qsqlSaleStatisticsStoreDO.remark,
                qsqlSaleStatisticsStoreDO.updateRegionFailureReason,
                qsqlSaleStatisticsStoreDO.updateSalesmanFailureReason
        ).from(qsqlSaleStatisticsStoreDO)
                .where(ExpressionUtils.allOf(where))
                .groupBy(qsqlSaleStatisticsStoreDO.region, qsqlSaleStatisticsStoreDO.storeCode, qsqlSaleStatisticsStoreDO.dealerCode,
                        qsqlSaleStatisticsStoreDO.salesmanPath, qsqlSaleStatisticsStoreDO.docTime)
                .having(having(queryVO));

        return sqlQueryFactory.select(
                Projections.bean(StatisticsStoreSumRespVO.class,
                        Expressions.template(BigDecimal.class, "sum(t.shipTotalQty)").as(SHIP_TOTAL_QTY),
                        Expressions.template(Long.class, "count(distinct t.store_code)").as(STORE_TOTAL_QTY)
                )
        )
                .from(subQueryExpression, t).fetchOne();
    }

    private Predicate having(SaleStatisticsStoreQueryVO queryVO) {
        return BaseRepoProc.PredicateBuilder.builder()
                .andEq(Expressions.ONE, 1)
                .andGoe(!Objects.isNull(queryVO.getShipTotalQtyFrom()), qsqlSaleStatisticsStoreDO.shipQty.sum(), (queryVO.getShipTotalQtyFrom()))
                .andLoe(!Objects.isNull(queryVO.getShipTotalQtyTo()), qsqlSaleStatisticsStoreDO.shipQty.sum(), (queryVO.getShipTotalQtyTo()))
                .build();
    }

    private List<Predicate> where(SaleStatisticsStoreQueryVO param) {
        List<Predicate> predicates = new ArrayList<>();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andGoe(null != param.getDocTimeStart(), qsqlSaleStatisticsStoreDO.docTime, LocalDateTime.of(param.getDocTimeStart().toLocalDate(), LocalTime.MIN))
                .andLoe(null != param.getDocTimeEnd(), qsqlSaleStatisticsStoreDO.docTime, LocalDateTime.of(param.getDocTimeEnd().toLocalDate(), ConstantsSale.LOCAL_TIME_MAX))
                .andLike(StringUtils.isNotBlank(param.getStoreCode()), qsqlSaleStatisticsStoreDO.storeCode, param.getStoreCode())
                .andLike(StringUtils.isNotBlank(param.getStoreName()), qsqlSaleStatisticsStoreDO.storeName, param.getStoreName())
                .andEq(StringUtils.isNotBlank(param.getDealerCode()), qsqlSaleStatisticsStoreDO.dealerCode, param.getDealerCode())
                .andEq(StringUtils.isNotBlank(param.getDealerName()), qsqlSaleStatisticsStoreDO.dealerName, param.getDealerName())
                .andEq(StringUtils.isNotBlank(param.getEmpName()), qsqlSaleStatisticsStoreDO.empName, param.getEmpName())
                .andEq(StringUtils.isNotBlank(param.getEmpCode()), qsqlSaleStatisticsStoreDO.empCode, param.getEmpCode())
                .andEq(StringUtils.isNotBlank(param.getDealerSerialNo()), qsqlSaleStatisticsStoreDO.dealerSerialNo, param.getDealerSerialNo())
                .andEq(StringUtils.isNotBlank(param.getType()), qsqlSaleStatisticsStoreDO.type, param.getType())
                .andEq(StringUtils.isNotBlank(param.getVehicleType()), qsqlSaleStatisticsStoreDO.vehicleType, param.getVehicleType())
                .andEq(StringUtils.isNotBlank(param.getItemType3()), qsqlSaleStatisticsStoreDO.itemType3, param.getItemType3())
                .andEq(StringUtils.isNotBlank(param.getStoreType2()), qsqlSaleStatisticsStoreDO.storeType2, param.getStoreType2())
                .andLike(StringUtils.isNotBlank(param.getDetailAddr()), qsqlSaleStatisticsStoreDO.detailAddr, param.getDetailAddr())
                .andEq(null != param.getShipQty(), qsqlSaleStatisticsStoreDO.shipQty, param.getShipQty())
                .andEq(StringUtils.isNotBlank(param.getRegion()), qsqlSaleStatisticsStoreDO.region, param.getRegion())
                .andIn(!CollectionUtils.isEmpty(param.getIds()), qsqlSaleStatisticsStoreDO.id, param.getIds())
                .andIn(!CollectionUtils.isEmpty(param.getDealerCodeList()), qsqlSaleStatisticsStoreDO.dealerCode, param.getDealerCodeList())
                .build();

        predicates.add(predicate);
        if (!StringUtils.isEmpty(param.getDealerKeyword())) {
            predicates.add(qsqlSaleStatisticsStoreDO.dealerCode.like("%" + param.getDealerKeyword() + "%").or(qsqlSaleStatisticsStoreDO.dealerName.like("%" + param.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(param.getKeyword())) {
            predicates.add(qsqlSaleStatisticsStoreDO.storeCode.like("%" + param.getKeyword() + "%").or(qsqlSaleStatisticsStoreDO.storeName.like("%" + param.getKeyword() + "%")));
        }
        if (Objects.nonNull(param.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", qsqlSaleStatisticsStoreDO.docTime)
                    .eq(param.getDocMonth());
            predicates.add(booleanTemplate);
        }
        if (Objects.nonNull(param.getDocTime())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", qsqlSaleStatisticsStoreDO.docTime)
                    .eq(param.getDocTime().toLocalDate().toString());
            predicates.add(booleanTemplate);
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())) {
            predicates.add(qsqlSaleStatisticsStoreDO.region.isNull());
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())) {
            predicates.add(qsqlSaleStatisticsStoreDO.region.isNotNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())) {
            predicates.add(qsqlSaleStatisticsStoreDO.salesmanPath.isNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())) {
            predicates.add(qsqlSaleStatisticsStoreDO.salesmanPath.isNotNull());
        }
        return predicates;
    }

    private List<Predicate> wherePc(SaleStatisticsStoreQueryVO param) {
        List<Predicate> predicates = new ArrayList<>();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder()
                .andGoe(null != param.getDocTimeStart(), qsqlSaleStatisticsStoreDO.docTime, LocalDateTime.of(param.getDocTimeStart().toLocalDate(), LocalTime.MIN))
                .andLoe(null != param.getDocTimeEnd(), qsqlSaleStatisticsStoreDO.docTime, LocalDateTime.of(param.getDocTimeEnd().toLocalDate(), ConstantsSale.LOCAL_TIME_MAX))
                .andLike(StringUtils.isNotBlank(param.getStoreCode()), qsqlSaleStatisticsStoreDO.storeCode, param.getStoreCode())
                .andLike(StringUtils.isNotBlank(param.getStoreName()), qsqlSaleStatisticsStoreDO.storeName, param.getStoreName())
                .andEq(StringUtils.isNotBlank(param.getDealerCode()), qsqlSaleStatisticsStoreDO.dealerCode, param.getDealerCode())
                .andEq(StringUtils.isNotBlank(param.getDealerName()), qsqlSaleStatisticsStoreDO.dealerName, param.getDealerName())
                .andEq(StringUtils.isNotBlank(param.getEmpName()), qsqlSaleStatisticsStoreDO.empName, param.getEmpName())
                .andEq(StringUtils.isNotBlank(param.getEmpCode()), qsqlSaleStatisticsStoreDO.empCode, param.getEmpCode())
                .andEq(StringUtils.isNotBlank(param.getDealerSerialNo()), qsqlSaleStatisticsStoreDO.dealerSerialNo, param.getDealerSerialNo())
                .andEq(StringUtils.isNotBlank(param.getType()), qsqlSaleStatisticsStoreDO.type, param.getType())
                .andEq(StringUtils.isNotBlank(param.getVehicleType()), qsqlSaleStatisticsStoreDO.vehicleType, param.getVehicleType())
                .andEq(StringUtils.isNotBlank(param.getItemType3()), qsqlSaleStatisticsStoreDO.itemType3, param.getItemType3())
                .andEq(StringUtils.isNotBlank(param.getStoreType2()), qsqlSaleStatisticsStoreDO.storeType2, param.getStoreType2())
                .andLike(StringUtils.isNotBlank(param.getDetailAddr()), qsqlSaleStatisticsStoreDO.detailAddr, param.getDetailAddr())
                .andEq(null != param.getShipQty(), qsqlSaleStatisticsStoreDO.shipQty, param.getShipQty())
                .andEq(StringUtils.isNotBlank(param.getRegion()), qsqlSaleStatisticsStoreDO.region, param.getRegion())
                .andIn(!CollectionUtils.isEmpty(param.getIds()), qsqlSaleStatisticsStoreDO.id, param.getIds())
                .andIn(!CollectionUtils.isEmpty(param.getDealerCodeList()), qsqlSaleStatisticsStoreDO.dealerCode, param.getDealerCodeList())
                .build();

        predicates.add(predicate);
        if (!StringUtils.isEmpty(param.getDealerKeyword())) {
            predicates.add(qsqlSaleStatisticsStoreDO.dealerCode.like("%" + param.getDealerKeyword() + "%").or(qsqlSaleStatisticsStoreDO.dealerName.like("%" + param.getDealerKeyword() + "%")));
        }
        if (!StringUtils.isEmpty(param.getKeyword())) {
            predicates.add(qsqlSaleStatisticsStoreDO.storeCode.like("%" + param.getKeyword() + "%").or(qsqlSaleStatisticsStoreDO.storeName.like("%" + param.getKeyword() + "%")));
        }
        if (Objects.nonNull(param.getDocMonth())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m')", qsqlSaleStatisticsStoreDO.docTime)
                    .eq(param.getDocMonth());
            predicates.add(booleanTemplate);
        }
        if (Objects.nonNull(param.getDocTime())) {
            BooleanExpression booleanTemplate = Expressions.stringTemplate("DATE_FORMAT({0},'%Y-%m-%d')", qsqlSaleStatisticsStoreDO.docTime)
                    .eq(param.getDocTime().toLocalDate().toString());
            predicates.add(booleanTemplate);
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_YES.getValueCode())) {
            predicates.add(qsqlSaleStatisticsStoreDO.region.isNull());
        }
        if (Objects.equals(param.getRegionEmptyFlag(), UdcEnum.STATISTICS_REGION_EMPTY_NO.getValueCode())) {
            predicates.add(qsqlSaleStatisticsStoreDO.region.isNotNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_YES.getValueCode())) {
            predicates.add(qsqlSaleStatisticsStoreDO.salesmanPath.isNull());
        }
        if (Objects.equals(param.getSalesmanPathEmptyFlag(), UdcEnum.STATISTICS_SALESMAN_PATH_EMPTY_NO.getValueCode())) {
            predicates.add(qsqlSaleStatisticsStoreDO.salesmanPath.isNotNull());
        }

        if(!Objects.isNull(param.getAgentEmp())){
            predicates.add(qsqlSaleStatisticsStoreDO.id.in(JPAExpressions
                    .select(DTL_DO.masId)
                    .from(DTL_DO)
                    .where(DTL_DO.deleteFlag.eq(0)
                            .and(DTL_DO.code.eq(param.getAgentEmp())))));
        }

        return predicates;
    }

}

