package com.elitesland.yst.production.sale.repo;

import com.elitesland.yst.production.sale.api.vo.param.zone.ZoneSettingPageParam;
import com.elitesland.yst.production.sale.api.vo.resp.zone.ZoneSettingVO;
import com.elitesland.yst.production.sale.entity.QZoneSettingDDO;
import com.elitesland.yst.production.sale.entity.QZoneSettingDO;
import com.elitesland.yst.production.sale.entity.ZoneSettingDDO;
import com.elitesland.yst.production.sale.entity.ZoneSettingDO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.security.util.DataAuthJpaUtil;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

@Component
@RequiredArgsConstructor
public class ZoneSettingRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private final QZoneSettingDO qZoneSettingDO = QZoneSettingDO.zoneSettingDO;
    private final QZoneSettingDDO qZoneSettingDDO = QZoneSettingDDO.zoneSettingDDO;

    public PagingVO<ZoneSettingVO> findPagingResult(ZoneSettingPageParam param){
        JPAQuery<ZoneSettingVO> query = selectFromWhere(ZoneSettingVO.class,param);
        param.setPaging(query);
        param.fillOrders(query,qZoneSettingDO);
        return PagingVO.<ZoneSettingVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();
    }

    private <T> JPAQuery<T> selectFromWhere(Class<T> cls, ZoneSettingPageParam param){
        return jpaQueryFactory.select(Projections.bean(cls,
                qZoneSettingDO.id,
                qZoneSettingDO.zoneCode,
                qZoneSettingDO.zoneName,
                qZoneSettingDO.status,
                qZoneSettingDO.sort,
                qZoneSettingDO.modifyTime,
                qZoneSettingDO.createTime,
                qZoneSettingDO.createUserId,
                qZoneSettingDO.ouId,
                qZoneSettingDO.ouName,
                qZoneSettingDO.creator,
                qZoneSettingDO.remark)).from(qZoneSettingDO).where(where(param));
    }



    public Predicate where(ZoneSettingPageParam param){
        List<Predicate> predicate = new ArrayList<>();
        if(null != param.getOuId()){
            predicate.add(qZoneSettingDO.ouId.eq(param.getOuId()));
        }else {
            predicate.add(DataAuthJpaUtil.dataAuthJpaPredicate(qZoneSettingDO.getMetadata()));
        }
        if(StringUtils.isNotBlank(param.getStatus())){
            predicate.add(qZoneSettingDO.status.eq(param.getStatus()));
        }
        if(StringUtils.isNotBlank(param.getZoneCode())){
            predicate.add(qZoneSettingDO.zoneCode.like("%" + param.getZoneCode() + "%"));
        }
        if(StringUtils.isNotBlank(param.getZoneName())){
            predicate.add(qZoneSettingDO.zoneName.like("%" + param.getZoneName() + "%"));
        }
        predicate.add(qZoneSettingDO.deleteFlag.isNull().or(qZoneSettingDO.deleteFlag.eq(0)));
        return ExpressionUtils.allOf(predicate);
    }

    public List<ZoneSettingDDO> findZoneDByZOId(Long zoneId, Long ouId){
        return jpaQueryFactory.select(qZoneSettingDDO).from(qZoneSettingDDO)
                .where(qZoneSettingDDO.zoneId.eq(zoneId)
                        .and(qZoneSettingDDO.ouId.eq(ouId))
                        .and(qZoneSettingDDO.state.eq("SHELF")))
                .limit(6)
                .fetch();
    }

}
