package com.elitesland.yst.production.sale.repo.shop;

import com.elitesland.yst.production.sale.entity.BipItemDO;
import com.elitesland.yst.production.sale.entity.BipItemPicDO;
import com.elitesland.yst.production.sale.entity.QBipItemPicDO;
import com.querydsl.jpa.impl.JPAQueryFactory;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * @date 2021/08/19
 */
@Repository
public class BipItemPicRepoProc {

    private final JPAQueryFactory jpaQueryFactory;

    private static final QBipItemPicDO DO = QBipItemPicDO.bipItemPicDO;

    public BipItemPicRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }

    /**
     * 根据商品ID删除
     *
     * @param bipItemId 商品ID
     */
    public void deleteByBipItemId(Long bipItemId) {
        jpaQueryFactory.delete(DO)
                .where(DO.bipItemId.eq(bipItemId))
                .execute();
    }

    /**
     * 删除商品
     *
     * @param bipItemIds 商品ID
     */
    public void deleteByBipItemId(List<Long> bipItemIds) {
        jpaQueryFactory.delete(DO)
                .where(DO.bipItemId.in(bipItemIds))
                .execute();
    }

    /**
     * 根据商品ID查询
     *
     * @param bipItemId 商品ID
     * @return 商品图片
     */
    public List<BipItemPicDO> queryByBipItemId(Long bipItemId) {
        return jpaQueryFactory.select(DO)
                .from(DO)
                .where(DO.bipItemId.eq(bipItemId))
                .fetch();
    }
}

