package com.elitesland.yst.production.sale.rmi.ystsystem;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.provider.SysUserRpcService;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.org.UserRpcService;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * 用户中心接口.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-13
 */
@Component
@Slf4j
public class RmiSysUserService {

//    @DubboReference(version = "${provider.service.version}")
//    @DubboReference
//    private SysUserService sysUserService;

    @Autowired
    private SysUserRpcService sysUserRpcService;

    @Autowired
    private UserRpcService userRpcService;


    public Long updatePwd(Long userId,String pwd){
        log.info("userId:---"+userId+"pwd:---"+pwd);
        try {
            ApiResult<Long> id = userRpcService.updatePwd(userId, pwd);
            if(id.isSuccess()){
                return id.getData();
            }
            throw new BusinessException("修改密码失败");
        }catch (Exception e){
            throw new BusinessException("修改密码失败"+e,e);
        }
    }


    /**
     * 弃用  这个是创建中台用户的方法
     * @param userCreateDTO
     * @return
     */
    public Long createUser(UserCreateDTO userCreateDTO){
        log.info("创建用户信息"+ JSON.toJSONString(userCreateDTO));
        if(Objects.isNull(userCreateDTO)){
            throw new com.el.coordinator.core.common.exception.BusinessException("用户信息为空");
        }
        cn.hutool.core.lang.Assert.notNull(userCreateDTO.getUsername(), "账号为空");
        try {
            ApiResult<Long> res = userRpcService.upsert(userCreateDTO);
            log.info("返回的用户信息"+JSON.toJSONString(res));
            if(res.isSuccess()){
                return res.getData();
            }
            return null;
        }catch (Exception e){
            throw new com.el.coordinator.core.common.exception.BusinessException("创建用户信息失败"+e,e);
        }
    }

    public SysUserDTO currentUser(){
        try {
            return sysUserRpcService.current();
        }catch (Exception e){
            log.error("获取当前用户信息失败", e);
            throw new BusinessException("获取当前用户信息失败"+e,e);
        }
    }

    /**
     * 根据用户id集合获取用户信息
     *
     * @param userIds 登录号
     * @return 用户信息
     */
    @Deprecated
    public List<SysUserVO> getUsers(List<Long> userIds) {
        Assert.notNull(userIds, "用户集合为空");

        List<SysUserVO> sysUserVOS = sysUserRpcService.getByIds(userIds);
        if (sysUserVOS == null) {
            log.info("未查询到用户信息：{}", userIds);
            return Collections.emptyList();
        }
        return sysUserVOS;
    }

    /**
     * 查询用户信息
     *
     * @param param 查询参数
     * @return 用户信息
     */
    public List<SysUserRpcDTO> findUserRpcDtoByParam(SysUserRpcDtoParam param) {
        Assert.notNull(param, "查询用户信息参数为空");

        var users = sysUserRpcService.findUserRpcDtoByParam(param);
        if (CollUtil.isEmpty(users)) {
            log.info("未查询到用户信息，查询参数：{}", param);
            return Collections.emptyList();
        }
        return users;
    }

}