package com.elitesland.yst.production.sale.rmi.ystsystem;

import com.elitescloud.boot.core.base.UdcProvider;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 功能说明:
 * </p>
 *
 * @Author Darren
 * @Date 2023/04/18
 * @Version 1.0
 * @Content:
 */
@Component
@Slf4j
public class RmiUdcService {
    @Autowired
    private UdcProvider udcProvider;

    /**
     * 根据UDC编码获取UDC值
     *
     * @param appCode
     * @param udcCode
     * @return
     */
    public Map<String, String> getUdcMapByUdcCode(String appCode, String udcCode) {
        try {
            Map<String, String> codeMap = udcProvider.getValueMapByUdcCode(appCode, udcCode);
            return codeMap;
        } catch (Exception e) {
            log.error("getUdcMapByUdcCode error:", e);
        }
        return new HashMap<>();
    }

}
