package com.elitesland.yst.production.sale.service;

import cn.hutool.core.collection.IterUtil;
import com.elitesland.yst.production.sale.api.service.LogisticsTemplateService;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateDetailSaveParam;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateParam;
import com.elitesland.yst.production.sale.api.vo.param.logistics.LogisticsTemplateSaveParam;
import com.elitesland.yst.production.sale.api.vo.param.logistics.TemplateDetailComputeParam;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.BaseAreaVO;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateDVO;
import com.elitesland.yst.production.sale.api.vo.resp.logistics.LogisticsTemplateVO;
import com.elitesland.yst.production.sale.common.constant.UdcEnum;
import com.elitesland.yst.production.sale.common.model.CurrentUserDTO;
import com.elitesland.yst.production.sale.core.service.UserService;
import com.elitesland.yst.production.sale.entity.*;
import com.elitesland.yst.production.sale.repo.BaseAreaRepo;
import com.elitesland.yst.production.sale.repo.LogisticsTemplateDRepo;
import com.elitesland.yst.production.sale.repo.LogisticsTemplateRepo;
import com.elitesland.yst.production.sale.repo.LogisticsTemplateRepoProc;
import com.elitesland.yst.production.sale.rmi.ystsystem.RmiSysNextNumberService;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.yst.production.support.provider.org.dto.OrgUserEmpInfoRpcDTO;
import com.elitesland.yst.production.support.provider.org.service.OrgBuRpcService;
import com.elitesland.yst.production.support.provider.org.service.OrgEmpRpcService;
import com.google.common.collect.Lists;
import com.querydsl.core.types.dsl.BooleanExpression;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;


@Service
@Slf4j
@RequiredArgsConstructor
public class LogisticsTemplateServiceImpl implements LogisticsTemplateService {


    private final OrgBuRpcService orgBuRpcService;

    private final LogisticsTemplateRepoProc logisticsTemplateRepoProc;

    private final LogisticsTemplateRepo logisticsTemplateRepo;

    private final RmiSysNextNumberService rmiSysNextNumberService;

    private final LogisticsTemplateDRepo logisticsTemplateDRepo;

    private final OrgEmpRpcService orgEmpRpcService;

    private final BaseAreaRepo baseAreaRepo;


    @Override
    @SysCodeProc
    public LogisticsTemplateVO findCouponById(Long id) {
        //获取当前用户的ou
        Optional<LogisticsTemplateDO> optional = logisticsTemplateRepo.findById(id);
        if(optional.isPresent()){
            LogisticsTemplateDO logisticsTemplateDO = optional.get();
            LogisticsTemplateVO logisticsTemplateVO = new LogisticsTemplateVO();
            BeanUtils.copyProperties(logisticsTemplateDO,logisticsTemplateVO);
        //    logisticsTemplateVO.setShipAddress(logisticsTemplateDO.getProvinceName()+"-"+logisticsTemplateDO.getCityName());
            QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
            BooleanExpression expr = qLogisticsTemplateDDO.templateId.eq(id).and(qLogisticsTemplateDDO.deleteFlag.eq(0));
            Iterable<LogisticsTemplateDDO> iterables = logisticsTemplateDRepo.findAll(expr);
            List<LogisticsTemplateDVO> resList = new ArrayList<>();
            if(!IterUtil.isEmpty(iterables)){
                List<LogisticsTemplateDDO> list = Lists.newArrayList(iterables);
                list.stream().forEach(l ->{
                    LogisticsTemplateDVO logisticsTemplateDVO = new LogisticsTemplateDVO();
                    BeanUtils.copyProperties(l,logisticsTemplateDVO);
                    resList.add(logisticsTemplateDVO);
                });
                logisticsTemplateVO.setList(resList);
            }
            return logisticsTemplateVO;
        }
        return null;
    }

    @Override
    @SysCodeProc
    public PagingVO<LogisticsTemplateVO> findPagingResult(LogisticsTemplateParam logisticsTemplateParam) {
        //获取当前用户的ou
//        if(null == logisticsTemplateParam.getOuId()){
//            OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
//            if(null == empInfo.getOuId()){
//                return new PagingVO<>();
//            }
//            logisticsTemplateParam.setOuId(empInfo.getOuId());
//        }
        PagingVO<LogisticsTemplateVO> list = logisticsTemplateRepoProc.findPagingResult(logisticsTemplateParam);
//        List<LogisticsTemplateVO> vos = list.getRecords();
//        if(null != vos && !vos.isEmpty()){
//            list.getRecords().stream().forEach(l ->{
//                l.setShipAddress(l.getProvinceName()+"-"+l.getCityName());
//            });
//        }
        return list;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public ApiResult<Object> saveLogistics(LogisticsTemplateSaveParam logisticsTemplateParam) {
        if(null != logisticsTemplateParam){
            List<LogisticsTemplateDetailSaveParam> detailList = logisticsTemplateParam.getList();
            if(null != detailList && !detailList.isEmpty()){
                List<String> cityList = detailList.stream().map(LogisticsTemplateDetailSaveParam :: getCityCode).collect(Collectors.toList());
                Set<String> citySet = new HashSet<>(cityList);
                if(cityList.size() != citySet.size()){
                    return ApiResult.fail("市不能重复");
                }
            }
            OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
            LogisticsTemplateDO logisticsTemplateDO = new LogisticsTemplateDO();
            if(null == logisticsTemplateParam.getId()){
                //新增
                BeanUtils.copyProperties(logisticsTemplateParam,logisticsTemplateDO);
                logisticsTemplateDO.setStatus(UdcEnum.LOGISTICS_TEMPLATE_STATUS_DISABLE.getValueCode());
                String logisticsCode = rmiSysNextNumberService.generateCode("yst-sale","LOGISTICS_TEMPLATE", new ArrayList<>());
                logisticsTemplateDO.setLogisticsCode(logisticsCode);

                logisticsTemplateDO.setSecBuId(empInfo.getBuId());
                logisticsTemplateDO.setSecOuId(empInfo.getOuId());
                logisticsTemplateDO.setSecUserId(empInfo.getUserId());
//                OrgUserEmpInfoRpcDTO empInfo = getCurrentEmpInfo();
//                if(null != empInfo.getOuId()){
//                    logisticsTemplateDO.setOuId(empInfo.getOuId());
//                }
//                if(StringUtil.isNotBlank(empInfo.getOuName())){
//                    logisticsTemplateDO.setOuName(empInfo.getOuName());
//                }
            }else {
                //修改
                Optional<LogisticsTemplateDO> optional = logisticsTemplateRepo.findById(logisticsTemplateParam.getId());
                logisticsTemplateDO = optional.get();
                logisticsTemplateDO.setLogisticsCode(logisticsTemplateParam.getLogisticsCode());
                logisticsTemplateDO.setLogisticsName(logisticsTemplateParam.getLogisticsName());
                logisticsTemplateDO.setLogisticDesc(logisticsTemplateParam.getLogisticDesc());
                logisticsTemplateDO.setProvinceName(logisticsTemplateParam.getProvinceName());
                logisticsTemplateDO.setCityName(logisticsTemplateParam.getCityName());
                logisticsTemplateDO.setProvinceCode(logisticsTemplateParam.getProvinceCode());
                logisticsTemplateDO.setCityCode(logisticsTemplateParam.getCityCode());
                logisticsTemplateDO.setOuId(logisticsTemplateParam.getOuId());
                logisticsTemplateDO.setOuName(logisticsTemplateParam.getOuName());
            }
            logisticsTemplateDO = logisticsTemplateRepo.save(logisticsTemplateDO);
            //操作明细 删除再添加
            List<LogisticsTemplateDetailSaveParam> list = logisticsTemplateParam.getList();
            if(!list.isEmpty()){
                //删除
                QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
                BooleanExpression expression = qLogisticsTemplateDDO.templateId.eq(logisticsTemplateDO.getId()).and(qLogisticsTemplateDDO.deleteFlag.eq(0));
                Iterable<LogisticsTemplateDDO> iterables = logisticsTemplateDRepo.findAll(expression);
                if(!IterUtil.isEmpty(iterables)){
                    List<LogisticsTemplateDDO> lists = Lists.newArrayList(iterables);
                    lists.stream().forEach(l ->{
                        l.setDeleteFlag(1);
                        logisticsTemplateDRepo.save(l);
                    });
                }
                LogisticsTemplateDO finalLogisticsTemplateDO = logisticsTemplateDO;
                list.stream().forEach(l ->{
                    LogisticsTemplateDDO logisticsTemplateDDO = new LogisticsTemplateDDO();
                    int max = getMaxLineNo(finalLogisticsTemplateDO.getId());
                    //新增
                    BeanUtils.copyProperties(l,logisticsTemplateDDO);
                    //行号
                    logisticsTemplateDDO.setLinNo(max + 1);
                    logisticsTemplateDDO.setTemplateId(finalLogisticsTemplateDO.getId());
                    logisticsTemplateDDO.setOuId(finalLogisticsTemplateDO.getOuId());
                    logisticsTemplateDDO.setOuName(finalLogisticsTemplateDO.getOuName());
                    logisticsTemplateDRepo.save(logisticsTemplateDDO);
                });

            }
        }
        return ApiResult.ok();
    }

    public String getNameByCode(String code){
        if(StringUtils.isNotBlank(code)){
            QBaseAreaDO qBaseAreaDO = QBaseAreaDO.baseAreaDO;
            BooleanExpression expression = qBaseAreaDO.id.eq(Long.parseLong(code));
            Optional<BaseAreaDO> optional = baseAreaRepo.findOne(expression);
            if(optional.isPresent()){
                return optional.get().getName();
            }
        }
        return "";
    }

    /**
     * 查询最大行号
     * @param templateId
     * @return
     */
    public Integer getMaxLineNo(Long templateId){
        QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
        BooleanExpression expression = qLogisticsTemplateDDO.templateId.eq(templateId);
        Iterable<LogisticsTemplateDDO> iterables = logisticsTemplateDRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            List<LogisticsTemplateDDO> list = Lists.newArrayList(iterables);
            int max = list.stream().mapToInt(l -> l.getLinNo()).max().getAsInt();
            return max;
        }
        return 0;
    }

    @Override
    public ApiResult<Object> delLogistics(List<Long> ids) {
        if(null != ids && !ids.isEmpty()){
            QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
           ids.stream().forEach(id ->{
               //先删除明细
               BooleanExpression expression = qLogisticsTemplateDDO.templateId.eq(id).and(qLogisticsTemplateDDO.deleteFlag.eq(0));
               Iterable<LogisticsTemplateDDO> iterables = logisticsTemplateDRepo.findAll(expression);
               if(null != iterables){
                   logisticsTemplateDRepo.deleteAll(iterables);
               }
               logisticsTemplateRepo.deleteById(id);
           });
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Object> openLogistics(List<Long> ids) {
        if(null != ids && !ids.isEmpty()){
            ids.stream().forEach(id ->{
                Optional<LogisticsTemplateDO> optional = logisticsTemplateRepo.findById(id);
                if(optional.isPresent()){
                    LogisticsTemplateDO logisticsTemplateDO = optional.get();
                    logisticsTemplateDO.setStatus(UdcEnum.LOGISTICS_TEMPLATE_STATUS_ENABLE.getValueCode());
                    logisticsTemplateRepo.save(logisticsTemplateDO);
                }
            });
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<Object> stopLogistics(List<Long> ids) {
        if(null != ids && !ids.isEmpty()){
            ids.stream().forEach(id ->{
                Optional<LogisticsTemplateDO> optional = logisticsTemplateRepo.findById(id);
                if(optional.isPresent()){
                    LogisticsTemplateDO logisticsTemplateDO = optional.get();
                    logisticsTemplateDO.setStatus(UdcEnum.LOGISTICS_TEMPLATE_STATUS_DISABLE.getValueCode());
                    logisticsTemplateRepo.save(logisticsTemplateDO);
                }
            });
        }
        return ApiResult.ok();
    }

    @Override
    public List<BaseAreaVO> getProvince() {
        QBaseAreaDO qBaseAreaDO = QBaseAreaDO.baseAreaDO;
        BooleanExpression expression = qBaseAreaDO.pid.eq(0L).and(qBaseAreaDO.id.notIn(1L)).and(qBaseAreaDO.deleteFlag.eq(0));
        Iterable<BaseAreaDO> iterables = baseAreaRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            List<BaseAreaVO> resList = new ArrayList<>();
            List<BaseAreaDO> list = Lists.newArrayList(iterables);
            list.stream().forEach(l ->{
                BaseAreaVO baseAreaVO = new BaseAreaVO();
                BeanUtils.copyProperties(l,baseAreaVO);
                resList.add(baseAreaVO);
            });
            return resList;
        }
        return null;
    }

    @Override
    public List<BaseAreaVO> getCityByProvince(Long id) {
        QBaseAreaDO qBaseAreaDO = QBaseAreaDO.baseAreaDO;
        BooleanExpression expression = qBaseAreaDO.pid.eq(id).and(qBaseAreaDO.deleteFlag.eq(0));
        Iterable<BaseAreaDO> iterables = baseAreaRepo.findAll(expression);
        if(!IterUtil.isEmpty(iterables)){
            List<BaseAreaVO> resList = new ArrayList<>();
            List<BaseAreaDO> list = Lists.newArrayList(iterables);
            list.stream().forEach(l ->{
                BaseAreaVO baseAreaVO = new BaseAreaVO();
                BeanUtils.copyProperties(l,baseAreaVO);
                resList.add(baseAreaVO);
            });
            return resList;
        }
        return null;
    }

    @Override
    public LogisticsTemplateDVO getTemplateDetail(TemplateDetailComputeParam templateDetailComputeParam) {
        QLogisticsTemplateDDO qLogisticsTemplateDDO = QLogisticsTemplateDDO.logisticsTemplateDDO;
        BooleanExpression templateDetailExpr = qLogisticsTemplateDDO.templateId.eq(templateDetailComputeParam.getTemplateId()).and(qLogisticsTemplateDDO.deleteFlag.eq(0)).and(qLogisticsTemplateDDO.cityCode.eq(templateDetailComputeParam.getCityCode()));
        Optional<LogisticsTemplateDDO> optional = logisticsTemplateDRepo.findOne(templateDetailExpr);
        if(optional.isPresent()){
            LogisticsTemplateDVO logisticsTemplateDVO = new LogisticsTemplateDVO();
            BeanUtils.copyProperties(optional.get(),logisticsTemplateDVO);
            return logisticsTemplateDVO;
        }
        return null;
    }




    private OrgUserEmpInfoRpcDTO getCurrentEmpInfo() {
        CurrentUserDTO currentUser = UserService.currentUser();
        if (currentUser == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "当前用户已失效,请重登录重试");
        }
        OrgUserEmpInfoRpcDTO userEmpInfo = orgEmpRpcService.findUserEmpInfo(currentUser.getUserId());
        if (userEmpInfo == null) {
            throw new BusinessException(ApiCode.BUSINESS_EXCEPTION, "无法获取当前用户信息");
        }
        return userEmpInfo;
    }

}
